/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.resendpaydetail;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.common.enums.AgencyPayStateEnum;
import kd.swc.hsas.common.enums.BankOfferEnum;
import kd.swc.hsas.common.enums.PayDetailPayEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PayDetailResendValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        HashSet<Long> calPersons = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : entities) {
            long calPersonId = entity.getDataEntity().getLong("calpersonid");
            calPersons.add(calPersonId);
        }
        OperateOption option = this.getOption();
        Map varMap = option.getVariables();
        String pageId = (String)varMap.get("pageId");
        ISWCAppCache appCache = SWCAppCache.get((String)pageId);
        String totalSetString = (String)appCache.get("totalCalPersonSet", String.class);
        Set totalSet = SWCStringUtils.isEmpty((String)totalSetString) ? new HashSet(16) : (Set)JSON.parseObject((String)totalSetString, Set.class);
        totalSet.addAll(calPersons);
        appCache.put("totalCalPersonSet", (Object)JSON.toJSONString(totalSet));
        HashMap<Long, Set<Long>> calTaskMap = new HashMap<Long, Set<Long>>(16);
        boolean isHaveError = this.getResendPayDetail(calPersons, calTaskMap);
        appCache.put("isError", (Object)isHaveError);
        if (calPersons.isEmpty()) {
            this.setDataEntities(null);
            return;
        }
        String calTaskPersonIdMap = (String)appCache.get("calTaskPersonIdMap", String.class);
        Map calTaskIdMap = SWCStringUtils.isEmpty((String)calTaskPersonIdMap) ? new HashMap(16) : (Map)JSON.parseObject((String)calTaskPersonIdMap, Map.class);
        calTaskMap.forEach((k, value) -> {
            List idList = calTaskIdMap.getOrDefault(k, new ArrayList());
            idList.addAll(value);
            calTaskIdMap.put(k, idList);
        });
        appCache.put("calTaskPersonIdMap", (Object)JSON.toJSONString(calTaskIdMap));
    }

    private boolean getResendPayDetail(Set<Long> calPersons, Map<Long, Set<Long>> calTaskMap) {
        long calPersonId;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_paydetail");
        if (calPersons.isEmpty()) {
            return true;
        }
        QFilter calTableFilter = new QFilter("calpersonid", "in", calPersons);
        QFilter abandonedFilter = new QFilter("abandonedstatus", "in", (Object)Boolean.FALSE);
        DynamicObject[] query = helper.query("caltask.id,calpersonid,paystate,bankofferstatus,onholdstatus,agencypaystate,abandonedstatus,acctmodifybill,approvebill.id,approvebill.billstatus", new QFilter[]{calTableFilter, abandonedFilter});
        if (query.length == 0) {
            calPersons.clear();
            return true;
        }
        boolean isHaveError = false;
        for (DynamicObject dynamicObject : query) {
            boolean isResend;
            calPersonId = dynamicObject.getLong("calpersonid");
            String approveStatus = dynamicObject.getString("approvebill.billstatus");
            String payState = dynamicObject.getString("paystate");
            String bankOfferStatus = dynamicObject.getString("bankofferstatus");
            String onHoldStatus = dynamicObject.getString("onholdstatus");
            String agencyPayState = dynamicObject.getString("agencypaystate");
            Boolean abandonedStatus = dynamicObject.getBoolean("abandonedstatus");
            String modifyBillStatus = dynamicObject.getString("acctmodifybill.billstatus");
            boolean bl = isResend = !((!PayDetailPayEnum.OBLIGATION.getCode().equals(payState) && (!PayDetailPayEnum.SAVE.getCode().equals(payState) || !SWCStringUtils.isEmpty((String)approveStatus) && !"E".equals(approveStatus) && !"C".equals(approveStatus) && !"F".equals(approveStatus)) || !AgencyPayStateEnum.NOT_GENERATE.getCode().equals(agencyPayState) || !BankOfferEnum.getBankOfferArray().contains(bankOfferStatus)) && !PayDetailPayEnum.PAYFAIL.getCode().equals(payState) || abandonedStatus != false || !SWCStringUtils.isEmpty((String)onHoldStatus) && !String.valueOf(OnHoldStatusEnum.STATUS_RELEASE.getCode()).equals(onHoldStatus) || !SWCStringUtils.isEmpty((String)modifyBillStatus) && !"E".equals(modifyBillStatus));
            if (!isResend) {
                calPersons.remove(calPersonId);
                isHaveError = true;
            }
            if (calPersons.isEmpty()) break;
        }
        for (DynamicObject dynamicObject : query) {
            calPersonId = dynamicObject.getLong("calpersonid");
            if (!calPersons.contains(calPersonId)) continue;
            long calTaskId = dynamicObject.getLong("caltask.id");
            Set list = calTaskMap.getOrDefault(calTaskId, new HashSet(16));
            list.add(calPersonId);
            calTaskMap.put(calTaskId, list);
        }
        return isHaveError;
    }
}

