/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;

public class SalaryFileDelValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (!dataEntity.getDataEntity().getString("status").equals("C")) continue;
            idList.add(dataEntity.getDataEntity().getLong("id"));
        }
        SWCDataServiceHelper serviceCalTableHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter qSalaryIdFilter = new QFilter("salaryfile", "in", idList);
        DynamicObject[] calTaskObjs = serviceCalTableHelper.query("salaryfile,caltask.number,calstatus", new QFilter[]{qSalaryIdFilter});
        Map<Long, List<DynamicObject>> calTaskMap = Arrays.stream(calTaskObjs).filter(obj -> !CalStateEnum.APPROVALED.getCode().equals(obj.getString("calstatus")) && !CalStateEnum.APPROVAL.getCode().equals(obj.getString("calstatus"))).collect(Collectors.groupingBy(obj -> obj.getLong("salaryfile.id")));
        String msg = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6863\u6848\u88ab\u6838\u7b97\u4efb\u52a1\u201c{0}\u201d\u5f15\u7528\u4e14\u6838\u7b97\u72b6\u6001\u4e3a{1}\uff0c\u8bf7\u5148\u5220\u9664\u6216\u5ba1\u6279\u8be5\u6838\u7b97\u4eba\u5458\u3002", (String)"SalaryFileDelValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (!calTaskMap.containsKey(dataEntity.getDataEntity().getLong("id"))) continue;
            List<DynamicObject> calTaskList = calTaskMap.get(dataEntity.getDataEntity().getLong("id"));
            for (DynamicObject calTaskObj : calTaskList) {
                this.addErrorMessage(dataEntity, MessageFormat.format(msg, calTaskObj.getString("caltask.number"), CalStateEnum.getDesc((String)calTaskObj.getString("calstatus"))));
            }
        }
    }
}

