/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsas.business.salaryfile.SalaryFileEmpPosOrgRelHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import org.apache.commons.collections.MapUtils;

public class SalaryFileDepEmpSaveValidator
extends SWCDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileDepEmpSaveValidator.class);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        Map<Long, List<Map<String, Object>>> depEmpSalaryMap = this.getDepEmpSalaryMap(dataEntities);
        Map<String, String> empIsEndWhenStopPayMap = this.getIsUpdatePayEndDateDataMap(dataEntities);
        Map<Long, List<DynamicObject>> empPosOrgRelMap = SalaryFileDepEmpSaveValidator.getEmpPosOrgRelBySalaryFileBoId(dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyobj = dataEntity.getDataEntity();
            this.validatePayRollGroupBsed(dataEntity);
            this.validateWorkRoleStartAndEndDate(dataEntity, depEmpSalaryMap);
            this.validatePayEndDate(dataEntity, empPosOrgRelMap, empIsEndWhenStopPayMap);
        }
    }

    private void validatePayEndDate(ExtendedDataEntity dataEntity, Map<Long, List<DynamicObject>> depEmpSalaryMap, Map<String, String> empIsEndWhenStopPayMap) {
        DynamicObject data = dataEntity.getDataEntity();
        long salaryFileId = data.getLong("id");
        List depEmpRelList = depEmpSalaryMap.getOrDefault(salaryFileId, Collections.emptyList());
        if (CollectionUtils.isEmpty(depEmpSalaryMap)) {
            return;
        }
        String payStatus = data.getString("paystatus");
        if (!"0".equals(payStatus) || !"C".equalsIgnoreCase(data.getString("status"))) {
            return;
        }
        Date bsed = data.getDate("bsed");
        Date bsled = data.getDate("bsled");
        long depEmpId = data.getLong("depemp.id");
        Date date = SWCDateTimeUtils.addDay((Date)bsed, (long)-1L);
        String isUpdatePayEndDate = MapUtils.getString(empIsEndWhenStopPayMap, (Object)String.valueOf(salaryFileId), (String)"0");
        if (!"1".equals(isUpdatePayEndDate)) {
            return;
        }
        for (DynamicObject dynamicObject : depEmpRelList) {
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entry)) continue;
            Date payStartDate = null;
            Date startDate = null;
            Date payEndDate = null;
            for (DynamicObject row : entry) {
                long wrId = row.getLong("workrole.id");
                if (depEmpId != wrId) continue;
                payStartDate = this.getMinDate(payStartDate, row.getDate("paystartdate"));
                startDate = this.getMinDate(startDate, row.getDate("workrole.startdate"));
                payEndDate = this.getMaxDate(payEndDate, row.getDate("payenddate"));
            }
            if (payStartDate != null && startDate != null) {
                if (SWCDateTimeUtils.dayAfter(payStartDate, (Date)date)) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u66f4\u65b0\uff1a\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7b97\u85aa\u5f00\u59cb\u65e5\u671f{0}\u3002", (String)"SalaryFileDepEmpSaveValidator_4", (String)"swc-hsas-opplugin", (Object[])new Object[]{SWCDateTimeUtils.formatDate((Date)payStartDate)}));
                }
                if (SWCDateTimeUtils.dayAfter(startDate, (Date)date)) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u66f4\u65b0\uff1a\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4efb\u804c\u5f00\u59cb\u65e5\u671f{0}\u3002", (String)"SalaryFileDepEmpSaveValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[]{SWCDateTimeUtils.formatDate(startDate)}));
                }
            }
            if (bsled == null || payEndDate == null || !SWCDateTimeUtils.dayBefore((Date)bsled, payEndDate)) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6863\u6848\u7248\u672c\u7684\u5931\u6548\u65e5\u671f\u65e9\u4e8e\u6700\u665a\u7b97\u85aa\u7ed3\u675f\u65e5\u671f{0}\uff0c\u65e0\u6cd5\u66f4\u65b0\u7b97\u85aa\u7ed3\u675f\u65e5\u671f\u3002", (String)"SalaryFileDepEmpSaveValidator_5", (String)"swc-hsas-opplugin", (Object[])new Object[]{SWCDateTimeUtils.formatDate(payEndDate)}));
        }
    }

    private Date getMinDate(Date first, Date second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return SWCDateTimeUtils.dayBefore((Date)first, (Date)second) ? first : second;
    }

    private Date getMaxDate(Date first, Date second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return SWCDateTimeUtils.dayAfter((Date)first, (Date)second) ? first : second;
    }

    private static Map<Long, List<DynamicObject>> getEmpPosOrgRelBySalaryFileBoId(ExtendedDataEntity[] dataEntities) {
        Set salaryFileBoIds = Arrays.stream(dataEntities).map(item -> item.getDataEntity().getLong("boid")).collect(Collectors.toSet());
        SWCDataServiceHelper empPosOrgRelOrm = new SWCDataServiceHelper("hsas_empposorgrel");
        DynamicObject[] queryResult = empPosOrgRelOrm.query(SWCHisBaseDataHelper.getSelectProperties((String)"hsas_empposorgrel"), new QFilter[]{new QFilter("salaryfile.id", "in", salaryFileBoIds)});
        if (queryResult == null || queryResult.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>(16);
        for (DynamicObject dynamicObject : queryResult) {
            long boId = dynamicObject.getLong("salaryfile.id");
            List tempList = result.computeIfAbsent(boId, item -> new ArrayList(10));
            tempList.add(dynamicObject);
        }
        return result;
    }

    private Map<String, String> getIsUpdatePayEndDateDataMap(ExtendedDataEntity[] dataEntities) {
        RefObject refObject = new RefObject();
        this.getOption().tryGetVariableValue("empIsEndWhenStopPay", refObject);
        String empIsEndWhenStopPayJson = (String)refObject.getValue();
        HashMap<String, String> empIsEndWhenStopPayMap = null;
        if (!SWCStringUtils.isEmpty((String)empIsEndWhenStopPayJson)) {
            try {
                empIsEndWhenStopPayMap = SWCJSONUtils.convertJSONObjectToMap((Object)empIsEndWhenStopPayJson);
            }
            catch (Exception ex) {
                LOGGER.info("parse json error. input ={}", (Object)empIsEndWhenStopPayJson, (Object)ex);
            }
        }
        if (empIsEndWhenStopPayMap == null) {
            empIsEndWhenStopPayMap = new HashMap<String, String>(16);
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long salaryFileId = dynamicObject.getLong("id");
            boolean isUpdatePayEndData = dynamicObject.getBoolean("isupdatepayenddate");
            empIsEndWhenStopPayMap.compute(String.valueOf(salaryFileId), (key, lastValue) -> {
                if (isUpdatePayEndData || "1".equals(lastValue)) {
                    return "1";
                }
                return "0";
            });
        }
        return empIsEndWhenStopPayMap;
    }

    private Map<Long, List<Map<String, Object>>> getDepEmpSalaryMap(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return null;
        }
        Set depEmpIdSet = Arrays.stream(dataEntities).map(item -> item.getDataEntity().getLong("depemp.id")).collect(Collectors.toSet());
        List empPosOrgRelByDepEmpList = SalaryFileEmpPosOrgRelHelper.getEmpPosOrgRelByDepEmpId(depEmpIdSet);
        return SalaryFileEmpPosOrgRelHelper.getEmpDepDateMap((List)empPosOrgRelByDepEmpList, depEmpIdSet);
    }

    private void validatePayRollGroupBsed(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        Date date = data.getDate("payrollgroup.firstbsed");
        Date bsed = data.getDate("bsed");
        if (bsed == null || date == null) {
            return;
        }
        if (bsed.before(date)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u85aa\u8d44\u6863\u6848\u7684\u751f\u6548\u65e5\u671f\u4e0d\u5141\u8bb8\u65e9\u4e8e\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalaryFileDepEmpSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateBsed(ExtendedDataEntity dataEntity) {
        String empEndDateStr;
        String empStartDateStr;
        String bsedStr;
        DynamicObject data = dataEntity.getDataEntity();
        Date depEmpStartDate = data.getDate("depemp.startdate");
        Date depEmpEndDate = data.getDate("depemp.enddate");
        Date bsed = data.getDate("bsed");
        if (depEmpStartDate == null || depEmpEndDate == null || bsed == null) {
            return;
        }
        bsed = SWCDateTimeUtils.getDayDate((Date)bsed);
        depEmpStartDate = SWCDateTimeUtils.getDayDate((Date)depEmpStartDate);
        depEmpEndDate = SWCDateTimeUtils.getDayDate((Date)depEmpEndDate);
        String status = data.getString("status");
        RefObject statusDatas = new RefObject();
        this.getOption().tryGetVariableValue("pageStatus", statusDatas);
        String optionValue = (String)statusDatas.getValue();
        if (!SWCStringUtils.isEmpty((String)((String)statusDatas.getValue()))) {
            status = optionValue;
        }
        if ("A".equals(status) && (bsed.before(depEmpStartDate) || bsed.after(depEmpEndDate))) {
            bsedStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)"bsed", (Date)bsed);
            empStartDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_depemp", (String)"bsed", (Date)depEmpStartDate);
            empEndDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_depemp", (String)"startdate", (Date)depEmpEndDate);
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6863\u6848\u751f\u6548\u65e5\u671f {0} \u4e0d\u5141\u8bb8\u8d85\u51fa\u6240\u9009\u4e2d\u7684\u5c97\u4f4d\u7684\u65e5\u671f\u8303\u56f4 {1} \u81f3 {2}\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalaryFileDepEmpSaveValidator_1", (String)"swc-hsas-opplugin", (Object[])new Object[]{bsedStr, empStartDateStr, empEndDateStr}));
        }
        if ("C".equals(status) && bsed.before(depEmpStartDate)) {
            bsedStr = HRInteDateTimeUtil.formatDate((String)"hsas_salaryfile", (String)"bsed", (Date)bsed);
            empStartDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_depemp", (String)"bsed", (Date)depEmpStartDate);
            empEndDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_depemp", (String)"startdate", (Date)depEmpEndDate);
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6863\u6848\u751f\u6548\u65e5\u671f{0}\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u6240\u9009\u7684\u5c97\u4f4d\u7684\u5f00\u59cb\u65e5\u671f{1}\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalaryFileDepEmpSaveValidator_3", (String)"swc-hsas-opplugin", (Object[])new Object[]{bsedStr, empStartDateStr, empEndDateStr}));
        }
    }

    private void validateWorkRoleStartAndEndDate(ExtendedDataEntity dataEntity, Map<Long, List<Map<String, Object>>> depEmpSalaryMap) {
        String operateKey = this.getOperateKey();
        DynamicObject data = dataEntity.getDataEntity();
        if ("saveafteraudit".equalsIgnoreCase(operateKey) && "0".equalsIgnoreCase(data.getString("paystatus"))) {
            return;
        }
        if (depEmpSalaryMap == null || !SalaryFileEmpPosOrgRelHelper.isValidateDepEmpDateForFronted()) {
            return;
        }
        Date bsed = data.getDate("bsed");
        if (bsed == null) {
            return;
        }
        Date endDate = data.getDate("bsled");
        if (endDate == null) {
            endDate = SalaryFileEmpPosOrgRelHelper.getMaxDate();
        }
        long depEmpId = data.getLong("depemp.id");
        long salaryFileId = data.getLong("id");
        List<Map<String, Object>> maps = depEmpSalaryMap.get(depEmpId);
        if (CollectionUtils.isEmpty(maps)) {
            return;
        }
        for (Map<String, Object> map : maps) {
            Long workRoleId = (Long)map.get("workRoleId");
            if (depEmpId != workRoleId || Long.valueOf(salaryFileId).equals(map.get("salaryFileId"))) continue;
            Date payStartDate = (Date)map.get("payStartDate");
            Date payEndDate = (Date)map.get("payEndDate");
            Date date = payEndDate = payEndDate == null ? SalaryFileEmpPosOrgRelHelper.getMaxDate() : payEndDate;
            if (payStartDate == null || endDate == null) continue;
            boolean condition = bsed.before(payStartDate) && endDate.before(payStartDate) || bsed.after(payEndDate) && endDate.after(payEndDate);
            Object workRoleNumber = map.get("workRoleNumber");
            if (condition) continue;
            String payStartDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_empposorgrel", (String)"paystartdate", (Date)payStartDate);
            String payEndDateStr = HRInteDateTimeUtil.formatDate((String)"hsas_empposorgrel", (String)"payenddate", (Date)payEndDate);
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"{0}\uff1a\u6240\u9009\u62e9\u7684\u4e3b\u8981\u5c97\u4f4d\u5728\u201c{1}~{2}\u201d\u5df2\u88ab\u5173\u8054\u5230\u85aa\u8d44\u6863\u6848 {3}\uff0c\u4e0d\u5141\u8bb8\u65e5\u671f\u91cd\u590d\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"SalaryFileDepEmpSaveValidator_2", (String)"swc-hsas-opplugin", (Object[])new Object[]{workRoleNumber, payStartDateStr, payEndDateStr, map.get("salaryFileNumber")}));
        }
    }
}

