/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import org.apache.commons.lang3.StringUtils;

public class SalaryFileSaveValidator
extends SWCDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(SalaryFileSaveValidator.class);
    private static final String QUESTION_MARK = "?";
    private static final String FUSEORGID = "fuseorgid";
    private static final String FDATAID = "fdataid";
    public static final String PERSON_ID = "employee.person.id";
    public static final String EMPPOSINFO_ID = "empposinfo.id";
    public static final String PAYROLLGROUP_ID = "payrollgroup.id";
    public static final String ORG_ID = "org.id";
    public static final String PAYROLLREGION_ID = "payrollregion.id";

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        this.validateEmpOwner(dataEntities);
        this.validateExistsCodeRule(dataEntities);
        this.validateExcelUniqueKey(dataEntities);
        this.validateExcelUniqueNumber(dataEntities);
        List<Long> payrollgroupIds = this.validatePayrollGroupWithinPayrollregion(dataEntities);
        Map<Long, Long> payrollGroupUseOrgMap = this.queryPayrollGroupUseOrgs(payrollgroupIds);
        this.validateOrgIsEqualPayrollGroupUseOrg(dataEntities, payrollGroupUseOrgMap);
        this.validateSalaryCalStyle(dataEntities, payrollGroupUseOrgMap);
        this.validateEmpGroup(dataEntities);
    }

    private void validateEmpOwner(ExtendedDataEntity[] dataEntities) {
        String msgEmpG = ResManager.loadKDString((String)"\u8be5\u8ba1\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\u4e1a\u52a1\u7f16\u7801\u4e3a\u201c{0}\u201d\u7684\u4efb\u804c\u7ecf\u5386\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"SalaryFileSaveValidator_13", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long salaryFileEmployeeId;
            DynamicObject fileDy = dataEntity.getDataEntity();
            long empPersonId = fileDy.getLong("depemp.employee.id");
            if (empPersonId == (salaryFileEmployeeId = fileDy.getLong("employee.id"))) continue;
            this.addErrorMessage(dataEntity, MessageFormat.format(msgEmpG, fileDy.getString("depemp.number")));
        }
    }

    private void validateEmpGroup(ExtendedDataEntity[] dataEntities) {
        String msgEmpG = ResManager.loadKDString((String)"\u6240\u586b\u5199\u7684\u201c\u8ba1\u85aa\u4eba\u5458\u7ec4\u201d\u7684\u6240\u5c5e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u662f\u7b97\u53d1\u85aa\u7ba1\u7406\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SalaryFileSaveServiceHelper_10", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject fileDy = dataEntity.getDataEntity();
            long empgroupBussiId = fileDy.getLong("empgroup.bussinessfield.id");
            if (empgroupBussiId == 0L) {
                empgroupBussiId = fileDy.getLong("empgroup.bussinessfield_id");
            }
            if (empgroupBussiId == 107010L) continue;
            this.addErrorMessage(dataEntity, msgEmpG);
        }
    }

    private List<Long> validatePayrollGroupWithinPayrollregion(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, List<ExtendedDataEntity>> personAndDataEntityRel = new HashMap<Long, List<ExtendedDataEntity>>();
        ArrayList<Long> payrollgroupIds = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyobj = dataEntity.getDataEntity();
            this.putPersonDataEntityRel(personAndDataEntityRel, dyobj, dataEntity);
            payrollgroupIds.add(dyobj.getLong(PAYROLLGROUP_ID));
            this.validateIsPayrollGroupWithinPayrollregion(dataEntity, dyobj);
        }
        return payrollgroupIds;
    }

    private void validateExcelUniqueNumber(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        Set numbers = Arrays.stream(dataEntities).map(item -> item.getDataEntity().getString("number")).collect(Collectors.toSet());
        SWCDataServiceHelper salaryFileOrm = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter numberFilter = new QFilter("number", "in", numbers);
        BaseDataHisHelper.addHisCurrFilter((QFilter)enableFilter);
        DynamicObject[] dbResult = salaryFileOrm.query("id,employee,payrollgroup,empposinfo,org,payrollregion", new QFilter[]{statusFilter, enableFilter, numberFilter});
        Map<Object, Object> dbNumberMap = dbResult != null && dbResult.length > 0 ? Arrays.stream(dbResult).collect(Collectors.toMap(item -> item.getString("number"), Function.identity(), (first, second) -> second)) : new HashMap(16);
        HashSet<String> existNumber = new HashSet<String>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            String number = data.getString("number");
            if (SWCStringUtils.isEmpty((String)number)) continue;
            DynamicObject dbData = (DynamicObject)dbNumberMap.get(number);
            if (dbData != null && !SWCStringUtils.equals((String)this.getUniqKey(dbData), (String)this.getUniqKey(data))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6863\u6848\u7f16\u53f7\u201d \u503c \u201c{0}\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"SalaryFileSaveValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[]{number}));
                continue;
            }
            if (dbData != null || existNumber.add(number)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u6863\u6848\u7f16\u53f7\u201d \u503c \u201c{0}\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"SalaryFileSaveValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[]{number}));
        }
    }

    private void validateSalaryCalStyle(ExtendedDataEntity[] dataEntities, Map<Long, Long> payrollGroupUseOrgMap) {
        Map<Long, Set<Long>> useableSalaryCalsList = this.getUseableSalaryCalsList(dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateSalaryCountry(dataEntity, useableSalaryCalsList);
        }
    }

    private Map<Long, Set<Long>> getUseableSalaryCalsList(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return Collections.emptyMap();
        }
        HashSet<Long> orgSet = new HashSet<Long>(16);
        HashSet<Long> styleSet = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long styleId;
            DynamicObject temp = dataEntity.getDataEntity();
            long orgId = temp.getLong(ORG_ID);
            if (orgId != 0L) {
                orgSet.add(orgId);
            }
            if ((styleId = temp.getLong("salarycalcstyle.id")) == 0L) continue;
            styleSet.add(styleId);
        }
        return SalaryFileHelper.getUseableSalaryCalsList(orgSet, styleSet);
    }

    private void validateSalaryCountry(ExtendedDataEntity dataEntity, Map<Long, Set<Long>> useableSalaryCalsList) {
        DynamicObject salaryFileDyobj = dataEntity.getDataEntity();
        DynamicObject salaryStyle = salaryFileDyobj.getDynamicObject("salarycalcstyle");
        boolean condition = this.getCondition(salaryStyle, useableSalaryCalsList, salaryFileDyobj);
        if (!condition) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b97\u53d1\u85aa\u65b9\u5f0f\u7684\u4f7f\u7528\u7ec4\u7ec7\u548c\u56fd\u5bb6/\u5730\u533a\u4e0e\u6863\u6848\u4e0d\u4e00\u81f4\u3002", (String)"SalaryFileSaveValidator_9", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean getCondition(DynamicObject salaryStyle, Map<Long, Set<Long>> useableSalaryCalsList, DynamicObject dynamicObject) {
        if (salaryStyle == null) {
            return true;
        }
        long payRollRegionId = dynamicObject.getLong(PAYROLLREGION_ID);
        long key = dynamicObject.getLong("salarycalcstyle.id");
        String countryType = salaryStyle.getString("countrytype");
        long countryId = salaryStyle.getLong("country.id");
        long orgId = dynamicObject.getLong(ORG_ID);
        Set<Long> useableSalarySet = useableSalaryCalsList.get(key);
        if (payRollRegionId != countryId && "0".equals(countryType)) {
            return false;
        }
        String controlStrategy = salaryStyle.getString("ctrlstrategy");
        if ("5".equals(controlStrategy)) {
            return true;
        }
        return useableSalarySet != null && useableSalarySet.contains(orgId);
    }

    private void validateExcelUniqueKey(ExtendedDataEntity[] dataEntities) {
        int i;
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        SWCDataServiceHelper salaryFileOrm = new SWCDataServiceHelper("hsas_salaryfile");
        Set fileIdSet = Arrays.asList(dataEntities).stream().map(data -> data.getDataEntity().getLong("id")).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("id", "in", fileIdSet);
        DynamicObject[] fileArr = salaryFileOrm.query("id", new QFilter[]{idFilter});
        Set dbFileIdSet = Arrays.asList(fileArr).stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
        ArrayList<Long> personIds = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> payRollGroupIds = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> orgIds = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> payRollRegionIds = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> salaryFileIds = new ArrayList<Long>(dataEntities.length);
        HashSet<String> excelKeys = new HashSet<String>(dataEntities.length);
        HashMap<String, DynamicObject> existKeysBatch = new HashMap<String, DynamicObject>(dataEntities.length);
        for (int i2 = 0; i2 < dataEntities.length; ++i2) {
            ExtendedDataEntity extendedDataEntity = dataEntities[i2];
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            personIds.add(dataEntity.getLong(PERSON_ID));
            payRollGroupIds.add(dataEntity.getLong(PAYROLLGROUP_ID));
            orgIds.add(dataEntity.getLong(ORG_ID));
            payRollRegionIds.add(dataEntity.getLong(PAYROLLREGION_ID));
            salaryFileIds.add(dataEntity.getLong("id"));
            String uniqKey = this.getUniqKey(dataEntity);
            if ("A".equals(dataEntity.getString("status")) && !dbFileIdSet.contains(dataEntity.getPkValue()) && SWCStringUtils.isNotEmpty((String)uniqKey) && !excelKeys.add(uniqKey)) {
                String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u540c\u6279\u6b21\u5185\u5df2\u5b58\u5728\u85aa\u8d44\u6838\u7b97\u7ec4\u4e3a\u201c{2}\u201d\u7684\u85aa\u8d44\u6863\u6848\uff08{3}\uff09\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u8bf7\u4fee\u6539\u85aa\u8d44\u6863\u6848\u3002", (String)"SalaryFileSaveValidator_14", (String)"swc-hsas-opplugin", (Object[])new Object[]{dataEntity.get("employee.person.name"), dataEntity.get("employee.empnumber"), ((DynamicObject)existKeysBatch.get(uniqKey)).get("payrollgroup.name"), ((DynamicObject)existKeysBatch.get(uniqKey)).get("number")});
                this.addErrorMessage(extendedDataEntity, msg);
            }
            existKeysBatch.put(uniqKey, dataEntity);
        }
        QFilter personFilter = new QFilter(PERSON_ID, "in", personIds);
        QFilter payRollGroupFilter = new QFilter(PAYROLLGROUP_ID, "in", payRollGroupIds);
        QFilter orgFilter = new QFilter(ORG_ID, "in", orgIds);
        QFilter payRollRegionFilter = new QFilter(PAYROLLREGION_ID, "in", payRollRegionIds);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter salaryFilter = new QFilter("id", "not in", salaryFileIds);
        BaseDataHisHelper.addHisCurrFilter((QFilter)personFilter);
        DynamicObject[] queryResult = salaryFileOrm.query("id,employee,employee.person.id,payrollgroup,empposinfo,org,payrollregion", new QFilter[]{personFilter, payRollGroupFilter, orgFilter, payRollRegionFilter, enableFilter, statusFilter, salaryFilter});
        if (queryResult == null || queryResult.length == 0) {
            return;
        }
        HashMap<String, DynamicObject> existKeys = new HashMap<String, DynamicObject>(queryResult.length);
        for (i = 0; i < queryResult.length; ++i) {
            DynamicObject dynamicObject = queryResult[i];
            String uniquekey = this.getUniqKey(dynamicObject);
            if (SWCStringUtils.isEmpty((String)uniquekey)) continue;
            existKeys.put(uniquekey, dynamicObject);
        }
        for (i = 0; i < dataEntities.length; ++i) {
            DynamicObject existFile;
            ExtendedDataEntity extendedDataEntity = dataEntities[i];
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String uniquekey = this.getUniqKey(dataEntity);
            if (SWCStringUtils.isEmpty((String)uniquekey) || (existFile = (DynamicObject)existKeys.get(uniquekey)) == null || dbFileIdSet.contains(dataEntity.getPkValue()) || !"A".equals(dataEntity.getString("status"))) continue;
            String msg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u5df2\u5b58\u5728\u85aa\u8d44\u6838\u7b97\u7ec4\u4e3a{2}\u7684\u85aa\u8d44\u6863\u6848{3}\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u8bf7\u4fee\u6539\u85aa\u8d44\u6863\u6848\u3002", (String)"SalaryFileSaveValidator_10", (String)"swc-hsas-opplugin", (Object[])new Object[]{dataEntity.get("employee.person.name"), dataEntity.get("employee.empnumber"), existFile.get("payrollgroup.name"), existFile.get("number")});
            this.addErrorMessage(extendedDataEntity, msg);
        }
    }

    private String getUniqKey(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return "";
        }
        long personId = dynamicObject.getLong(PERSON_ID);
        long payRollGroupId = dynamicObject.getLong(PAYROLLGROUP_ID);
        long orgId = dynamicObject.getLong(ORG_ID);
        long payRollRegionId = dynamicObject.getLong(PAYROLLREGION_ID);
        if (personId == 0L || payRollGroupId == 0L || orgId == 0L || payRollRegionId == 0L) {
            return "";
        }
        StringBuilder result = new StringBuilder().append(personId).append(payRollGroupId).append(orgId).append(payRollRegionId);
        return result.toString();
    }

    private void validateOrgIsEqualPayrollGroupUseOrg(ExtendedDataEntity[] dataEntities, Map<Long, Long> payrollGroupUseOrgMap) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dyobj = dataEntity.getDataEntity();
            this.validateOrgAndPayrollGroup(dataEntity, dyobj, payrollGroupUseOrgMap);
        }
    }

    private Map<Long, Long> queryPayrollGroupUseOrgs(List<Long> payrollgroupIds) {
        HashMap<Long, Long> payrollGroupUseOrgMap = new HashMap<Long, Long>(payrollgroupIds.size());
        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append("FID, FORGID ").append("FROM T_HSAS_PAYROLLGRP ").append("WHERE FID IN (");
        int paramSize = payrollgroupIds.size();
        for (int i = 0; i < paramSize; ++i) {
            if (i != paramSize - 1) {
                sqlBuilder.append('?').append(',');
                continue;
            }
            sqlBuilder.append('?');
        }
        sqlBuilder.append(')');
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryPayrollGroupUseOrgs", (DBRoute)SWCConstants.SWC_ROUETE, (String)sqlBuilder.toString(), (Object[])payrollgroupIds.toArray(new Object[0]));){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long payrollGroupId = row.getLong("FID");
                payrollGroupUseOrgMap.put(payrollGroupId, row.getLong("FORGID"));
            }
        }
        return payrollGroupUseOrgMap;
    }

    private void putPersonDataEntityRel(Map<Long, List<ExtendedDataEntity>> personAndDataEntityRel, DynamicObject dyobj, ExtendedDataEntity dataEntity) {
        List<ExtendedDataEntity> extendedDataEntities = personAndDataEntityRel.get(dyobj.getLong(PERSON_ID));
        if (null != extendedDataEntities) {
            extendedDataEntities.add(dataEntity);
        } else {
            extendedDataEntities = new ArrayList<ExtendedDataEntity>();
            extendedDataEntities.add(dataEntity);
            personAndDataEntityRel.put(dyobj.getLong(PERSON_ID), extendedDataEntities);
        }
    }

    private void validateOrgAndPayrollGroup(ExtendedDataEntity dataEntity, DynamicObject dyobj, Map<Long, Long> payrollGroupUseOrgMap) {
        DynamicObject orgDyObj = dyobj.getDynamicObject("org");
        DynamicObject payrollGroupDyobj = dyobj.getDynamicObject("payrollgroup");
        if (null != orgDyObj && null != payrollGroupDyobj) {
            Long payrollGroupUseOrgId = payrollGroupUseOrgMap.get(payrollGroupDyobj.getLong("id"));
            this.validateIsOrgEqualsPayrollGroup(dataEntity, orgDyObj, payrollGroupDyobj, payrollGroupUseOrgId);
        }
    }

    private void validateIsOrgEqualsPayrollGroup(ExtendedDataEntity dataEntity, DynamicObject orgDyObj, DynamicObject payrollGroupDyobj, Long payrollGroupUseOrgId) {
        Long orgId = orgDyObj.getLong("id");
        if (!orgId.equals(payrollGroupUseOrgId)) {
            Map<String, Object> bosOrgMap = SalaryFileSaveValidator.getOrgProperty(payrollGroupUseOrgId, Collections.singletonList("name"));
            String errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0a\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e3a{0}\uff0c\u4e0e\u60a8\u5f55\u5165\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7{1}\u4e0d\u5339\u914d\u3002", (String)"SalaryFileSaveValidator_6", (String)"swc-hsas-opplugin", (Object[])new Object[]{bosOrgMap.get("name"), orgDyObj.getString("name")});
            this.addFatalErrorMessage(dataEntity, errorMsg);
        }
    }

    public static Map<String, Object> getOrgProperty(long orgId, List<String> propertyNameList) {
        if (orgId != 0L && !propertyNameList.isEmpty()) {
            StringBuilder selectProperties = new StringBuilder();
            boolean isFirstProperty = true;
            int proCount = propertyNameList.size();
            ArrayList<String> noRepeatList = new ArrayList<String>(proCount);
            for (String filters : propertyNameList) {
                if (StringUtils.isBlank((CharSequence)filters) || noRepeatList.contains(filters)) continue;
                if (isFirstProperty) {
                    isFirstProperty = false;
                } else {
                    selectProperties.append(',');
                }
                noRepeatList.add(filters);
                selectProperties.append(filters);
            }
            if (StringUtils.isBlank((CharSequence)selectProperties)) {
                return new HashMap<String, Object>(0);
            }
            QFilter idFilter1 = new QFilter("id", "=", (Object)orgId);
            QFilter[] filters1 = new QFilter[]{idFilter1};
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)selectProperties.toString(), (QFilter[])filters1);
            if (orgObj == null) {
                return new HashMap<String, Object>(0);
            }
            HashMap<String, Object> propertyMap = new HashMap<String, Object>(proCount + 1);
            propertyMap.put("id", orgId);
            for (String propertyName : noRepeatList) {
                propertyMap.put(propertyName, orgObj.get(propertyName));
            }
            return propertyMap;
        }
        return new HashMap<String, Object>(0);
    }

    private void validateIsPayrollGroupWithinPayrollregion(ExtendedDataEntity dataEntity, DynamicObject dyobj) {
        DynamicObject payrollGroupDyobj = dyobj.getDynamicObject("payrollgroup");
        long payrollregionId = dyobj.getLong(PAYROLLREGION_ID);
        if (null == payrollGroupDyobj || payrollregionId == 0L) {
            return;
        }
        long payrollGroupCountryId = payrollGroupDyobj.getLong("country.id");
        if (payrollGroupCountryId == 0L) {
            payrollGroupCountryId = payrollGroupDyobj.getLong("country_id");
        }
        if (payrollGroupCountryId != payrollregionId) {
            String errorMsg = ResManager.loadKDString((String)"\u85aa\u8d44\u6838\u7b97\u7ec4\u4e0a\u7684\u56fd\u5bb6/\u5730\u533a\u4e3a{0}\uff0c\u4e0e\u60a8\u5f55\u5165\u7684\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730{1}\u4e0d\u5339\u914d\u3002", (String)"SalaryFileSaveValidator_7", (String)"swc-hsas-opplugin", (Object[])new Object[]{payrollGroupDyobj.get("country.name"), dyobj.getString("payrollregion.name")});
            this.addFatalErrorMessage(dataEntity, errorMsg);
        }
    }

    private void validateExistsCodeRule(ExtendedDataEntity[] dataEntities) {
        String errorMsg = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7f3a\u5c11\u53ef\u7528\u7684\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u201c\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u201d\u3002", (String)"SalaryFileSaveValidator_12", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            CodeRuleInfo codeRuleInfo;
            DynamicObject dy = dataEntity.getDataEntity();
            if (!SWCStringUtils.isEmpty((String)dy.getString("number")) || !SWCObjectUtils.isEmpty((Object)(codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)"hsas_salaryfile", (DynamicObject)dy, null)))) continue;
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

