/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryfile.SalaryTaxFileRelServiceHelper;
import kd.swc.hsas.common.utils.BatchResult;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class TaxFileImportSaveValidator
extends SWCDataBaseValidator {
    private static Log LOGGER = LogFactory.getLog(TaxFileImportSaveValidator.class);

    public void validate() {
        if (SWCStringUtils.equals((String)this.getOption().getVariableValue("normalsave", "false"), (String)"true")) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.pushTaxFilesByApp(dataEntities);
    }

    private void pushTaxFilesByApp(ExtendedDataEntity[] dataEntities) {
        block4: {
            block3: {
                ArrayList taxFileTemps = Lists.newArrayListWithCapacity((int)dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    taxFileTemps.add(dataEntity.getDataEntity());
                }
                BatchResult batchResult = SalaryTaxFileRelServiceHelper.pushTaxFilesToItc((List)taxFileTemps, (String)"1", (String)"1");
                if (batchResult == null) break block3;
                LOGGER.info("by cyh pushTaxFilesByApp batchResult = {}", (Object)batchResult.getFailResult());
                List failTaxFileList = batchResult.getFailResult();
                if (CollectionUtils.isEmpty((Collection)failTaxFileList)) break block4;
                HashMap failTaxFileMap = new HashMap(failTaxFileList.size());
                failTaxFileList.forEach(obj -> failTaxFileMap.put(obj.getLong("id"), obj));
                LOGGER.info("by cyh pushTaxFilesByApp failTaxFileMap = {}", failTaxFileMap);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject taxFileTmp = dataEntity.getDataEntity();
                    Long id = taxFileTmp.getLong("id");
                    LOGGER.info("by cyh pushTaxFilesByApp tmip = {}", (Object)id);
                    if (!failTaxFileMap.containsKey(id)) continue;
                    taxFileTmp = (DynamicObject)failTaxFileMap.get(id);
                    int failreason = taxFileTmp.getInt("failreason");
                    String failmsg = taxFileTmp.getString("failmsg");
                    if (failreason == 0) continue;
                    this.addFatalErrorMessage(dataEntity, failmsg);
                }
                break block4;
            }
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u6821\u9a8c\u8fc7\u7a0b\u5f02\u5e38\uff1a\u63a8\u9001\u4e2a\u7a0e\u6863\u6848\u53d1\u751f\u7a0b\u5e8f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"TaxFileImportSaveValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
                LOGGER.info("error in TaxFileImportSaveValidator.pushTaxFilesByApp: batchResult is null");
            }
        }
    }
}

