/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.validator.salaryfile.paysetting;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsas.opplugin.validator.salaryfile.paysetting.PaySettingBaseValidator;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class PaySettingAmountAccuracyValidator
extends PaySettingBaseValidator {
    @Override
    List<String> validator(DynamicObject paySetting) {
        DynamicObjectCollection paySettingEntryCol = paySetting.getDynamicObjectCollection("entryentity");
        ArrayList<String> errMsg = new ArrayList<String>(10);
        for (int index = 0; index < paySettingEntryCol.size(); ++index) {
            DynamicObject entryData = (DynamicObject)paySettingEntryCol.get(index);
            String paymentWay = entryData.getString("paymentway");
            if (!SWCStringUtils.equals((String)"1", (String)paymentWay)) continue;
            String currencyName = entryData.getString("currency.name");
            BigDecimal payAmount = entryData.getBigDecimal("payamount");
            int payAmountScale = payAmount.stripTrailingZeros().scale();
            int scale = entryData.getInt("currency.amtprecision");
            if (scale >= payAmountScale) continue;
            errMsg.add(MessageFormat.format(ResManager.loadKDString((String)"\u201c\u85aa\u8d44\u53d1\u653e\u8bbe\u7f6e\u201d\u7b2c{0}\u884c\uff1a\u60a8\u8f93\u5165\u7684\u53d1\u653e\u91d1\u989d\u4e0e{1}\u91d1\u989d\u7cbe\u5ea6\u8981\u6c42:\u201c{2}\u4f4d\u5c0f\u6570\u201d\u4e0d\u5339\u914d,\u8bf7\u8c03\u6574\u3002", (String)"PaySettingAmountAccuracyValidator_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), index + 1, currencyName, scale));
        }
        if (errMsg.isEmpty() && this.getNextValidator() != null) {
            return this.getNextValidator().validator(paySetting);
        }
        return errMsg;
    }
}

