/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.accresult;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.business.accumulator.AccCalMutexUtils;
import kd.swc.hsas.opplugin.validator.accresult.AccResultDeleteValidator;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class AccResultDeleteOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("personindexid");
        evt.getFieldKeys().add("employee");
        evt.getFieldKeys().add("salaryfile");
    }

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new AccResultDeleteValidator());
    }

    public void rollbackOperation(RollbackOperationArgs args) {
        DynamicObject[] dataArr = args.getDataEntitys();
        this.releaseCalMutexData(dataArr);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataArr = args.getDataEntities();
        this.releaseCalMutexData(dataArr);
    }

    private void releaseCalMutexData(DynamicObject[] dataArr) {
        if (dataArr == null || dataArr.length == 0) {
            return;
        }
        Set personIndexIdSet = Arrays.asList(dataArr).stream().map(obj -> obj.getLong("personindexid")).collect(Collectors.toSet());
        AccCalMutexUtils.releaseSalaryCalMutexData(personIndexIdSet, (String)"3");
    }
}

