/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.accresult;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.accumulator.AccCalMutexUtils;
import kd.swc.hsas.opplugin.validator.accresult.AccResultSaveValidator;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class AccResultSaveOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("acc");
        args.getFieldKeys().add("employee");
        args.getFieldKeys().add("salaryfile");
        args.getFieldKeys().add("startdate");
        args.getFieldKeys().add("enddate");
        args.getFieldKeys().add("currency");
        args.getFieldKeys().add("resultvalue");
        args.getFieldKeys().add("adjustentry");
        args.getFieldKeys().add("personindexid");
        args.getFieldKeys().add("employee.person.id");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new AccResultSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] accResultArray;
        for (DynamicObject accResult : accResultArray = args.getDataEntities()) {
            long dataTypeId = accResult.getLong("acc.datatype.id");
            long dataRoundId = accResult.getLong("acc.dataround.id");
            int newScale = 1020L == dataTypeId ? accResult.getInt("currency.amtprecision") : ItemDataUtils.getScal((long)accResult.getLong("acc.dataprecision.id"));
            BigDecimal resultValue = accResult.getBigDecimal("resultvalue");
            resultValue = resultValue.setScale(newScale, ItemDataUtils.getRoundingMode((long)dataRoundId));
            accResult.set("resultvalue", (Object)resultValue);
            DynamicObjectCollection entryList = accResult.getDynamicObjectCollection("adjustentry");
            if (CollectionUtils.isEmpty((Collection)entryList)) continue;
            for (DynamicObject entry : entryList) {
                entry.set("adjustamount", (Object)resultValue);
            }
        }
    }

    public void rollbackOperation(RollbackOperationArgs args) {
        DynamicObject[] dataArr = args.getDataEntitys();
        this.releaseCalMutexData(dataArr);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataArr = args.getDataEntities();
        this.releaseCalMutexData(dataArr);
    }

    private void releaseCalMutexData(DynamicObject[] dataArr) {
        if (dataArr == null || dataArr.length == 0) {
            return;
        }
        Set personIndexIdSet = Arrays.asList(dataArr).stream().map(obj -> obj.getLong("personindexid")).collect(Collectors.toSet());
        AccCalMutexUtils.releaseSalaryCalMutexData(personIndexIdSet, (String)"3");
    }
}

