/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.accumulator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.opplugin.validator.accumulator.AccumulatorSaveValidator;
import kd.swc.hsbp.business.cal.helper.FormulaHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class AccumulatorSaveOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("uniquecode");
        fieldKeys.add("accmemberentry");
        fieldKeys.add("accmemberentry.bizitem");
        fieldKeys.add("accmemberentry.salaryitem");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new AccumulatorSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String opKey = args.getOperationKey();
        if (SWCStringUtils.equals((String)opKey, (String)"save")) {
            DynamicObject[] dyObjs;
            for (DynamicObject dynamicObject : dyObjs = args.getDataEntities()) {
                String number = dynamicObject.getString("number");
                dynamicObject.set("uniquecode", (Object)("AC_" + number));
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        HashMap uniqueCodeRelMap;
        DynamicObject[] datas = args.getDataEntities();
        Map<Long, String> dataMap = Arrays.stream(datas).filter(data -> data.getLong("id") != 0L).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("name")));
        Map changeMap = FormulaHelper.getChangeMap(dataMap, (String)"AC", uniqueCodeRelMap = new HashMap(16));
        if (!changeMap.isEmpty()) {
            FormulaHelper.updateCalElementName((Map)changeMap, uniqueCodeRelMap, (String)"AC");
        }
    }
}

