/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.agencypay;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.agencypay.AgencyPayWriteBackService;
import kd.swc.hsas.business.agencypay.payresult.AgentPayResultWriteBackHelper;
import kd.swc.hsas.common.enums.AgencyPayStateEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class AgencyPayDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs ar) {
        List fieldKeys = ar.getFieldKeys();
        fieldKeys.add("entryentity.paydetail");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] entities = args.getDataEntities();
        SWCDataServiceHelper detailHelper = new SWCDataServiceHelper("hsas_paydetail");
        HashSet billIds = Sets.newHashSetWithExpectedSize((int)entities.length);
        HashSet calPersonIdSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject entity : entities) {
            long billId = entity.getLong("id");
            billIds.add(billId);
        }
        QFilter filter = new QFilter("agencypaybill", "in", (Object)billIds);
        String selectProperties = "agencypaybill,agencypaystate,calpersonid,paystate";
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] paydetails = detailHelper.query(selectProperties, filters);
        if (paydetails == null) {
            return;
        }
        Set<Long> payDetailIds = Arrays.stream(paydetails).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> detailIdAndAgencyDynMap = this.getDetailIdAndAgencyDynMap(payDetailIds, billIds);
        if (detailIdAndAgencyDynMap == null) {
            detailIdAndAgencyDynMap = new HashMap<Long, DynamicObject>(0);
        }
        for (DynamicObject payDetail : paydetails) {
            long deailId = payDetail.getLong("id");
            DynamicObject agencyDyn = detailIdAndAgencyDynMap.get(deailId);
            if (agencyDyn != null) {
                payDetail.set("agencypaybill", agencyDyn.getParent());
                payDetail.set("agencypaystate", (Object)AgencyPayStateEnum.GENERATED.getCode());
                payDetail.set("paystate", (Object)AgentPayResultWriteBackHelper.getDetailPayState((String)agencyDyn.getString("paystate")));
            } else {
                payDetail.set("agencypaybill", (Object)0L);
                payDetail.set("agencypaystate", (Object)AgencyPayStateEnum.NOT_GENERATE.getCode());
            }
            calPersonIdSet.add(payDetail.getLong("calpersonid"));
        }
        detailHelper.update(paydetails);
        this.updateCaltablePaystate(calPersonIdSet);
    }

    private Map<Long, DynamicObject> getDetailIdAndAgencyDynMap(Set<Long> payDetailIds, Set<Long> agencyBillIds) {
        SWCDataServiceHelper agencyHelper = new SWCDataServiceHelper("hsas_agencypaybill");
        QFilter filter = new QFilter("entryentity.paydetail.id", "in", payDetailIds);
        filter.and("id", "not in", agencyBillIds);
        DynamicObject[] agencyQuery = agencyHelper.query("entryentity.paydetail,entryentity.paystate,id,createtime", new QFilter[]{filter}, "createtime");
        if (agencyQuery == null) {
            return null;
        }
        HashMap detailIdAndAgencyDynMap = Maps.newHashMapWithExpectedSize((int)payDetailIds.size());
        for (DynamicObject agencyDyn : agencyQuery) {
            DynamicObjectCollection agencyEntry = agencyDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : agencyEntry) {
                detailIdAndAgencyDynMap.put(entry.getLong("paydetail.id"), entry);
            }
        }
        return detailIdAndAgencyDynMap;
    }

    private void updateCaltablePaystate(Set<Long> caltableIdSet) {
        AgencyPayWriteBackService writeBackService = new AgencyPayWriteBackService();
        writeBackService.updateCaltablePayState(caltableIdSet);
    }
}

