/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.approvebill;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.approve.ApproveBillService;
import kd.swc.hsas.business.cal.helper.CalDetailHelper;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveBillPermValidator;
import kd.swc.hsas.opplugin.validator.approvebill.CalApproveDisapproveValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalStateEnum;
import kd.swc.hsbp.common.enums.PayStateEnum;

public class CalApproveDisapproveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CalApproveDisapproveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("calentryentity");
        fieldKeys.add("calentryentity.calpersonid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new CalApproveDisapproveValidator());
        args.addValidator((AbstractValidator)new CalApproveBillPermValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] calPersonArr;
        DynamicObject[] entities = args.getDataEntities();
        ArrayList<Long> pkIdList = new ArrayList<Long>(10);
        for (DynamicObject dynamicObject : entities) {
            pkIdList.add(dynamicObject.getLong("id"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_approvebill");
        DynamicObject[] approveBillList = ApproveBillService.getApproveBillList(pkIdList, (SWCDataServiceHelper)helper);
        ArrayList calPersonIds = new ArrayList(approveBillList.length);
        for (DynamicObject approveBillDy : approveBillList) {
            logger.info("disapprove op approvebillno is {}", (Object)approveBillDy.getString("billno"));
            DynamicObjectCollection approveBillEntry = approveBillDy.getDynamicObjectCollection("calentryentity");
            approveBillEntry.forEach(approveBillEnt -> calPersonIds.add(approveBillEnt.getLong("calpersonid")));
            approveBillDy.set("billstatus", (Object)"F");
        }
        ArrayList arrayList = new ArrayList(10);
        ArrayList updateCalStatusCalPersons = new ArrayList(10);
        List updatePayDetails = CalDetailHelper.unApproveHandlePayDetail(calPersonIds, arrayList, updateCalStatusCalPersons);
        logger.info("disapprove op calPersonIds is {}, updatePayDetails size is {}, updateCalStatusCalPersons is {}, updateStatusCalPersons is {}", new Object[]{JSON.toJSONString(calPersonIds), updatePayDetails.size(), JSON.toJSONString(updateCalStatusCalPersons), JSON.toJSONString(arrayList)});
        SWCDataServiceHelper payDetailDataServiceHelper = new SWCDataServiceHelper("hsas_paydetail");
        payDetailDataServiceHelper.update(updatePayDetails.toArray(new DynamicObject[0]));
        for (DynamicObject calPerson : calPersonArr = ApproveBillService.getCalPersonList(calPersonIds)) {
            if (arrayList.contains(calPerson.getLong("id"))) {
                calPerson.set("paystatus", (Object)PayStateEnum.UNCREATE.getCode());
            }
            calPerson.set("calstatus", (Object)CalStateEnum.AUDIT.getCode());
        }
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_person");
        calPersonHelper.update(calPersonArr);
        helper.update(approveBillList);
    }
}

