/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bankaccountmodifybill;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.opplugin.validator.bankaccountmodifybill.ModifyBillSaveValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class ModifyBillSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("perbankcard.id");
        fieldKeys.add("entryentity.paydetail");
        fieldKeys.add("entryentity.modifyperbankcard");
        fieldKeys.add("entryentity.modifypaydetail");
        fieldKeys.add("entryentity.acctmodifyreason");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ModifyBillSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] payDetails;
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        Long id = dataEntity.getLong("id");
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        HashSet<Long> payDetailIds = new HashSet<Long>(16);
        for (DynamicObject entry : collection) {
            DynamicObject payDetail = entry.getDynamicObject("paydetail");
            Long payDetailId = payDetail.getLong("id");
            payDetailIds.add(payDetailId);
        }
        SWCDataServiceHelper modifyBillHelper = new SWCDataServiceHelper("hsas_acctmodifybill");
        DynamicObject modifyBill = modifyBillHelper.queryOne("entryentity.paydetail", (Object)id);
        HashSet<Long> deletePayDetailIds = new HashSet<Long>(16);
        if (modifyBill != null) {
            DynamicObjectCollection modifyBillCollection = modifyBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : modifyBillCollection) {
                DynamicObject payDetail = entry.getDynamicObject("paydetail");
                Long payDetailId = payDetail.getLong("id");
                if (payDetailIds.contains(payDetailId)) continue;
                deletePayDetailIds.add(payDetailId);
            }
        }
        SWCDataServiceHelper payDetailHelper = new SWCDataServiceHelper("hsas_paydetail");
        payDetailIds.addAll(deletePayDetailIds);
        QFilter filter = new QFilter("id", "in", payDetailIds);
        for (DynamicObject payDetail : payDetails = payDetailHelper.query("id,acctmodifybill", new QFilter[]{filter})) {
            Long payDetailId = payDetail.getLong("id");
            if (deletePayDetailIds.contains(payDetailId)) {
                payDetail.set("acctmodifybill", (Object)0L);
                continue;
            }
            payDetail.set("acctmodifybill", (Object)id);
        }
        payDetailHelper.update(payDetails);
    }
}

