/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bankaccountmodifybill;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.paysalarysetting.paysetting.UpdatePaySettingService;
import kd.swc.hsbp.business.perbankcard.PerBankcardServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class ModifyBillStatusUpdateOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(ModifyBillStatusUpdateOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("entryentity.modifyperbankcard");
        fieldKeys.add("entryentity.modifypaydetail");
        fieldKeys.add("entryentity.salaryfilehis");
        fieldKeys.add("entryentity.salaryfilehis.person.id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        String billStatus = "";
        boolean isDelete = false;
        boolean isUpdate = false;
        if ("approvalling".equals(operationKey)) {
            billStatus = "D";
        } else if ("approvalpass".equals(operationKey)) {
            billStatus = "C";
            isUpdate = true;
        } else if ("approvalnotpass".equals(operationKey)) {
            billStatus = "E";
        } else if ("rejected".equals(operationKey)) {
            billStatus = "G";
        } else if ("rejecteddelete".equals(operationKey)) {
            billStatus = "G";
            isDelete = true;
        }
        UpdatePaySettingService service = new UpdatePaySettingService();
        ArrayList personIdList = new ArrayList(10);
        for (DynamicObject modifyBill : dataEntities) {
            modifyBill.set("billstatus", (Object)billStatus);
            DynamicObjectCollection dynamicObjectCollection = modifyBill.getDynamicObjectCollection("entryentity");
            if (isDelete) {
                for (DynamicObject entry2 : dynamicObjectCollection) {
                    entry2.set("modifyperbankcard", (Object)0L);
                }
            }
            if (isUpdate && PerBankcardServiceHelper.getUpdateSettingStatus().booleanValue()) {
                personIdList.addAll(dynamicObjectCollection.stream().map(entry -> entry.getLong("salaryfilehis.person.id")).collect(Collectors.toList()));
            }
            if (personIdList.isEmpty()) continue;
            String lockKey = "_updatePaySetting_payDetail";
            try (DLock lock = DLock.create((String)"_updatePaySetting_payDetail");){
                if (!lock.tryLock(5000L)) continue;
                service.synUpdatePaySetting(personIdList, Boolean.FALSE, Boolean.TRUE);
            }
            catch (Exception exception) {
                log.info("_updatePaySetting_payDetail_error :{}", (Object)exception.getMessage());
            }
        }
        SWCDataServiceHelper modifyBillHelper = new SWCDataServiceHelper("hsas_acctmodifybill");
        modifyBillHelper.update(dataEntities);
    }
}

