/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.basedata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.interaction.InteractionConfirmResult;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.opplugin.validator.basedata.CalItemGroupAndCalRuleImportValidator;
import kd.swc.hsas.opplugin.validator.basedata.CalRuleSaveValidator;
import kd.swc.hsas.opplugin.validator.basedata.TaxSwitchOffValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class CalRuleSaveOp
extends SWCDataBaseOp {
    private static final String[] areatypeFields = new String[]{"country", "areatype"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("datasource");
        fieldKeys.add("calruleitementry");
        fieldKeys.add("formula");
        fieldKeys.add("bsed");
        fieldKeys.add("ispayoutitem");
        fieldKeys.add("salaryitem");
        fieldKeys.add("isconvert");
        fieldKeys.add("customprorationrule");
        fieldKeys.add("country");
        fieldKeys.add("areatype");
        fieldKeys.add("opentaxcal");
        fieldKeys.add("salaryitem");
        fieldKeys.add("aftercaltype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CalRuleSaveValidator());
        e.addValidator((AbstractValidator)new CalItemGroupAndCalRuleImportValidator());
        e.addValidator((AbstractValidator)new TaxSwitchOffValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        this.filterCountryUpdate(e.getDataEntities());
        this.setOpenTaxCalVal(e.getDataEntities());
        this.showInteractionMessage(e, "confirmNoPayItem");
        if (this.getOption().containsVariable("confirmMsg")) {
            e.setCancel(!this.showInteractionMessage("confirmMsg"));
        }
        this.showInteractionMessage(e, "confirmTotalSalNoFormulaMsg");
        this.showInteractionMessage(e, "confirmNetSalNoFormulaMsg");
        this.showInteractionMessage(e, "confirmAllSalNoFormulaMsg");
    }

    private void setOpenTaxCalVal(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            String openTaxCal = dynamicObject.getString("opentaxcal");
            if (!SWCStringUtils.isEmpty((String)openTaxCal)) continue;
            dynamicObject.set("opentaxcal", (Object)"0");
        }
    }

    private void showInteractionMessage(BeforeOperationArgs e, String messageKey) {
        if (this.getOption().containsVariable(messageKey) && !this.getOption().containsVariable(messageKey.concat("_finish"))) {
            e.setCancel(!this.showInteractionMessage(messageKey));
        }
    }

    private boolean showInteractionMessage(String messageKey) {
        String confirmResultString = this.getOption().getVariableValue("interactionconfirmresult", "");
        InteractionConfirmResult confirmResult = InteractionConfirmResult.fromJsonString((String)confirmResultString);
        if (confirmResult.getResults().containsKey(this.getInteractionSponore())) {
            String result = (String)confirmResult.getResults().get(this.getInteractionSponore());
            this.getOption().setVariableValue("interactionconfirmresult", "");
            this.getOption().setVariableValue(messageKey + "_finish", "");
            return "Yes".equals(result);
        }
        InteractionContext interactionContext = new InteractionContext();
        interactionContext.setCustShowFormId("hsbp_confirmdlg");
        interactionContext.getCustShowParameter().put("message", this.getOption().getVariableValue(messageKey));
        throw new KDInteractionException(this.getInteractionSponore(), interactionContext);
    }

    private String getInteractionSponore() {
        return "kd.swc.hsas.opplugin.web.basedata.CalRuleSaveOp";
    }

    private void filterCountryUpdate(DynamicObject[] dynamicObjects) {
        long id;
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id2 = dynamicObject.getLong("id");
            if (id2 == 0L) continue;
            ids.add(id2);
        }
        if (ids.isEmpty()) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calrule");
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] dataStorageColl = helper.query("country,areatype", new QFilter[]{filter});
        HashMap<Long, DynamicObject> dataStorageMap = new HashMap<Long, DynamicObject>(dataStorageColl.length);
        for (DynamicObject dataStorage : dataStorageColl) {
            id = dataStorage.getLong("id");
            dataStorageMap.put(id, dataStorage);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            id = dynamicObject.getLong("id");
            if (id == 0L || dataStorageMap.get(id) == null) continue;
            DynamicObject dataStorage = (DynamicObject)dataStorageMap.get(id);
            for (String field : areatypeFields) {
                dynamicObject.set(field, dataStorage.get(field));
            }
        }
    }
}

