/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.basedata;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class PayrollGroupOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("number");
        fieldKeys.add("disabledate");
        fieldKeys.add("disabler");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] payrollGrps = e.getDataEntities();
        if (payrollGrps.length <= 0) {
            return;
        }
        switch (operationKey) {
            case "disable": 
            case "his_disable": {
                this.disablePayrollGrps(payrollGrps);
                break;
            }
            case "enable": {
                this.enablePayrollGrps(payrollGrps);
                break;
            }
        }
    }

    private void enablePayrollGrps(DynamicObject[] payrollGrps) {
        for (DynamicObject payrollGrp : payrollGrps) {
            payrollGrp.set("disabledate", null);
            payrollGrp.set("disabler", null);
            SWCDataServiceHelper calTplHelper = new SWCDataServiceHelper("hsas_caltasknewtpl");
            DynamicObject[] calTaskTpls = this.queryTplByGrp(payrollGrp);
            ArrayList<Long> calTplIdLists = new ArrayList<Long>(calTaskTpls.length);
            for (DynamicObject calTaskTpl : calTaskTpls) {
                calTplIdLists.add(calTaskTpl.getLong("id"));
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrpchgrec");
            QFilter qFilter = new QFilter("caltasknewtpl", "in", calTplIdLists);
            qFilter.and("ismark", "=", (Object)"0");
            DynamicObject[] records = helper.query("caltasknewtpl,ismark", qFilter.toArray());
            HashSet<Long> calTplIdSets = new HashSet<Long>(records.length);
            for (DynamicObject record : records) {
                calTplIdSets.add(record.getLong("caltasknewtpl.id"));
            }
            for (DynamicObject calTaskTpl : calTaskTpls) {
                if (calTplIdSets.contains(calTaskTpl.getLong("id"))) {
                    calTaskTpl.set("changestatus", (Object)"1");
                    continue;
                }
                calTaskTpl.set("changestatus", (Object)"0");
            }
            calTplHelper.save(calTaskTpls);
        }
    }

    private void disablePayrollGrps(DynamicObject[] payrollGrps) {
        for (DynamicObject payrollGrp : payrollGrps) {
            DynamicObject[] calTaskTpls;
            payrollGrp.set("disabledate", (Object)new Date());
            payrollGrp.set("disabler", (Object)RequestContext.get().getCurrUserId());
            SWCDataServiceHelper calTplHelper = new SWCDataServiceHelper("hsas_caltasknewtpl");
            for (DynamicObject calTaskTpl : calTaskTpls = this.queryTplByGrp(payrollGrp)) {
                calTaskTpl.set("changestatus", (Object)"2");
            }
            calTplHelper.save(calTaskTpls);
            for (DynamicObject needMsgTpl : calTaskTpls) {
                DynamicObject chargeperson = needMsgTpl.getDynamicObject("chargeperson");
                if (chargeperson == null) continue;
                long chargPersonId = chargeperson.getLong("id");
                String tplNumber = needMsgTpl.getString("number");
                String tplName = needMsgTpl.getString("name");
                String payrollGrpNumber = payrollGrp.getString("number");
                String grpModifyTimeStr = SWCInteDateTimeUtil.formatTimeWithUserZone((Date)new Date());
                this.sendUTplMessageTo((Long)needMsgTpl.getPkValue(), Collections.singletonList(chargPersonId), tplNumber, tplName, payrollGrpNumber, grpModifyTimeStr);
            }
        }
    }

    private void sendUTplMessageTo(Long pkId, List<Long> receviers, String tplNumber, String tplName, String grpNumber, String grpModifyTime) {
        MessageInfo message = new MessageInfo();
        message.setTitle(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u72b6\u6001\u66f4\u65b0\u63d0\u9192", (String)"PayrollGroupOp_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        message.setContent(MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u201c{0}\uff08{1}\uff09\u201d\uff0c\u6240\u4f9d\u8d56\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u201c{2}\u201d\u4f7f\u7528\u72b6\u6001\u53d8\u4e3a\u7981\u7528\uff1a\u7981\u7528\u65f6\u95f4\u4e3a{3}\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u6838\u7b97\u4efb\u52a1\u81ea\u52a8\u521b\u5efa\u5931\u8d25\uff0c\u5efa\u8bae\u5c06\u8be5\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u7981\u7528\u3002\u70b9\u51fb\u4e0b\u65b9\u201c\u5feb\u901f\u5904\u7406\u201d\u94fe\u63a5\u67e5\u770b\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u3002", (String)"PayrollGroupOp_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), tplNumber, tplName, grpNumber, grpModifyTime));
        message.setUserIds(receviers);
        message.setType("message");
        message.setEntityNumber("hsas_caltasknewtpl");
        message.setBizDataId(pkId);
        String clientUrl = UrlService.getDomainContextUrl();
        String url = String.format("%s/index.html?formId=%s&pkId=%d&type=base", clientUrl, "hsas_caltasknewtpl", pkId);
        message.setContentUrl(url);
        message.setNotifyType(MessageChannels.MC.toString());
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }

    private DynamicObject[] queryTplByGrp(DynamicObject payrollGrp) {
        SWCDataServiceHelper calTplHelper = new SWCDataServiceHelper("hsas_caltasknewtpl");
        QFilter calTplFilter = new QFilter("enable", "=", (Object)"1");
        calTplFilter.and("payrollgrp", "=", (Object)payrollGrp.getLong("id"));
        BaseDataHisHelper.addHisCurrFilter((QFilter)calTplFilter);
        return calTplHelper.query("changestatus,chargeperson.id,number,name", calTplFilter.toArray());
    }
}

