/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.basedata;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCInteDateTimeUtil;

public class PayrollGroupPeriodSaveOp
extends AbstractOperationServicePlugIn {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] payrollGrpVs = e.getDataEntities();
        if (payrollGrpVs.length == 1 && "confirmchange".equals(e.getOperationKey())) {
            this.modifyAndAuditPayrollGrpV(payrollGrpVs[0]);
        }
    }

    private void modifyAndAuditPayrollGrpV(DynamicObject payrollGrpV) {
        DynamicObject[] enabledCalTaskTpls = this.queryAndModifyCalTpls(payrollGrpV);
        SWCDataServiceHelper calTplHelper = new SWCDataServiceHelper("hsas_caltasknewtpl");
        QFilter calTplFilter = new QFilter("enable", "=", (Object)"0");
        calTplFilter.and("payrollgrp", "=", (Object)payrollGrpV.getLong("boid"));
        BaseDataHisHelper.addHisCurrFilter((QFilter)calTplFilter);
        DynamicObject[] disabledCalTaskTpls = calTplHelper.query("changestatus,chargeperson.id,number,name", calTplFilter.toArray());
        DynamicObject[] calTaskTplColl = Arrays.copyOf(enabledCalTaskTpls, enabledCalTaskTpls.length + disabledCalTaskTpls.length);
        System.arraycopy(disabledCalTaskTpls, 0, calTaskTplColl, enabledCalTaskTpls.length, disabledCalTaskTpls.length);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollgrpchgrec");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"hsas_payrollgrpchgrec");
        DynamicObjectCollection grpEffectDys = new DynamicObjectCollection();
        for (DynamicObject calTaskTpl : calTaskTplColl) {
            DynamicObject grpEffectDy = (DynamicObject)type.createInstance();
            grpEffectDy.set("payrollgrp", (Object)payrollGrpV.getLong("boid"));
            grpEffectDy.set("caltasknewtpl", (Object)calTaskTpl.getLong("id"));
            grpEffectDy.set("createtime", (Object)new Date());
            grpEffectDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            grpEffectDy.set("payrollgrpvbred", (Object)payrollGrpV.getDate("bsed"));
            grpEffectDys.add((Object)grpEffectDy);
        }
        helper.save(grpEffectDys);
        this.sendMsg(payrollGrpV, enabledCalTaskTpls);
    }

    private DynamicObject[] queryAndModifyCalTpls(DynamicObject payrollGrpV) {
        DynamicObject[] calTaskTpls;
        SWCDataServiceHelper calTplHelper = new SWCDataServiceHelper("hsas_caltasknewtpl");
        QFilter calTplFilter = new QFilter("enable", "=", (Object)"1");
        calTplFilter.and("payrollgrp", "=", (Object)payrollGrpV.getLong("boid"));
        BaseDataHisHelper.addHisCurrFilter((QFilter)calTplFilter);
        for (DynamicObject calTaskTpl : calTaskTpls = calTplHelper.query("changestatus,chargeperson.id,number,name", calTplFilter.toArray())) {
            calTaskTpl.set("changestatus", (Object)"1");
        }
        calTplHelper.save(calTaskTpls);
        return calTaskTpls;
    }

    private void sendMsg(DynamicObject payrollGrpV, DynamicObject[] calTaskTpls) {
        for (DynamicObject needMsgTpl : calTaskTpls) {
            DynamicObject chargeperson = needMsgTpl.getDynamicObject("chargeperson");
            if (chargeperson == null) continue;
            long chargPersonId = chargeperson.getLong("id");
            String tplNumber = needMsgTpl.getString("number");
            String tplName = needMsgTpl.getString("name");
            String payrollGrpNumber = payrollGrpV.getString("number");
            String grpBredStr = HRInteDateTimeUtil.formatDate((String)"hsas_payrollgrp", (String)"bsed", (Date)payrollGrpV.getDate("bsed"));
            String grpModifyTimeStr = SWCInteDateTimeUtil.formatTimeWithUserZone((Date)new Date());
            this.sendUTplMessageTo((Long)payrollGrpV.getPkValue(), Collections.singletonList(chargPersonId), tplNumber, tplName, payrollGrpNumber, grpBredStr, grpModifyTimeStr);
        }
    }

    private void sendUTplMessageTo(Long pkId, List<Long> receviers, String tplNumber, String tplName, String grpNumber, String grpBred, String grpModifyTime) {
        MessageInfo message = new MessageInfo();
        message.setTitle(ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u6570\u636e\u66f4\u65b0\u63d0\u9192", (String)"PayrollGroupPeriodSaveOp_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]));
        message.setContent(MessageFormat.format(ResManager.loadKDString((String)"\u60a8\u8d1f\u8d23\u7684\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u201c{0}\uff08{1}\uff09\u201d\uff0c\u6240\u4f9d\u8d56\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u201c{2}\u201d\u65b0\u589e\u6570\u636e\u7248\u672c\uff1a\u751f\u6548\u65e5\u671f\u4e3a{3}\uff0c\u53d8\u66f4\u65f6\u95f4\u4e3a{4}\uff0c\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\u786e\u5b9a\u662f\u5426\u8981\u5bf9\u8be5\u6838\u7b97\u4efb\u52a1\u6a21\u677f\u8fdb\u884c\u53d8\u66f4\u3002\u70b9\u51fb\u4e0b\u65b9\u201c\u5feb\u901f\u5904\u7406\u201d\u94fe\u63a5\u67e5\u770b\u85aa\u8d44\u6838\u7b97\u7ec4\u53d8\u66f4\u8be6\u60c5\u3002", (String)"PayrollGroupPeriodSaveOp_1", (String)"swc-hsas-opplugin", (Object[])new Object[0]), tplNumber, tplName, grpNumber, grpBred, grpModifyTime));
        message.setUserIds(receviers);
        message.setType("message");
        message.setEntityNumber("hsas_payrollgrp");
        message.setBizDataId(pkId);
        message.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u901a\u77e5", (String)"PayrollGroupPeriodSaveOp_2", (String)"swc-hsas-opplugin"));
        String clientUrl = UrlService.getDomainContextUrl();
        String url = String.format("%s/index.html?formId=%s&pkId=%d&type=base", clientUrl, "hsas_payrollgrp", pkId);
        message.setContentUrl(url);
        message.setNotifyType(MessageChannels.MC.toString());
        MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }
}

