/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsas.business.bizdata.transversetable.BizDataRecordListHelper;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsas.opplugin.validator.bizdatatpl.BizDataPayRollGrpTransValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class BizDataPayRollGrpTransOp
extends SWCDataBaseOp {
    private static final int bizDataQuerySize = 500;
    private static final int bitchSize = 1000;

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("id");
        event.getFieldKeys().add("salaryfile.id");
        event.getFieldKeys().add("salaryfile.number");
        event.getFieldKeys().add("salaryfile.person.id");
        event.getFieldKeys().add("salaryfile.org.id");
        event.getFieldKeys().add("salaryfile.payrollregion.id");
        event.getFieldKeys().add("salaryfile.payrollgroup.id");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("bizdataaccesstpl.id");
        String pageName = this.billEntityType.getName();
        if (SWCStringUtils.equals((String)pageName, (String)"hsas_nonrecurbizdata")) {
            event.getFieldKeys().add("org.id");
            event.getFieldKeys().add("payrollregion.id");
            event.getFieldKeys().add("payrollgroup.id");
            event.getFieldKeys().add("adminorg.id");
            event.getFieldKeys().add("empgroup.id");
            event.getFieldKeys().add("bizitem");
            event.getFieldKeys().add("bizitem.id");
            event.getFieldKeys().add("bizitem.name");
            event.getFieldKeys().add("bizitem.ctrlstrategy");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new BizDataPayRollGrpTransValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.buildBizDatas(dataEntities);
    }

    private void buildBizDatas(DynamicObject[] dataEntities) {
        String pageName = this.billEntityType.getName();
        boolean isNonBizPage = true;
        if (SWCStringUtils.equals((String)pageName, (String)"hsas_bizdatarecord")) {
            isNonBizPage = false;
        }
        HashSet<Long> personIdSet = new HashSet<Long>(dataEntities.length);
        for (DynamicObject bizDataObj : dataEntities) {
            personIdSet.add(bizDataObj.getLong("salaryfile.person.id"));
        }
        Map variables = this.getOption().getVariables();
        String payRollGrpIdStr = (String)variables.get("payRollGroupId");
        Long payRollGroupId = Long.parseLong(payRollGrpIdStr);
        Map<String, Map<String, Object>> salaryFileMap = this.getSalaryFileInfo(personIdSet, payRollGroupId);
        ArrayList<BizDataModifyRecEntity> needSaveLogList = new ArrayList<BizDataModifyRecEntity>(dataEntities.length);
        Long userId = RequestContext.get().getCurrUserId();
        ArrayList updateBizDataList = new ArrayList(dataEntities.length);
        for (DynamicObject bizDataObj : dataEntities) {
            String personId = bizDataObj.getString("salaryfile.person.id");
            Map<String, Object> salaryFileInfo = salaryFileMap.get(personId);
            if (salaryFileInfo == null || salaryFileInfo.size() == 0) continue;
            Long newSalaryFileId = (Long)salaryFileInfo.get("salaryFileId");
            BizDataModifyRecEntity dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setDataId(Long.valueOf(bizDataObj.getLong("id")));
            dataModifyRec.setSalaryFileId(newSalaryFileId);
            if (isNonBizPage) {
                dataModifyRec.setBizItemId(Long.valueOf(bizDataObj.getLong("bizitem.id")));
            }
            dataModifyRec.setBizDataNum(bizDataObj.getString("identifynumber"));
            dataModifyRec.setDataSources(bizDataObj.getString("datasources"));
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.SALARYFILE.getCode());
            dataModifyRec.setBeforeUpdate(bizDataObj.getString("salaryfile.number"));
            dataModifyRec.setAfterUpdate((String)salaryFileInfo.get("salaryFileNumber"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_TRANS_SALARYFILE.getCode());
            if (isNonBizPage) {
                dataModifyRec.setModelType("1");
            } else {
                dataModifyRec.setModelType("2");
            }
            dataModifyRec.setBizItemGroupId(Long.valueOf(bizDataObj.getLong("bizdataaccesstpl.id")));
            needSaveLogList.add(dataModifyRec);
            HashMap<String, Object> updateBizDataMap = new HashMap<String, Object>(16);
            updateBizDataMap.put("bizdatacode", bizDataObj.getString("identifynumber"));
            if (isNonBizPage) {
                updateBizDataMap.put("bizitem", bizDataObj.getLong("bizitem.id"));
            }
            updateBizDataMap.put("salaryfile", newSalaryFileId);
            if (isNonBizPage) {
                updateBizDataMap.put("modeltype", "1");
            } else {
                updateBizDataMap.put("modeltype", "2");
            }
            updateBizDataMap.put("operate", BizDataOperateEnum.OPERATE_TRANS_SALARYFILE.getCode());
            updateBizDataMap.put("modifier", userId);
            updateBizDataList.add(updateBizDataMap);
            bizDataObj.set("salaryfile", (Object)newSalaryFileId);
            if (!isNonBizPage) continue;
            bizDataObj.set("org", salaryFileInfo.get("orgId"));
            bizDataObj.set("payrollregion", salaryFileInfo.get("payRollRegionId"));
            bizDataObj.set("payrollgroup", salaryFileInfo.get("payRollGroupId"));
            bizDataObj.set("adminorg", salaryFileInfo.get("adminOrgId"));
            bizDataObj.set("empgroup", salaryFileInfo.get("empGroupId"));
        }
        SWCDataServiceHelper dataHelper = new SWCDataServiceHelper(this.billEntityType.getName());
        dataHelper.update(dataEntities);
        if (!isNonBizPage) {
            this.updateNonRecurbizData(dataEntities, salaryFileMap);
        }
        if (needSaveLogList.size() > 0) {
            BizDataModifyRecHelper.saveBizDataModifyRec(needSaveLogList);
        }
        if (updateBizDataList.size() > 0) {
            SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{updateBizDataList});
        }
    }

    private Map<String, Map<String, Object>> getSalaryFileInfo(Set<Long> personIdSet, Long payRollGroupId) {
        HashMap<String, Map<String, Object>> cacheSalaryFileMap = (HashMap<String, Map<String, Object>>)GlobalParam.get((String)"cacheSalaryFileMap");
        BizDataHelper bizDataHelper = new BizDataHelper();
        if (cacheSalaryFileMap == null || cacheSalaryFileMap.size() == 0) {
            cacheSalaryFileMap = new HashMap<String, Map<String, Object>>(personIdSet.size());
            Map salaryFileMap = bizDataHelper.getSalaryFileIdByPayRollGrpId(personIdSet, payRollGroupId);
            if (salaryFileMap != null && salaryFileMap.size() > 0) {
                cacheSalaryFileMap.putAll(salaryFileMap);
                GlobalParam.set((String)"cacheSalaryFileMap", cacheSalaryFileMap);
            }
        } else {
            HashSet<Long> needQuerySet = new HashSet<Long>(personIdSet.size());
            Set cachePersonIdSet = cacheSalaryFileMap.keySet();
            for (Long personId : personIdSet) {
                if (cachePersonIdSet.contains(String.valueOf(personId))) continue;
                needQuerySet.add(personId);
            }
            if (needQuerySet.size() == 0) {
                return cacheSalaryFileMap;
            }
            Map salaryFileMap = bizDataHelper.getSalaryFileIdByPayRollGrpId(needQuerySet, payRollGroupId);
            if (salaryFileMap != null && salaryFileMap.size() > 0) {
                cacheSalaryFileMap.putAll(salaryFileMap);
                GlobalParam.set((String)"cacheSalaryFileMap", cacheSalaryFileMap);
            }
        }
        return cacheSalaryFileMap;
    }

    private void updateNonRecurbizData(DynamicObject[] dataEntities, Map<String, Map<String, Object>> salaryFileMap) {
        DynamicObject[] nonRecurBizDatas;
        HashSet<Long> bizDataRecordIdSet = new HashSet<Long>(dataEntities.length);
        BizDataRecordListHelper helper = new BizDataRecordListHelper();
        SWCDataServiceHelper nonBizDataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        for (DynamicObject bizDataRecordObj : dataEntities) {
            if (!SWCObjectUtils.isEmpty((Object)bizDataRecordObj)) {
                bizDataRecordIdSet.add(bizDataRecordObj.getLong("id"));
            }
            if (bizDataRecordIdSet.size() != 500) continue;
            DynamicObject[] nonRecurBizDatas2 = helper.batchQueryNonBizDataRecordDatas(bizDataRecordIdSet, 1000);
            if (nonRecurBizDatas2 != null && nonRecurBizDatas2.length > 0) {
                for (DynamicObject bizDataObj : nonRecurBizDatas2) {
                    String personId = bizDataObj.getString("salaryfile.person.id");
                    Map<String, Object> salaryFileInfo = salaryFileMap.get(personId);
                    if (salaryFileInfo == null || salaryFileInfo.size() == 0) continue;
                    bizDataObj.set("salaryfile", salaryFileInfo.get("salaryFileId"));
                    bizDataObj.set("org", salaryFileInfo.get("orgId"));
                    bizDataObj.set("payrollregion", salaryFileInfo.get("payRollRegionId"));
                    bizDataObj.set("payrollgroup", salaryFileInfo.get("payRollGroupId"));
                    bizDataObj.set("adminorg", salaryFileInfo.get("adminOrgId"));
                    bizDataObj.set("empgroup", salaryFileInfo.get("empGroupId"));
                }
                nonBizDataHelper.update(nonRecurBizDatas2);
            }
            bizDataRecordIdSet.clear();
        }
        if (bizDataRecordIdSet != null && bizDataRecordIdSet.size() > 0 && (nonRecurBizDatas = helper.batchQueryNonBizDataRecordDatas(bizDataRecordIdSet, 1000)) != null && nonRecurBizDatas.length > 0) {
            for (DynamicObject bizDataObj : nonRecurBizDatas) {
                String personId = bizDataObj.getString("salaryfile.person.id");
                Map<String, Object> salaryFileInfo = salaryFileMap.get(personId);
                if (salaryFileInfo == null || salaryFileInfo.size() == 0) continue;
                bizDataObj.set("salaryfile", salaryFileInfo.get("salaryFileId"));
                bizDataObj.set("org", salaryFileInfo.get("orgId"));
                bizDataObj.set("payrollregion", salaryFileInfo.get("payRollRegionId"));
                bizDataObj.set("payrollgroup", salaryFileInfo.get("payRollGroupId"));
                bizDataObj.set("adminorg", salaryFileInfo.get("adminOrgId"));
                bizDataObj.set("empgroup", salaryFileInfo.get("empGroupId"));
            }
            nonBizDataHelper.update(nonRecurBizDatas);
        }
    }
}

