/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataRecordAuditStateEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class BizDataRecordAbandonOp
extends SWCDataBaseOp {
    private static final Log log = LogFactory.getLog(BizDataRecordAbandonOp.class);
    private static final String HSAS_BIZDATARECORD_CACHE_KEY = "hsas_bizdatarecord_cache_key";

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("auditstatus");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("usagecount");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("opreason");
        event.getFieldKeys().add("modifier");
        event.getFieldKeys().add("modifytime");
        event.getFieldKeys().add("salaryfile.id");
        event.getFieldKeys().add("bizdataaccesstpl.id");
        event.getFieldKeys().add("bsed");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.saveBizDataModifyRecord(e.getDataEntities());
        this.doBizDataAbandon(e);
    }

    private void saveBizDataModifyRecord(DynamicObject[] dataEntities) {
        String description = this.getOption().getVariableValue("opreason", " ");
        ArrayList<BizDataModifyRecEntity> dataModifyRecs = new ArrayList<BizDataModifyRecEntity>(10);
        BizDataModifyRecEntity dataModifyRec = null;
        for (DynamicObject data : dataEntities) {
            dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(Long.valueOf(data.getLong("salaryfile.id")));
            dataModifyRec.setBizDataNum(data.getString("identifynumber"));
            dataModifyRec.setBizItemGroupId(Long.valueOf(data.getLong("bizdataaccesstpl.id")));
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.AUDITSTATUS.getCode());
            dataModifyRec.setBeforeUpdate(BizDataRecordAuditStateEnum.getDesc((String)data.getString("auditstatus")));
            dataModifyRec.setAfterUpdate(BizDataRecordAuditStateEnum.OBSOLETE.getDesc());
            dataModifyRec.setDescription(description);
            dataModifyRec.setDataSources(data.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_MANUAL_ABANDON.getCode());
            dataModifyRec.setDataId(Long.valueOf(data.getLong("id")));
            dataModifyRec.setModelType("2");
            dataModifyRecs.add(dataModifyRec);
        }
        BizDataModifyRecHelper.saveBizDataModifyRec(dataModifyRecs);
    }

    private void doBizDataAbandon(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        String opReason = this.getOption().getVariableValue("opreason");
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATARECORD_CACHE_KEY);
        List abandonIdList = (List)appCache.get("abandonIdList", List.class);
        appCache.remove(HSAS_BIZDATARECORD_CACHE_KEY);
        long userId = RequestContext.get().getCurrUserId();
        Date currentDate = new Date();
        if (SWCStringUtils.equals((String)"donothing_abandon", (String)operationKey)) {
            ArrayList abandonBizDataList = new ArrayList(dataEntities.length);
            for (DynamicObject data : dataEntities) {
                if (!abandonIdList.contains(data.getLong("id"))) continue;
                data.set("auditstatus", (Object)"F");
                data.set("opreason", (Object)opReason);
                data.set("modifier", (Object)userId);
                data.set("modifytime", (Object)currentDate);
                String dataSources = data.getString("datasources");
                if (!SWCStringUtils.equals((String)dataSources, (String)"3")) continue;
                HashMap<String, Object> abandonBizDataMap = new HashMap<String, Object>(16);
                abandonBizDataMap.put("bizdatacode", data.getString("identifynumber"));
                abandonBizDataMap.put("salaryfile", data.getLong("salaryfile.id"));
                abandonBizDataMap.put("modeltype", "2");
                abandonBizDataMap.put("operate", BizDataOperateEnum.OPERATE_MANUAL_ABANDON.getCode());
                abandonBizDataMap.put("status", BizDataStatusEnum.HSAS_DISABLED.getCode());
                abandonBizDataMap.put("description", opReason);
                abandonBizDataMap.put("modifier", userId);
                abandonBizDataList.add(abandonBizDataMap);
            }
            SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
            bizDataHelper.update(dataEntities);
            this.abandonNonRecurStatusByKSql(abandonIdList, opReason, userId, currentDate);
            if (abandonBizDataList.size() > 0) {
                Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{abandonBizDataList});
                log.info("BizDataRecordAbandonOp result is:{}", (Object)result);
            }
        }
    }

    private void abandonNonRecurStatusByKSql(List<Long> bizDataRecordIdList, String opReason, long userId, Date currentDate) {
        StringBuilder updateSqlSb = new StringBuilder();
        String updateSql = "update t_hsas_nonrecurbizdata set fopreason = ?, fmodifierid = ?, fmodifytime = ?, fauditstatus = ? where fbizdatarecordid in (";
        updateSqlSb.append(updateSql);
        int size = bizDataRecordIdList.size();
        for (int index = 0; index < size; ++index) {
            updateSqlSb.append(bizDataRecordIdList.get(index));
            if (index != size - 1) {
                updateSqlSb.append(',');
                continue;
            }
            updateSqlSb.append(')');
        }
        SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSqlSb.toString(), (Object[])new Object[]{opReason, userId, currentDate, "F"});
    }
}

