/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsas.opplugin.validator.bizdatatpl.BizDataRecordValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataRecordAuditStateEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class BizDataRecordRejectOp
extends SWCDataBaseOp {
    public final Log log = LogFactory.getLog(BizDataRecordRejectOp.class);
    private static final String HSAS_BIZDATARECORD_CACHE_KEY = "hsas_bizdatarecord_cache_key";
    private static final int batchQuerySize = 500;

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("auditstatus");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("usagecount");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("opreason");
        event.getFieldKeys().add("modifier");
        event.getFieldKeys().add("modifytime");
        event.getFieldKeys().add("salaryfile.id");
        event.getFieldKeys().add("bizdataaccesstpl.id");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new BizDataRecordValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.doBizDataRejectOp(e);
        this.saveBizDataModifyRecord(e.getDataEntities());
    }

    private void saveBizDataModifyRecord(DynamicObject[] dataEntities) {
        String description = this.getOption().getVariableValue("opreason", " ");
        ArrayList<BizDataModifyRecEntity> dataModifyRecs = new ArrayList<BizDataModifyRecEntity>(10);
        BizDataModifyRecEntity dataModifyRec = null;
        for (DynamicObject data : dataEntities) {
            dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(Long.valueOf(data.getLong("salaryfile.id")));
            dataModifyRec.setBizDataNum(data.getString("identifynumber"));
            dataModifyRec.setBizItemGroupId(Long.valueOf(data.getLong("bizdataaccesstpl.id")));
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.AUDITSTATUS.getCode());
            dataModifyRec.setBeforeUpdate(BizDataRecordAuditStateEnum.AUDIT.getDesc());
            dataModifyRec.setAfterUpdate(BizDataRecordAuditStateEnum.REJECT.getDesc());
            dataModifyRec.setDescription(description);
            dataModifyRec.setDataSources(data.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_REJECT.getCode());
            dataModifyRec.setDataId(Long.valueOf(data.getLong("id")));
            dataModifyRec.setModelType("2");
            dataModifyRecs.add(dataModifyRec);
        }
        BizDataModifyRecHelper.saveBizDataModifyRec(dataModifyRecs);
    }

    private void doBizDataRejectOp(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        long startTime = System.currentTimeMillis();
        String opreason = this.getOption().getVariableValue("opreason");
        String pageId = this.getOption().getVariableValue("pageId");
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATARECORD_CACHE_KEY);
        List rejectIdList = (List)appCache.get("rejectIdList_" + pageId, List.class);
        appCache.remove(HSAS_BIZDATARECORD_CACHE_KEY);
        long userId = RequestContext.get().getCurrUserId();
        Date currentDate = new Date();
        if (SWCStringUtils.equals((String)"donothing_reject", (String)operationKey)) {
            ArrayList updateBizDataList = new ArrayList(dataEntities.length);
            ArrayList<Long> rejectRecordIdList = new ArrayList<Long>(dataEntities.length);
            for (DynamicObject data : dataEntities) {
                long bizDataRecordId = data.getLong("id");
                if (!rejectIdList.contains(bizDataRecordId)) continue;
                data.set("auditstatus", (Object)"R");
                data.set("opreason", (Object)opreason);
                data.set("modifier", (Object)userId);
                data.set("modifytime", (Object)currentDate);
                rejectRecordIdList.add(bizDataRecordId);
                String dataSources = data.getString("datasources");
                if (!SWCStringUtils.equals((String)dataSources, (String)"3")) continue;
                HashMap<String, Object> updateBizDataMap = new HashMap<String, Object>(16);
                updateBizDataMap.put("bizdatacode", data.getString("identifynumber"));
                updateBizDataMap.put("salaryfile", data.getLong("salaryfile.id"));
                updateBizDataMap.put("modeltype", "2");
                updateBizDataMap.put("operate", BizDataOperateEnum.OPERATE_REJECT.getCode());
                updateBizDataMap.put("status", BizDataStatusEnum.SALARY_REJECT.getCode());
                updateBizDataMap.put("description", opreason);
                updateBizDataMap.put("modifier", userId);
                updateBizDataList.add(updateBizDataMap);
            }
            SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_bizdatarecord");
            bizDataHelper.update(dataEntities);
            if (rejectRecordIdList != null && rejectRecordIdList.size() > 0) {
                this.log.info("BizDataRecordRejectOp reject recordId size is:{}", (Object)rejectRecordIdList.size());
                this.rejectNonrecurData(rejectRecordIdList, opreason, userId, currentDate);
            }
            if (updateBizDataList.size() > 0) {
                Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{updateBizDataList});
                this.log.info("BizDataRecordRejectOp updateBizData result is:{}", (Object)result);
            }
        }
        this.log.info("BizDataRecordRejectOp reject bizdatarecord use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void rejectNonrecurData(List<Long> bizDataRecordIdList, String opReason, long userId, Date currentDate) {
        SWCDataServiceHelper dataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        HashSet<Long> bizDataRecordIdSet = new HashSet<Long>(500);
        for (Long bizDataRecordId : bizDataRecordIdList) {
            bizDataRecordIdSet.add(bizDataRecordId);
            if (bizDataRecordIdSet.size() != 500) continue;
            long startTime = System.currentTimeMillis();
            this.updateNonBizData(bizDataRecordIdSet, dataHelper, opReason, userId, currentDate);
            this.log.info("BizDataRecordRejectOp updateNonBizData cycle use time:{}", (Object)(System.currentTimeMillis() - startTime));
            bizDataRecordIdSet.clear();
        }
        long startTime = System.currentTimeMillis();
        if (bizDataRecordIdSet != null && bizDataRecordIdSet.size() > 0) {
            this.updateNonBizData(bizDataRecordIdSet, dataHelper, opReason, userId, currentDate);
        }
        this.log.info("BizDataRecordRejectOp updateNonBizData use time:{}, size:{}", (Object)(System.currentTimeMillis() - startTime), (Object)bizDataRecordIdSet.size());
    }

    private void updateNonBizData(Set<Long> bizDataRecordIdSet, SWCDataServiceHelper dataHelper, String opReason, long userId, Date currentDate) {
        QFilter filter = new QFilter("bizdatarecord", "in", bizDataRecordIdSet);
        DynamicObject[] nonRecurDatas = dataHelper.query("auditstatus,opreason,modifier,modifytime", new QFilter[]{filter});
        if (nonRecurDatas == null || nonRecurDatas.length == 0) {
            return;
        }
        for (DynamicObject nonRecurObj : nonRecurDatas) {
            nonRecurObj.set("auditstatus", (Object)"R");
            nonRecurObj.set("opreason", (Object)opReason);
            nonRecurObj.set("modifier", (Object)userId);
            nonRecurObj.set("modifytime", (Object)currentDate);
        }
        dataHelper.update(nonRecurDatas);
    }
}

