/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsas.business.bizdata.service.BizDataRecoverBsledService;
import kd.swc.hsas.opplugin.validator.bizdatatpl.BizDataValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataRecordAuditStateEnum;
import kd.swc.hsbp.common.enums.BizDataStatusEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class BizDataRejectOp
extends SWCDataBaseOp {
    private static final String HSAS_BIZDATA_CACHE_KEY = "hsas_bizdata_cache_key";
    private static final Log log = LogFactory.getLog(BizDataRejectOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("auditstatus");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("usagecount");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("opreason");
        event.getFieldKeys().add("modifier");
        event.getFieldKeys().add("modifytime");
        event.getFieldKeys().add("bizitem.id");
        event.getFieldKeys().add("salaryfile.id");
        event.getFieldKeys().add("bsled");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new BizDataValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs event) {
        this.doBizDataRejectOp(event);
        this.saveBizDataModifyRecord(event.getDataEntities());
    }

    private void doBizDataRejectOp(BeginOperationTransactionArgs event) {
        String operationKey = event.getOperationKey();
        DynamicObject[] dataEntities = event.getDataEntities();
        String opreason = this.getOption().getVariableValue("opreason");
        String isRecur = this.getOption().getVariableValue("isRecur");
        String pageId = this.getOption().getVariableValue("pageId");
        ISWCAppCache appCache = SWCAppCache.get((String)HSAS_BIZDATA_CACHE_KEY);
        List rejectIdList = (List)appCache.get("rejectIdList_" + pageId, List.class);
        appCache.remove(HSAS_BIZDATA_CACHE_KEY);
        long userId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        if (SWCStringUtils.equals((String)"donothing_reject", (String)operationKey)) {
            if (SWCStringUtils.equals((String)isRecur, (String)"Y")) {
                this.recurbizDataExecuteEvent(rejectIdList, date, opreason);
            }
            this.bizDataRejectExecuteEvent(rejectIdList, dataEntities, opreason, userId, date, isRecur);
        }
    }

    private void recurbizDataExecuteEvent(List<Long> rejectIdList, Date modifyTime, String opreason) {
        SWCDataServiceHelper recurBizHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        QFilter filter = new QFilter("id", "in", rejectIdList);
        DynamicObject[] queryDatas = recurBizHelper.query("identifynumber", new QFilter[]{filter});
        if (queryDatas == null || queryDatas.length == 0) {
            return;
        }
        ArrayList<String> bizDataCodeList = new ArrayList<String>(queryDatas.length);
        for (DynamicObject queryData : queryDatas) {
            bizDataCodeList.add(queryData.getString("identifynumber"));
        }
        BizDataRecoverBsledService recoverService = new BizDataRecoverBsledService();
        recoverService.recoverBsledDatas(bizDataCodeList, BizDataOperateEnum.OPERATE_REJECT.getCode(), modifyTime, opreason);
    }

    private void bizDataRejectExecuteEvent(List<Long> rejectIdList, DynamicObject[] dataEntities, String opreason, long userId, Date date, String isRecur) {
        ArrayList paramList = new ArrayList(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            if (!rejectIdList.contains(data.getLong("id"))) continue;
            data.set("auditstatus", (Object)"R");
            data.set("opreason", (Object)opreason);
            data.set("modifier", (Object)userId);
            data.set("modifytime", (Object)date);
            String dataSources = data.getString("datasources");
            if (!SWCStringUtils.equals((String)dataSources, (String)"3")) continue;
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("bizdatacode", data.getString("identifynumber"));
            paramMap.put("bizitem", data.getLong("bizitem.id"));
            paramMap.put("salaryfile", data.getLong("salaryfile.id"));
            paramMap.put("modeltype", "1");
            paramMap.put("operate", BizDataOperateEnum.OPERATE_REJECT.getCode());
            paramMap.put("status", BizDataStatusEnum.SALARY_REJECT.getCode());
            paramMap.put("description", opreason);
            paramMap.put("modifier", userId);
            paramList.add(paramMap);
        }
        SWCDataServiceHelper bizDataHelper = new SWCDataServiceHelper("hsas_nonrecurbizdata");
        if (SWCStringUtils.equals((String)isRecur, (String)"Y")) {
            bizDataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        }
        bizDataHelper.update(dataEntities);
        if (paramList.size() > 0) {
            Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{paramList});
            log.info("IHPDIBizDataService updateBizData is:{}", (Object)result);
        }
    }

    private void saveBizDataModifyRecord(DynamicObject[] dataEntities) {
        String description = this.getOption().getVariableValue("opreason", " ");
        ArrayList<BizDataModifyRecEntity> dataModifyRecs = new ArrayList<BizDataModifyRecEntity>(10);
        BizDataModifyRecEntity dataModifyRec = null;
        for (DynamicObject data : dataEntities) {
            dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(Long.valueOf(data.getLong("salaryfile.id")));
            dataModifyRec.setBizDataNum(data.getString("identifynumber"));
            dataModifyRec.setBizItemId(Long.valueOf(data.getLong("bizitem.id")));
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.AUDITSTATUS.getCode());
            dataModifyRec.setBeforeUpdate(BizDataRecordAuditStateEnum.AUDIT.getDesc());
            dataModifyRec.setAfterUpdate(BizDataRecordAuditStateEnum.REJECT.getDesc());
            dataModifyRec.setDescription(description);
            dataModifyRec.setDataSources(data.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_REJECT.getCode());
            dataModifyRec.setDataId(Long.valueOf(data.getLong("id")));
            dataModifyRec.setModelType("1");
            dataModifyRecs.add(dataModifyRec);
        }
        BizDataModifyRecHelper.saveBizDataModifyRec(dataModifyRecs);
    }
}

