/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import com.google.common.collect.Table;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsas.common.utils.BizDataUniqueCodeUtils;
import kd.swc.hsas.common.utils.GlobalParam;
import kd.swc.hsas.opplugin.validator.bizdatatpl.BizDataPayRollGrpTransValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class RecurBizDataPayRollGrpBsedTransOp
extends SWCDataBaseOp {
    private static final Log log = LogFactory.getLog(RecurBizDataPayRollGrpBsedTransOp.class);
    private static final char UNDERLINE = '_';

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("id");
        event.getFieldKeys().add("salaryfile.id");
        event.getFieldKeys().add("salaryfile.number");
        event.getFieldKeys().add("salaryfile.person.id");
        event.getFieldKeys().add("salaryfile.org.id");
        event.getFieldKeys().add("salaryfile.payrollregion.id");
        event.getFieldKeys().add("salaryfile.payrollgroup.id");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("bizdataaccesstpl.id");
        event.getFieldKeys().add("bizitem");
        event.getFieldKeys().add("bizitem.id");
        event.getFieldKeys().add("bizitem.name");
        event.getFieldKeys().add("bizitem.ctrlstrategy");
        event.getFieldKeys().add("bsed");
        event.getFieldKeys().add("bsled");
        event.getFieldKeys().add("currency.id");
        event.getFieldKeys().add("description");
        event.getFieldKeys().add("datavalue");
        event.getFieldKeys().add("employee");
        event.getFieldKeys().add("depemp");
        event.getFieldKeys().add("frequency");
        event.getFieldKeys().add("payrollgroupid");
        event.getFieldKeys().add("salaryadjustrsn");
        event.getFieldKeys().add("action");
        event.getFieldKeys().add("propval");
        event.getFieldKeys().add("recurbizpropentry");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.id");
        event.getFieldKeys().add("recurbizpropentry.propdatavalue");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        event.addValidator((AbstractValidator)new BizDataPayRollGrpTransValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        this.dealBizDatas(dataEntities);
    }

    private void dealBizDatas(DynamicObject[] dataEntities) {
        HashSet<Long> personIdSet = new HashSet<Long>(dataEntities.length);
        ArrayList<DynamicObject> bizDataList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject bizDataObj : dataEntities) {
            bizDataList.add(bizDataObj);
            personIdSet.add(bizDataObj.getLong("salaryfile.person.id"));
        }
        Map variables = this.getOption().getVariables();
        String payRollGrpIdStr = (String)variables.get("payRollGroupId");
        Long payRollGroupId = Long.parseLong(payRollGrpIdStr);
        String bsedStr = (String)variables.get("bsed");
        if (SWCStringUtils.isEmpty((String)bsedStr)) {
            return;
        }
        Date bsed = null;
        try {
            bsed = SWCDateTimeUtils.parseDate((String)bsedStr);
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        if (bsed == null) {
            return;
        }
        BizDataHelper bizDataHelper = new BizDataHelper();
        Map<String, Map<String, Object>> salaryFileMap = this.getSalaryFileInfo(personIdSet, payRollGroupId);
        Collections.sort(bizDataList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Date bsed2;
                Date bsed1 = o1.getDate("bsed");
                if (bsed1.before(bsed2 = o2.getDate("bsed"))) {
                    return -1;
                }
                if (bsed1.after(bsed2)) {
                    return 1;
                }
                return 0;
            }
        });
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(bizDataList.size());
        HashSet<Long> bizItemIdSet = new HashSet<Long>(bizDataList.size());
        for (DynamicObject bizDataObj : bizDataList) {
            Map<String, Object> salaryFileInfo;
            bizItemIdSet.add(bizDataObj.getLong("bizitem.id"));
            Long personId = bizDataObj.getLong("salaryfile.person.id");
            if (personId == null || personId == 0L || (salaryFileInfo = salaryFileMap.get(String.valueOf(personId))) == null) continue;
            salaryFileIdSet.add((Long)salaryFileInfo.get("salaryFileId"));
        }
        Table recurBizData = bizDataHelper.getRecurBizData(salaryFileIdSet, bizItemIdSet);
        ArrayList<DynamicObject> needAddBizDataList = new ArrayList<DynamicObject>(bizDataList.size());
        SWCDataServiceHelper recurBizDataHelper = new SWCDataServiceHelper("hsas_recurbizdata");
        ArrayList<DynamicObject> needSaveBsledRecordList = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper bsledRecordHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        ArrayList<BizDataModifyRecEntity> needSaveLogList = new ArrayList<BizDataModifyRecEntity>(dataEntities.length);
        ArrayList<Map<String, Object>> updateBizDataList = new ArrayList<Map<String, Object>>(dataEntities.length);
        List<String> bizDataCodeList = this.getBizDataCodes("HSAS", bizDataList.size());
        long userId = RequestContext.get().getCurrUserId();
        for (int index = 0; index < bizDataList.size(); ++index) {
            Long salaryFileId;
            Map<String, Object> salaryFileInfo;
            DynamicObject bizDataObj = (DynamicObject)bizDataList.get(index);
            Long personId = bizDataObj.getLong("salaryfile.person.id");
            if (personId == null || personId == 0L || (salaryFileInfo = salaryFileMap.get(String.valueOf(personId))) == null || (salaryFileId = (Long)salaryFileInfo.get("salaryFileId")) == null) continue;
            String identifyNumber = bizDataCodeList.get(index);
            this.buildNewBizData(recurBizDataHelper, bizDataObj, needAddBizDataList, variables, salaryFileId, identifyNumber, userId);
            String salaryFileNumber = (String)salaryFileInfo.get("salaryFileNumber");
            this.resetBizDataBsled(bizDataObj, bsed, needSaveBsledRecordList, identifyNumber, bsledRecordHelper, needSaveLogList, updateBizDataList, salaryFileNumber);
        }
        HashMap<String, Date> bizDataBsledDateMap = new HashMap<String, Date>(16);
        ArrayList<DynamicObject> allUpdateBsledList = new ArrayList<DynamicObject>(10);
        this.updateNewDateBsled(needAddBizDataList, (Table<Long, Long, List<DynamicObject>>)recurBizData, bizDataBsledDateMap, bizDataHelper, bsed, allUpdateBsledList, bsledRecordHelper, needSaveBsledRecordList, needSaveLogList, updateBizDataList);
        this.doBizDatas(recurBizDataHelper, needAddBizDataList, bizDataList, allUpdateBsledList, needSaveBsledRecordList, bsledRecordHelper, needSaveLogList, updateBizDataList);
    }

    private Map<String, Map<String, Object>> getSalaryFileInfo(Set<Long> personIdSet, Long payRollGroupId) {
        HashMap<String, Map<String, Object>> cacheSalaryFileMap = (HashMap<String, Map<String, Object>>)GlobalParam.get((String)"cacheSalaryFileMap");
        BizDataHelper bizDataHelper = new BizDataHelper();
        if (cacheSalaryFileMap == null || cacheSalaryFileMap.size() == 0) {
            cacheSalaryFileMap = new HashMap<String, Map<String, Object>>(personIdSet.size());
            Map salaryFileMap = bizDataHelper.getSalaryFileIdByPayRollGrpId(personIdSet, payRollGroupId);
            if (salaryFileMap != null && salaryFileMap.size() > 0) {
                cacheSalaryFileMap.putAll(salaryFileMap);
                GlobalParam.set((String)"cacheSalaryFileMap", cacheSalaryFileMap);
            }
        } else {
            HashSet<Long> needQuerySet = new HashSet<Long>(personIdSet.size());
            Set cachePersonIdSet = cacheSalaryFileMap.keySet();
            for (Long personId : personIdSet) {
                if (cachePersonIdSet.contains(String.valueOf(personId))) continue;
                needQuerySet.add(personId);
            }
            if (needQuerySet.size() == 0) {
                return cacheSalaryFileMap;
            }
            Map salaryFileMap = bizDataHelper.getSalaryFileIdByPayRollGrpId(needQuerySet, payRollGroupId);
            if (salaryFileMap != null && salaryFileMap.size() > 0) {
                cacheSalaryFileMap.putAll(salaryFileMap);
                GlobalParam.set((String)"cacheSalaryFileMap", cacheSalaryFileMap);
            }
        }
        return cacheSalaryFileMap;
    }

    private void updateNewDateBsled(List<DynamicObject> needAddBizDataList, Table<Long, Long, List<DynamicObject>> recurBizData, Map<String, Date> bizDataBsledDateMap, BizDataHelper bizDataHelper, Date bsed, List<DynamicObject> allUpdateBsledList, SWCDataServiceHelper bsledRecordHelper, List<DynamicObject> needSaveBsledRecordList, List<BizDataModifyRecEntity> needSaveLogList, List<Map<String, Object>> updateBizDataList) {
        for (DynamicObject addBizDataObj : needAddBizDataList) {
            List needUpdateBsledList;
            Long bizItemId = addBizDataObj.getLong("bizitem");
            Long salaryFileId = addBizDataObj.getLong("salaryfile");
            List dynamicObjects = (List)recurBizData.get((Object)salaryFileId, (Object)bizItemId);
            Date bsled = addBizDataObj.getDate("bsled");
            String identifyNum = addBizDataObj.getString("identifynumber");
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                for (DynamicObject dataObj : dynamicObjects) {
                    String oldBizDataCode = dataObj.getString("identifynumber");
                    Long oldBizItemId = dataObj.getLong("bizitem.id");
                    Date oldBsled = dataObj.getDate("bsled");
                    if (oldBsled == null) continue;
                    bizDataBsledDateMap.put(oldBizDataCode + '#' + oldBizItemId, oldBsled);
                }
                List errorIdentifyNumList = bizDataHelper.getUpdateBsledErrorList(bsed, bsled, dynamicObjects, identifyNum);
                if (errorIdentifyNumList.size() > 0) continue;
            }
            if ((needUpdateBsledList = bizDataHelper.dealNeedUpdateBsledData(recurBizData, salaryFileId, bizItemId, bsed, bsled)) == null || needUpdateBsledList.size() <= 0) continue;
            allUpdateBsledList.addAll(needUpdateBsledList);
            List<DynamicObject> bsledUpdateList = this.dealBsledRecordDatas(identifyNum, needUpdateBsledList, bsledRecordHelper, bizDataBsledDateMap);
            needSaveBsledRecordList.addAll(bsledUpdateList);
            this.bsledChangeLogList(needSaveLogList, needUpdateBsledList, identifyNum, bizDataBsledDateMap);
            this.bsledChangeSendHpdiList(updateBizDataList, needUpdateBsledList, identifyNum);
        }
    }

    private void doBizDatas(SWCDataServiceHelper recurBizDataHelper, List<DynamicObject> needAddBizDataList, List<DynamicObject> bizDataList, List<DynamicObject> allUpdateBsledList, List<DynamicObject> needSaveBsledRecordList, SWCDataServiceHelper bsledRecordHelper, List<BizDataModifyRecEntity> needSaveLogList, List<Map<String, Object>> updateBizDataList) {
        int index;
        if (needAddBizDataList.size() > 0) {
            DynamicObject[] addBizDatas = new DynamicObject[needAddBizDataList.size()];
            for (index = 0; index < needAddBizDataList.size(); ++index) {
                addBizDatas[index] = needAddBizDataList.get(index);
            }
            recurBizDataHelper.save(addBizDatas);
        }
        if (bizDataList.size() > 0) {
            DynamicObject[] updateBizDatas = new DynamicObject[bizDataList.size()];
            for (index = 0; index < bizDataList.size(); ++index) {
                updateBizDatas[index] = bizDataList.get(index);
            }
            recurBizDataHelper.update(updateBizDatas);
        }
        if (allUpdateBsledList.size() > 0) {
            DynamicObject[] updateBsleds = new DynamicObject[allUpdateBsledList.size()];
            for (index = 0; index < allUpdateBsledList.size(); ++index) {
                updateBsleds[index] = allUpdateBsledList.get(index);
            }
            recurBizDataHelper.update(updateBsleds);
        }
        if (needSaveBsledRecordList.size() > 0) {
            DynamicObject[] bsledSaveDatas = new DynamicObject[needSaveBsledRecordList.size()];
            for (index = 0; index < needSaveBsledRecordList.size(); ++index) {
                bsledSaveDatas[index] = needSaveBsledRecordList.get(index);
            }
            bsledRecordHelper.save(bsledSaveDatas);
        }
        if (needSaveLogList.size() > 0) {
            BizDataModifyRecHelper.saveBizDataModifyRec(needSaveLogList);
        }
        if (updateBizDataList.size() > 0) {
            SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{updateBizDataList});
        }
    }

    private void bsledChangeSendHpdi(List<Map<String, Object>> updateBizDataList, DynamicObject bizDataObj, String identifyNum, Date newBsled, String description) {
        HashMap<String, Object> needPushHpdiDataMap = new HashMap<String, Object>(16);
        String bizDataCode = bizDataObj.getString("identifynumber");
        needPushHpdiDataMap.put("bizdatacode", bizDataCode);
        needPushHpdiDataMap.put("operatebizdatacode", identifyNum);
        Long oldBizItemId = bizDataObj.getLong("bizitem.id");
        needPushHpdiDataMap.put("bizitem", oldBizItemId);
        Long updateSalaryFileId = bizDataObj.getLong("salaryfile.id");
        needPushHpdiDataMap.put("salaryfile", updateSalaryFileId);
        needPushHpdiDataMap.put("modeltype", "1");
        needPushHpdiDataMap.put("operate", BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
        needPushHpdiDataMap.put("bsled", newBsled);
        needPushHpdiDataMap.put("description", description);
        needPushHpdiDataMap.put("modifier", RequestContext.get().getCurrUserId());
        updateBizDataList.add(needPushHpdiDataMap);
    }

    private void bsledChangeSendHpdiList(List<Map<String, Object>> updateBizDataList, List<DynamicObject> needUpdateBsledList, String identifyNum) {
        for (DynamicObject needUpdateObj : needUpdateBsledList) {
            HashMap<String, Object> needPushHpdiDataMap = new HashMap<String, Object>(16);
            String bizDataCode = needUpdateObj.getString("identifynumber");
            needPushHpdiDataMap.put("bizdatacode", bizDataCode);
            needPushHpdiDataMap.put("operatebizdatacode", identifyNum);
            Long oldBizItemId = needUpdateObj.getLong("bizitem.id");
            needPushHpdiDataMap.put("bizitem", oldBizItemId);
            Long updateSalaryFileId = needUpdateObj.getLong("salaryfile.id");
            needPushHpdiDataMap.put("salaryfile", updateSalaryFileId);
            needPushHpdiDataMap.put("modeltype", "1");
            needPushHpdiDataMap.put("operate", BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
            needPushHpdiDataMap.put("bsled", needUpdateObj.getDate("bsled"));
            needPushHpdiDataMap.put("modifier", RequestContext.get().getCurrUserId());
            updateBizDataList.add(needPushHpdiDataMap);
        }
    }

    private void bsledChangeLogList(List<BizDataModifyRecEntity> needSaveLogList, List<DynamicObject> needUpdateBsledList, String identifyNum, Map<String, Date> bizDataBsledDateMap) {
        for (DynamicObject needUpdateObj : needUpdateBsledList) {
            Date afterUpdateBsed;
            BizDataModifyRecEntity dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(Long.valueOf(needUpdateObj.getLong("salaryfile.id")));
            String bizDataCode = needUpdateObj.getString("identifynumber");
            dataModifyRec.setBizDataNum(bizDataCode);
            dataModifyRec.setOpBizDataNum(identifyNum);
            Long bizItemId = needUpdateObj.getLong("bizitem.id");
            dataModifyRec.setBizItemId(bizItemId);
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSLED.getCode());
            Date beforeBsled = bizDataBsledDateMap.get(bizDataCode + '#' + bizItemId);
            if (beforeBsled != null) {
                String beforeUpdateBsed = SWCDateTimeUtils.format((Date)beforeBsled, (String)"yyyy-MM-dd");
                dataModifyRec.setBeforeUpdate(beforeUpdateBsed);
            }
            if ((afterUpdateBsed = needUpdateObj.getDate("bsled")) != null) {
                String afterUpdateBsedStr = SWCDateTimeUtils.format((Date)afterUpdateBsed, (String)"yyyy-MM-dd");
                dataModifyRec.setAfterUpdate(afterUpdateBsedStr);
            }
            dataModifyRec.setDataSources(needUpdateObj.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
            dataModifyRec.setDataId(Long.valueOf(needUpdateObj.getLong("id")));
            dataModifyRec.setModelType("1");
            needSaveLogList.add(dataModifyRec);
        }
    }

    private DynamicObject dealSingleBsledRecordDatas(String identifyNum, DynamicObject bizDataObj, SWCDataServiceHelper bsledRecordHelper, Date oldBsled, Date newBsled) {
        DynamicObject bsledRecordObj = bsledRecordHelper.generateEmptyDynamicObject();
        Long updateSalaryFileId = bizDataObj.getLong("salaryfile.id");
        bsledRecordObj.set("salaryfile", (Object)updateSalaryFileId);
        Long oldBizItemId = bizDataObj.getLong("bizitem.id");
        bsledRecordObj.set("bizitem", (Object)oldBizItemId);
        String bizDataCode = bizDataObj.getString("identifynumber");
        bsledRecordObj.set("bizdatacode", (Object)bizDataCode);
        bsledRecordObj.set("opbizdatacode", (Object)identifyNum);
        bsledRecordObj.set("beforebsled", (Object)oldBsled);
        bsledRecordObj.set("afterbsled", (Object)newBsled);
        bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
        bsledRecordObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        bsledRecordObj.set("modifytime", (Object)new Date());
        return bsledRecordObj;
    }

    private List<DynamicObject> dealBsledRecordDatas(String identifyNum, List<DynamicObject> needUpdateBsledList, SWCDataServiceHelper bsledRecordHelper, Map<String, Date> bizDataBsledDateMap) {
        ArrayList<DynamicObject> retList = new ArrayList<DynamicObject>(10);
        for (DynamicObject updateObj : needUpdateBsledList) {
            DynamicObject bsledRecordObj = bsledRecordHelper.generateEmptyDynamicObject();
            Long updateSalaryFileId = updateObj.getLong("salaryfile.id");
            bsledRecordObj.set("salaryfile", (Object)updateSalaryFileId);
            Long oldBizItemId = updateObj.getLong("bizitem.id");
            bsledRecordObj.set("bizitem", (Object)oldBizItemId);
            String bizDataCode = updateObj.getString("identifynumber");
            bsledRecordObj.set("bizdatacode", (Object)bizDataCode);
            bsledRecordObj.set("opbizdatacode", (Object)identifyNum);
            Date beforeBsled = bizDataBsledDateMap.get(bizDataCode + '#' + oldBizItemId);
            if (beforeBsled != null) {
                bsledRecordObj.set("beforebsled", (Object)beforeBsled);
            }
            bsledRecordObj.set("afterbsled", (Object)updateObj.getDate("bsled"));
            bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
            bsledRecordObj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            bsledRecordObj.set("modifytime", (Object)new Date());
            retList.add(bsledRecordObj);
        }
        return retList;
    }

    private void resetBizDataBsled(DynamicObject bizDataObj, Date bsed, List<DynamicObject> needSaveBsledRecordList, String identifyNumber, SWCDataServiceHelper bsledRecordHelper, List<BizDataModifyRecEntity> needSaveLogList, List<Map<String, Object>> updateBizDataList, String salaryFileNumber) {
        Date oldBsled = bizDataObj.getDate("bsled");
        Date beforeDate = SWCDateTimeUtils.getBeforeDay((Date)bsed);
        if (oldBsled == null || oldBsled.after(beforeDate)) {
            bizDataObj.set("bsled", (Object)beforeDate);
            DynamicObject bsledUpdateObj = this.dealSingleBsledRecordDatas(identifyNumber, bizDataObj, bsledRecordHelper, oldBsled, beforeDate);
            needSaveBsledRecordList.add(bsledUpdateObj);
            String description = MessageFormat.format(ResManager.loadKDString((String)"{0}\u5df2\u8f6c\u79fb\u81f3\u65b0\u6863\u6848{1}\uff0c\u4e1a\u52a1\u6570\u636e\u8bc6\u522b\u53f7\u4e3a{2}\u3002", (String)"RecurBizDataPayRollGrpBsedTransOp_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), SWCDateTimeUtils.format((Date)bsed, (String)"yyyy-MM-dd"), salaryFileNumber, identifyNumber);
            this.bsledChangeLog(needSaveLogList, bizDataObj, identifyNumber, oldBsled, beforeDate, description);
            this.bsledChangeSendHpdi(updateBizDataList, bizDataObj, identifyNumber, beforeDate, description);
        }
    }

    private void bsledChangeLog(List<BizDataModifyRecEntity> needSaveLogList, DynamicObject bizDataObj, String identifyNum, Date oldBsled, Date newBsled, String description) {
        BizDataModifyRecEntity dataModifyRec = new BizDataModifyRecEntity();
        dataModifyRec.setSalaryFileId(Long.valueOf(bizDataObj.getLong("salaryfile.id")));
        String bizDataCode = bizDataObj.getString("identifynumber");
        dataModifyRec.setBizDataNum(bizDataCode);
        dataModifyRec.setOpBizDataNum(identifyNum);
        Long bizItemId = bizDataObj.getLong("bizitem.id");
        dataModifyRec.setBizItemId(bizItemId);
        dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSLED.getCode());
        if (oldBsled != null) {
            dataModifyRec.setBeforeUpdate(SWCDateTimeUtils.format((Date)oldBsled, (String)"yyyy-MM-dd"));
        }
        if (newBsled != null) {
            dataModifyRec.setAfterUpdate(SWCDateTimeUtils.format((Date)newBsled, (String)"yyyy-MM-dd"));
        }
        dataModifyRec.setDataSources(bizDataObj.getString("datasources"));
        dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_MANUAL_UPDATE.getCode());
        dataModifyRec.setDataId(Long.valueOf(bizDataObj.getLong("id")));
        dataModifyRec.setModelType("1");
        if (SWCStringUtils.isNotEmpty((String)description)) {
            dataModifyRec.setDescription(description);
        }
        needSaveLogList.add(dataModifyRec);
    }

    private void buildNewBizData(SWCDataServiceHelper recurBizDataHelper, DynamicObject bizDataObj, List<DynamicObject> needAddBizDataList, Map<String, String> variables, Long salaryFileId, String identifyNumber, long userId) {
        String bsedStr = variables.get("bsed");
        String bsledStr = variables.get("bsled");
        Date bsed = null;
        Date bsled = null;
        try {
            bsed = SWCDateTimeUtils.parseDate((String)bsedStr);
            if (SWCStringUtils.isNotEmpty((String)bsledStr)) {
                bsled = SWCDateTimeUtils.parseDate((String)bsledStr);
            }
        }
        catch (ParseException e) {
            log.error(e.getMessage());
        }
        DynamicObject newBizDataObj = recurBizDataHelper.generateEmptyDynamicObject();
        newBizDataObj.set("identifynumber", (Object)identifyNumber);
        newBizDataObj.set("salaryfile", (Object)salaryFileId);
        Long bizItemId = bizDataObj.getLong("bizitem.id");
        newBizDataObj.set("bizitem", (Object)bizItemId);
        newBizDataObj.set("currency", bizDataObj.get("currency.id"));
        newBizDataObj.set("bsed", (Object)bsed);
        newBizDataObj.set("bsled", (Object)bsled);
        newBizDataObj.set("description", bizDataObj.get("description"));
        newBizDataObj.set("datavalue", bizDataObj.get("datavalue"));
        newBizDataObj.set("datasources", (Object)"1");
        newBizDataObj.set("auditstatus", (Object)"C");
        newBizDataObj.set("billstatus", (Object)"C");
        newBizDataObj.set("employee", bizDataObj.get("employee"));
        newBizDataObj.set("depemp", bizDataObj.get("depemp"));
        newBizDataObj.set("frequency", bizDataObj.get("frequency"));
        newBizDataObj.set("payrollgroupid", bizDataObj.get("payrollgroupid"));
        newBizDataObj.set("creator", (Object)userId);
        newBizDataObj.set("modifier", (Object)userId);
        newBizDataObj.set("bizuniquecode", (Object)BizDataUniqueCodeUtils.getBizDataUniqueCode((String)identifyNumber, (Long)bizItemId));
        newBizDataObj.set("salaryadjustrsn", bizDataObj.get("salaryadjustrsn"));
        newBizDataObj.set("action", bizDataObj.get("action"));
        newBizDataObj.set("propval", bizDataObj.get("propval"));
        DynamicObjectCollection propValEntry = recurBizDataHelper.generateEmptyEntryCollection(bizDataObj, "recurbizpropentry");
        DynamicObjectCollection oldPropColl = bizDataObj.getDynamicObjectCollection("recurbizpropentry");
        for (DynamicObject oldPropObj : oldPropColl) {
            DynamicObject propValObj = new DynamicObject(propValEntry.getDynamicObjectType());
            propValObj.set("bizitemprop", oldPropObj.get("bizitemprop.id"));
            propValObj.set("propdatavalue", oldPropObj.get("propdatavalue"));
            propValEntry.add((Object)propValObj);
        }
        newBizDataObj.set("recurbizpropentry", (Object)propValEntry);
        needAddBizDataList.add(newBizDataObj);
    }

    private List<String> getBizDataCodes(String codePrefix, int count) {
        if (count < 1 || SWCStringUtils.isEmpty((String)codePrefix)) {
            return Collections.EMPTY_LIST;
        }
        if (count == 1) {
            String globalLongId = String.valueOf(DB.genGlobalLongId());
            StringBuilder bizDataCode = new StringBuilder(codePrefix);
            bizDataCode.append('_').append(globalLongId);
            ArrayList<String> results = new ArrayList<String>(1);
            results.add(bizDataCode.toString());
            return results;
        }
        long[] globalLongIds = DB.genGlobalLongIds((int)count);
        List<String> bizDataCodes = Arrays.stream(globalLongIds).mapToObj(id -> codePrefix + '_' + id).collect(Collectors.toList());
        return bizDataCodes;
    }
}

