/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.bizdatatpl;

import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.bizdata.BizDataHelper;
import kd.swc.hsas.business.bizdata.entity.BizDataModifyRecEntity;
import kd.swc.hsas.business.bizdata.service.BizDataModifyRecHelper;
import kd.swc.hsas.opplugin.validator.bizdatatpl.BizDataValidator;
import kd.swc.hsas.opplugin.validator.bizdatatpl.RecurBizDataValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.BizDataOperateEnum;
import kd.swc.hsbp.common.enums.BizDataUpdateFieldEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class RecurBizDataSaveOp
extends SWCDataBaseOp {
    public static final Log log = LogFactory.getLog(RecurBizDataSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs event) {
        event.getFieldKeys().add("bizitem");
        event.getFieldKeys().add("bizitem.isminvalnull");
        event.getFieldKeys().add("bizitem.ismaxvalnull");
        event.getFieldKeys().add("bizitem.ctrlstrategy");
        event.getFieldKeys().add("bizitem.isextprop");
        event.getFieldKeys().add("bizitem.bizitempropentry.bizitemprop");
        event.getFieldKeys().add("salaryfile.employee");
        event.getFieldKeys().add("salaryfile.person");
        event.getFieldKeys().add("salaryfile.employee.id");
        event.getFieldKeys().add("salaryfile.org.id");
        event.getFieldKeys().add("calperiodtype");
        event.getFieldKeys().add("calperiod");
        event.getFieldKeys().add("bsed");
        event.getFieldKeys().add("bsled");
        event.getFieldKeys().add("datavalue");
        event.getFieldKeys().add("datasources");
        event.getFieldKeys().add("decimalvalue");
        event.getFieldKeys().add("datevalue");
        event.getFieldKeys().add("currency");
        event.getFieldKeys().add("currency.amtprecision");
        event.getFieldKeys().add("auditstatus");
        event.getFieldKeys().add("identifynumber");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.datatype");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.datalength");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.scalelimit");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.isminvalnull");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.minvalue");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.ismaxvalnull");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.maxvalue");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.earliestdate");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.lastdate");
        event.getFieldKeys().add("recurbizpropentry.bizitemprop.name");
        event.getFieldKeys().add("recurbizpropentry.propdatavalue");
        event.getFieldKeys().add("propval");
    }

    public void onAddValidators(AddValidatorsEventArgs event) {
        log.info("start validate recurbizdata,time:{}", (Object)System.currentTimeMillis());
        event.addValidator((AbstractValidator)new RecurBizDataValidator());
        event.addValidator((AbstractValidator)new BizDataValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs event) {
        String operationKey = event.getOperationKey();
        DynamicObject[] dataEntities = event.getDataEntities();
        switch (operationKey) {
            case "save": 
            case "submit": {
                log.info("start save recurbizdata,time:{}", (Object)System.currentTimeMillis());
                this.doSaveBizData(dataEntities);
                this.formateDate(dataEntities);
                break;
            }
            case "audit": {
                this.doAuditBizData(dataEntities);
                break;
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs event) {
        log.info("after execute recurbizdata,time:{}", (Object)System.currentTimeMillis());
    }

    private void formateDate(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date bsled;
            Date bsed = dynamicObject.getDate("bsed");
            if (bsed != null) {
                try {
                    bsed = SWCDateTimeUtils.formatDateToDate((Date)bsed, (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    log.info("NonrecurbizDataSaveOp bsed formate error!");
                }
                dynamicObject.set("bsed", (Object)bsed);
            }
            if ((bsled = dynamicObject.getDate("bsled")) == null) continue;
            try {
                bsled = SWCDateTimeUtils.formatDateToDate((Date)bsled, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                log.info("RecurbizDataSaveOp bsled formate error!");
            }
            dynamicObject.set("bsled", (Object)bsled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAuditBizData(DynamicObject[] dataEntities) {
        BizDataHelper bizDataHelper = new BizDataHelper();
        HashSet<Long> salaryFileIdSet = new HashSet<Long>(dataEntities.length);
        HashSet<Long> bizItemIdSet = new HashSet<Long>(dataEntities.length);
        HashMap<String, String> newBizDataInfoMap = new HashMap<String, String>(dataEntities.length);
        for (DynamicObject dynamicObject : dataEntities) {
            Long salaryFileId = dynamicObject.getLong("salaryfile.id");
            salaryFileIdSet.add(salaryFileId);
            Long bizItemId = dynamicObject.getLong("bizitem.id");
            bizItemIdSet.add(bizItemId);
            String bizDataCode = dynamicObject.getString("identifynumber");
            if (!SWCStringUtils.isNotEmpty((String)bizDataCode)) continue;
            newBizDataInfoMap.put(salaryFileId + "#" + bizItemId, bizDataCode);
        }
        Table oldRecurBizData = bizDataHelper.getRecurBizData(salaryFileIdSet, bizItemIdSet);
        HashMap<String, Date> bizDataBsledDateMap = new HashMap<String, Date>(16);
        if (oldRecurBizData != null && oldRecurBizData.size() > 0) {
            for (Long l : oldRecurBizData.rowKeySet()) {
                for (Long bizItemId : oldRecurBizData.columnKeySet()) {
                    List oldBizDataList = (List)oldRecurBizData.get((Object)l, (Object)bizItemId);
                    if (oldBizDataList == null || oldBizDataList.size() == 0) continue;
                    for (DynamicObject oldBizDataObj : oldBizDataList) {
                        String oldBizDataCode = oldBizDataObj.getString("identifynumber");
                        Long oldBizItemId = oldBizDataObj.getLong("bizitem.id");
                        Date oldBsled = oldBizDataObj.getDate("bsled");
                        if (oldBsled == null) continue;
                        bizDataBsledDateMap.put(oldBizDataCode + '#' + oldBizItemId, oldBsled);
                    }
                }
            }
        }
        ArrayList<DynamicObject> needUpdateObjList = new ArrayList<DynamicObject>(10);
        for (DynamicObject data : dataEntities) {
            List updateList = bizDataHelper.dealNeedUpdateBsledData(oldRecurBizData, data);
            if (updateList == null || updateList.size() <= 0) continue;
            needUpdateObjList.addAll(updateList);
        }
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper bsledRecordHelper = new SWCDataServiceHelper("hsas_bizdatabsledrecord");
        ArrayList updateBizDataList = new ArrayList(10);
        long userId = RequestContext.get().getCurrUserId();
        if (needUpdateObjList != null && needUpdateObjList.size() > 0) {
            for (DynamicObject updateObj : needUpdateObjList) {
                DynamicObject bsledRecordObj = bsledRecordHelper.generateEmptyDynamicObject();
                Long updateSalaryFileId = updateObj.getLong("salaryfile.id");
                bsledRecordObj.set("salaryfile", (Object)updateSalaryFileId);
                Long oldBizItemId = updateObj.getLong("bizitem.id");
                bsledRecordObj.set("bizitem", (Object)oldBizItemId);
                String bizDataCode = updateObj.getString("identifynumber");
                bsledRecordObj.set("bizdatacode", (Object)bizDataCode);
                bsledRecordObj.set("opbizdatacode", newBizDataInfoMap.get(updateSalaryFileId + "#" + oldBizItemId));
                Date beforeBsled = (Date)bizDataBsledDateMap.get(bizDataCode + '#' + oldBizItemId);
                if (beforeBsled != null) {
                    bsledRecordObj.set("beforebsled", (Object)beforeBsled);
                }
                bsledRecordObj.set("afterbsled", (Object)updateObj.getDate("bsled"));
                bsledRecordObj.set("optype", (Object)BizDataOperateEnum.OPERATE_MANUAL_ADD.getCode());
                bsledRecordObj.set("modifier", (Object)userId);
                bsledRecordObj.set("modifytime", (Object)new Date());
                arrayList.add(bsledRecordObj);
                String dataSources = updateObj.getString("datasources");
                if (!SWCStringUtils.equals((String)dataSources, (String)"3")) continue;
                HashMap<String, Object> updateBizDataMap = new HashMap<String, Object>(16);
                updateBizDataMap.put("bizdatacode", bizDataCode);
                updateBizDataMap.put("operatebizdatacode", newBizDataInfoMap.get(updateSalaryFileId + "#" + oldBizItemId));
                updateBizDataMap.put("bizitem", oldBizItemId);
                updateBizDataMap.put("salaryfile", updateSalaryFileId);
                updateBizDataMap.put("modeltype", "1");
                updateBizDataMap.put("operate", BizDataOperateEnum.OPERATE_MANUAL_ADD.getCode());
                updateBizDataMap.put("bsled", updateObj.getDate("bsled"));
                updateBizDataMap.put("modifier", userId);
                updateBizDataList.add(updateBizDataMap);
            }
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if (!needUpdateObjList.isEmpty()) {
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
                helper.update(needUpdateObjList.toArray(new DynamicObject[needUpdateObjList.size()]));
                if (arrayList != null && arrayList.size() > 0) {
                    bsledRecordHelper.save(arrayList.toArray(new DynamicObject[arrayList.size()]));
                }
                if (updateBizDataList.size() > 0) {
                    Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hpdi", (String)"IHPDIBizDataService", (String)"updateBizData", (Object[])new Object[]{updateBizDataList});
                    log.info("RecurBizDataSaveOp IHPDIBizDataService result is:{}", (Object)result);
                }
                this.saveBizDataModifyRecord(needUpdateObjList, bizDataBsledDateMap, newBizDataInfoMap);
            }
            log.info("RecurBizDataService save DB success !");
        }
    }

    private void saveBizDataModifyRecord(List<DynamicObject> dataEntities, Map<String, Date> bizDataBsledDateMap, Map<String, String> newBizDataInfoMap) {
        ArrayList<BizDataModifyRecEntity> dataModifyRecs = new ArrayList<BizDataModifyRecEntity>(10);
        BizDataModifyRecEntity dataModifyRec = null;
        for (DynamicObject data : dataEntities) {
            Long updateSalaryFileId = data.getLong("salaryfile.id");
            String bizDataCode = data.getString("identifynumber");
            Long oldBizItemId = data.getLong("bizitem.id");
            Date beforeBsled = bizDataBsledDateMap.get(bizDataCode + '#' + oldBizItemId);
            dataModifyRec = new BizDataModifyRecEntity();
            dataModifyRec.setSalaryFileId(Long.valueOf(data.getLong("salaryfile.id")));
            dataModifyRec.setBizDataNum(data.getString("identifynumber"));
            dataModifyRec.setOpBizDataNum(newBizDataInfoMap.get(updateSalaryFileId + "#" + oldBizItemId));
            dataModifyRec.setBizItemId(Long.valueOf(data.getLong("bizitem.id")));
            dataModifyRec.setUpdateField(BizDataUpdateFieldEnum.BSLED.getCode());
            String beforeUpdateBsled = beforeBsled != null ? SWCDateTimeUtils.format((Date)beforeBsled, (String)"yyyy-MM-dd") : " ";
            dataModifyRec.setBeforeUpdate(beforeUpdateBsled);
            Date bsled = data.getDate("bsled");
            String afterUpdateBsled = bsled != null ? SWCDateTimeUtils.format((Date)bsled, (String)"yyyy-MM-dd") : " ";
            dataModifyRec.setAfterUpdate(afterUpdateBsled);
            dataModifyRec.setDataSources(data.getString("datasources"));
            dataModifyRec.setOperate(BizDataOperateEnum.OPERATE_MANUAL_ADD.getCode());
            dataModifyRec.setDataId(Long.valueOf(data.getLong("id")));
            dataModifyRec.setModelType("1");
            dataModifyRecs.add(dataModifyRec);
        }
        BizDataModifyRecHelper.saveBizDataModifyRec(dataModifyRecs);
    }

    private void doSaveBizData(DynamicObject[] dataEntities) {
        for (DynamicObject data : dataEntities) {
            DynamicObject bizItem = data.getDynamicObject("bizitem");
            if ("1".equals(data.getString("datasources")) || SWCStringUtils.isEmpty((String)data.getString("datasources"))) {
                data.set("datasources", (Object)"1");
            }
            String isImport = null;
            Map variables = this.getOption().getVariables();
            if (this.getOption().containsVariable("isImport")) {
                isImport = (String)variables.get("isImport");
            }
            String isListOp = null;
            if (this.getOption().containsVariable("isListOp")) {
                isListOp = (String)variables.get("isListOp");
            }
            this.setSaveData(data, bizItem, isImport, isListOp);
            DynamicObjectCollection entryColl = data.getDynamicObjectCollection("recurbizpropentry");
            if (entryColl == null || entryColl.size() == 0) {
                data.set("propval", null);
                continue;
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
            DynamicObjectCollection newEntryColl = helper.generateEmptyEntryCollection(data, "recurbizpropentry");
            for (DynamicObject entryObj : entryColl) {
                String propVal = entryObj.getString("propdatavalue");
                if (!SWCStringUtils.isNotEmpty((String)propVal) || !SWCStringUtils.isNotEmpty((String)propVal.trim())) continue;
                newEntryColl.add((Object)entryObj);
            }
            StringBuilder propSb = new StringBuilder();
            if (newEntryColl != null && newEntryColl.size() > 0) {
                data.set("recurbizpropentry", (Object)newEntryColl);
                int size = newEntryColl.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject newEntryObj = (DynamicObject)newEntryColl.get(i);
                    String propName = newEntryObj.getString("bizitemprop.name");
                    String propVal = newEntryObj.getString("propdatavalue");
                    propSb.append(propName).append('\uff1a').append(propVal);
                    if (i == size - 1) continue;
                    propSb.append('\uff1b');
                }
                data.set("propval", (Object)propSb.toString());
                continue;
            }
            data.set("propval", null);
        }
    }

    private void setSaveData(DynamicObject data, DynamicObject bizItem, String isImport, String isListOp) {
        String value = null;
        long dataTypeId = bizItem.getLong("datatype.id");
        if (isImport != null && StringUtils.equals((CharSequence)isImport, (CharSequence)Boolean.FALSE.toString()) && isListOp != null && StringUtils.equals((CharSequence)isListOp, (CharSequence)Boolean.FALSE.toString())) {
            if (dataTypeId == 1030L) {
                value = data.getString("datavalue");
            } else if (dataTypeId == 1050L) {
                value = SWCDateTimeUtils.format((Date)data.getDate("datevalue"), (String)"yyyy-MM-dd");
            } else if (dataTypeId == 1010L || dataTypeId == 1020L) {
                value = data.getBigDecimal("decimalvalue").toPlainString();
                Object scalelimit = bizItem.get("scalelimit");
                if (dataTypeId == 1020L) {
                    scalelimit = data.getInt("currency.amtprecision");
                }
                int scale = 10;
                if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
                    scale = Integer.parseInt(String.valueOf(scalelimit));
                }
                value = new BigDecimal(value).setScale(scale, RoundingMode.HALF_UP).toPlainString();
            }
            data.set("datavalue", (Object)value);
        } else if (dataTypeId == 1010L || dataTypeId == 1020L) {
            BigDecimal importValue = new BigDecimal(data.getString("datavalue"));
            Object scalelimit = bizItem.get("scalelimit");
            int scale = 10;
            if (!SWCObjectUtils.isEmpty((Object)scalelimit)) {
                scale = Integer.parseInt(String.valueOf(scalelimit));
            }
            if (dataTypeId == 1020L) {
                scale = data.getInt("currency.amtprecision");
            }
            data.set("datavalue", (Object)importValue.setScale(scale, RoundingMode.HALF_UP).toPlainString());
        }
    }
}

