/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.cloudcolla;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.util.CollectionUtils;

public class CloudCollaHisDataSyncOp
extends AbstractOperationServicePlugIn {
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String entityName = this.billEntityType.getName();
        String operationKey = e.getOperationKey();
        this.publishMessageData(e.getDataEntities(), entityName, this.getTranslateMap().get(operationKey));
    }

    public Map<String, String> getTranslateMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("save", "his_save");
        hashMap.put("donothing_confirmchange", "his_confirmchange");
        hashMap.put("auditconfirmchange", "his_confirmchange");
        hashMap.put("audithisconfirmchange", "his_confirmchange");
        hashMap.put("donothing_delete", "his_delete");
        return hashMap;
    }

    private void publishMessageData(DynamicObject[] dataEntities, String entityName, String operationKey) {
        List<Long> ids = this.getObjectIds(dataEntities);
        if (!CollectionUtils.isEmpty(ids)) {
            this.publishSyncMsgToMQ(ids, operationKey, entityName);
        }
    }

    private void publishSyncMsg(Map<String, Object> messageData) {
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("swc", "hpdi_opsync_queue");){
            publisher.publishInDbTranscation("swc", messageData);
        }
    }

    private void publishSyncMsgToMQ(List<Long> ids, String operationKey, String entityName) {
        HashMap<String, Object> messageData = new HashMap<String, Object>(3);
        messageData.put("tag", operationKey);
        messageData.put("data", ids);
        messageData.put("entity", this.repalceHsasToHpdi(entityName));
        this.publishSyncMsg(messageData);
    }

    private List<Long> getObjectIds(DynamicObject[] dynamicObjects) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (null == dynamicObjects || dynamicObjects.length < 1) {
            return ids;
        }
        for (int i = 0; i < dynamicObjects.length; ++i) {
            ids.add(dynamicObjects[i].getLong("boid"));
        }
        return ids;
    }

    private String repalceHsasToHpdi(String entityName) {
        return entityName.replace("hsas", "hpdi");
    }
}

