/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.cloudcolla;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;

public class PayRollActGrpSyncDataOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("payrollactgtpl");
        fieldKeys.add("payrollact");
        fieldKeys.add("payrollact.entryentity.triggercolla");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        Map<String, Object> syncData = this.assembledMsgData(dataEntities);
        this.publishSyncMsg(syncData);
    }

    private Map<String, Object> assembledMsgData(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return null;
        }
        HashMap<String, Object> triggerCollaDataMap = new HashMap<String, Object>(2);
        triggerCollaDataMap.put("entityNumber", "hsas_triggercolla");
        HashMap<String, Object> payRollActDataMap = new HashMap<String, Object>(2);
        payRollActDataMap.put("entityNumber", "hsas_payrollact");
        HashMap<String, Object> payRollActgTplDataMap = new HashMap<String, Object>(2);
        payRollActgTplDataMap.put("entityNumber", "hsas_payrollactgtpl");
        HashMap<String, Object> payRollActgDataMap = new HashMap<String, Object>(2);
        payRollActgDataMap.put("entityNumber", "hsas_payrollactg");
        for (DynamicObject dataEntity : dataEntities) {
            this.addMapId(payRollActgDataMap, dataEntity.getLong("boid"));
            this.addMapId(payRollActgTplDataMap, dataEntity.getLong("payrollactgtpl.id"));
            DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObject payrollact = entryEntity.getDynamicObject("payrollact");
                this.addMapId(payRollActDataMap, payrollact.getLong("id"));
                DynamicObjectCollection triggerEntryEntities = payrollact.getDynamicObjectCollection("entryentity");
                for (DynamicObject triggerEntryEntity : triggerEntryEntities) {
                    this.addMapId(triggerCollaDataMap, triggerEntryEntity.getLong("triggercolla.id"));
                }
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("tag", "SYNC_PAYROLLACTG_DATA");
        result.put("data", Stream.of(triggerCollaDataMap, payRollActDataMap, payRollActgTplDataMap, payRollActgDataMap).collect(Collectors.toList()));
        return result;
    }

    private void addMapId(Map<String, Object> map, Long id) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (id == null || id == 0L) {
            return;
        }
        ArrayList<Long> ids = (ArrayList<Long>)map.get("ids");
        if (ids == null) {
            ids = new ArrayList<Long>(10);
            map.put("ids", ids);
        }
        ids.add(id);
    }

    private void publishSyncMsg(Map<String, Object> messageData) {
        if (messageData == null || messageData.isEmpty()) {
            return;
        }
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("swc", "hpdi_opsync_queue");){
            publisher.publishInDbTranscation("swc", messageData);
        }
    }
}

