/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.file;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.swc.hsas.business.file.FileDBHelper;
import kd.swc.hsas.business.file.FileDelDBHelper;
import kd.swc.hsas.business.file.PersonCertCommonHelper;
import kd.swc.hsas.opplugin.validator.salaryfile.SalaryFileDelValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.opplugin.validator.SWCNetworkControlValidator;

public class SalaryFileDelOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SalaryFileDelOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("person.personindexid");
        fieldKeys.add("depemp");
        fieldKeys.add("employee");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SWCNetworkControlValidator());
        args.addValidator((AbstractValidator)new SalaryFileDelValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] selectedRows = args.getDataEntities();
        if (selectedRows == null) {
            return;
        }
        log.info("SalaryFileDelOp.endOperationTransaction...1...");
        ArrayList<Long> idDelList = new ArrayList<Long>();
        ArrayList<DynamicObject> delDyList = new ArrayList<DynamicObject>();
        ArrayList<Long> idAbandonList = new ArrayList<Long>();
        ArrayList<Long> abandonPidList = new ArrayList<Long>();
        for (DynamicObject selectedRow : selectedRows) {
            if ("A".equals(selectedRow.getString("status"))) {
                idDelList.add(selectedRow.getLong("id"));
                delDyList.add(selectedRow);
                continue;
            }
            idAbandonList.add(selectedRow.getLong("id"));
            abandonPidList.add(selectedRow.getLong("person.id"));
        }
        if (!idDelList.isEmpty()) {
            log.info("SalaryFileDelOp.endOperationTransaction...2...");
            FileDelDBHelper.deleteSalaryFile(idDelList);
            log.info("SalaryFileDelOp.endOperationTransaction...3...");
            SWCDataServiceHelper fserviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
            DynamicObject[] dataInfo = new DynamicObject[delDyList.size()];
            String[] numbers = new String[delDyList.size()];
            for (int i = 0; i < delDyList.size(); ++i) {
                DynamicObject fileDy = (DynamicObject)delDyList.get(i);
                DynamicObject tmpDy = fserviceHelper.generateEmptyDynamicObject();
                tmpDy.set("employee", (Object)fileDy.getDynamicObject("employee"));
                tmpDy.set("number", (Object)fileDy.getString("number"));
                dataInfo[i] = tmpDy;
                numbers[i] = fileDy.getString("number");
            }
            CodeRuleServiceHelper.recycleBatchNumber((String)"hsas_salaryfile", (DynamicObject[])dataInfo, null, (String[])numbers);
            log.info("SalaryFileDelOp.endOperationTransaction...4...");
        }
        if (!idAbandonList.isEmpty()) {
            log.info("SalaryFileDelOp.endOperationTransaction...5...");
            FileDBHelper.abandonSalaryFile(idAbandonList);
            log.info("SalaryFileDelOp.endOperationTransaction...6...");
            log.info("SalaryFileDelOp.endOperationTransaction...7...");
            PersonCertCommonHelper.calPersonCertByPersonId(abandonPidList);
            log.info("SalaryFileDelOp.endOperationTransaction...8...");
        }
    }
}

