/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.file;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsas.business.file.PersonCertCommonHelper;
import kd.swc.hsas.business.person.PersonHelper;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileServiceHelper;
import kd.swc.hsas.opplugin.validator.salaryfile.PersonCertValidator;
import kd.swc.hsas.opplugin.validator.salaryfile.SalaryFileCommonValidator;
import kd.swc.hsbp.opplugin.validator.SWCNetworkControlValidator;
import org.apache.commons.collections.MapUtils;

public class SalaryFileListAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bsled");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SWCNetworkControlValidator());
        args.addValidator((AbstractValidator)new SalaryFileCommonValidator());
        args.addValidator((AbstractValidator)new PersonCertValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        Map result;
        Object[] selectedRows = args.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])selectedRows)) {
            return;
        }
        Map multiEntityPkIds = SWCSalaryFileServiceHelper.getSalaryFileMultiEntityPkIds((EndOperationTransactionArgs)args);
        if (!multiEntityPkIds.isEmpty()) {
            PersonHelper.personListOperation((Map)multiEntityPkIds, (String)"status", (String)"C");
        }
        if (null != (result = SalaryFileServiceHelper.genPersonChangeForSalaryFile(Arrays.asList(selectedRows))) && !MapUtils.getBoolean((Map)result, (Object)"success").booleanValue()) {
            this.getOption().setVariableValue("showGenPersonChangeTip", MapUtils.getString((Map)result, (Object)"message"));
        }
        List pIds = Arrays.stream(selectedRows).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        PersonCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String showWarningTip = this.getOption().getVariableValue("showWarningTip", null);
        String preMsg = ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"SalaryFileList_22", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
        if (showWarningTip != null) {
            this.getOperationResult().setMessage(preMsg + showWarningTip + "filecertwarn");
        } else if (args.getDataEntities().length == 1) {
            this.getOperationResult().setMessage(preMsg);
        }
        String showGenPersonChangeTip = this.getOption().getVariableValue("showGenPersonChangeTip", null);
        if (null != showGenPersonChangeTip) {
            String message = this.getOperationResult().getMessage();
            this.getOperationResult().setMessage(message + showGenPersonChangeTip);
        }
        this.getOperationResult().setShowMessage(true);
    }
}

