/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.swc.hsas.business.file.PersonCertCommonHelper;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileServiceHelper;
import kd.swc.hsas.opplugin.validator.salaryfile.PersonCertValidator;
import kd.swc.hsas.opplugin.validator.salaryfile.SalaryFileCommonValidator;
import kd.swc.hsas.opplugin.validator.salaryfile.SalaryFileSaveValidator;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCCoreBaseBillOp;
import org.apache.commons.collections.MapUtils;

public class SalaryFileSaveOp
extends SWCCoreBaseBillOp {
    private static Log log = LogFactory.getLog(SalaryFileSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("paystatus");
        fieldKeys.add("bsed");
        fieldKeys.add("bsled");
        fieldKeys.add("employee.person");
        fieldKeys.add("person");
        fieldKeys.add("salarycalcstyle.ctrlstrategy");
        fieldKeys.add("useorg");
        fieldKeys.add("employee");
        fieldKeys.add("empposinfo");
        fieldKeys.add("depemp");
        fieldKeys.add("depemp.startdate");
        fieldKeys.add("depemp.enddate");
        fieldKeys.add("depemp.laborrelrecord");
        fieldKeys.add("payrollgroup");
        fieldKeys.add("payrollgroup.firstbsed");
        fieldKeys.add("payrollregion");
        fieldKeys.add("person.personindexid");
        fieldKeys.add("employee.person.personindexid");
        fieldKeys.add("empgroup.bussinessfield");
        fieldKeys.add("adminorg");
        fieldKeys.add("empposinfo.adminorg");
        fieldKeys.add("empposinfo.adminorgvid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SalaryFileCommonValidator());
        args.addValidator((AbstractValidator)new SalaryFileSaveValidator());
        boolean needAudit = HRBaseDataConfigUtil.getAudit((String)"hsas_salaryfile");
        String statusParam = this.getOption().getVariableValue("status", null);
        if (!needAudit || statusParam != null && "C".equals(statusParam)) {
            args.addValidator((AbstractValidator)new PersonCertValidator());
        }
        super.onAddValidators(args);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Object[] selectedRows;
        String validate = (String)this.operateOption.getVariables().get("op");
        if (SWCStringUtils.equals((String)"validate", (String)validate)) {
            e.setCancel(true);
        }
        if (ArrayUtils.isEmpty((Object[])(selectedRows = e.getDataEntities()))) {
            return;
        }
        for (Object dataEntity : selectedRows) {
            dataEntity.set("salaryfile", dataEntity.getPkValue());
            DynamicObject person = dataEntity.getDynamicObject("person");
            if (person == null) {
                dataEntity.set("person", dataEntity.get("employee.person"));
            }
            dataEntity.set("name", dataEntity.get("person.name"));
            dataEntity.set("laborrelrecord", dataEntity.get("depemp.laborrelrecord"));
            if (!SWCStringUtils.isEmpty((String)dataEntity.getString("enable"))) continue;
            dataEntity.set("enable", (Object)"1");
        }
        SalaryFileHelper.setEmpposinfo((DynamicObject[])e.getDataEntities());
        SalaryFileHelper.setManagingScope((DynamicObject[])e.getDataEntities());
        SalaryFileHelper.setAdminorgVid((DynamicObject[])selectedRows);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        this.getOption().setVariableValue("statusCancel", "cancel");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Object[] selectedRows = e.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])selectedRows)) {
            return;
        }
        List<Object> successDys = Arrays.asList(selectedRows);
        String isImport = (String)this.operateOption.getVariables().get("import");
        if (SWCStringUtils.equals((String)"1", (String)isImport)) {
            Map<Integer, List<DynamicObject>> batchDyMap = this.splitSuccessDysByBoid(successDys);
            for (Map.Entry<Integer, List<DynamicObject>> entry : batchDyMap.entrySet()) {
                this.dealSaveOpForImport(entry.getValue());
            }
        } else {
            this.dealSaveOpForAddNew(successDys);
        }
    }

    private Map<Integer, List<DynamicObject>> splitSuccessDysByBoid(List<DynamicObject> successDys) {
        HashMap<Integer, List<DynamicObject>> batchDyMap = new HashMap<Integer, List<DynamicObject>>(16);
        HashMap<String, Integer> numberBatchRls = new HashMap<String, Integer>(16);
        for (DynamicObject dy : successDys) {
            String number = dy.getString("number");
            Integer batch = (Integer)numberBatchRls.get(number);
            if (batch == null) {
                batch = -1;
            }
            if (StringUtils.isEmpty((CharSequence)number)) {
                batch = 0;
            } else {
                Integer n = batch;
                Integer n2 = batch = Integer.valueOf(batch + 1);
                numberBatchRls.put(number, batch);
            }
            ArrayList<DynamicObject> dys = (ArrayList<DynamicObject>)batchDyMap.get(batch);
            if (dys == null) {
                dys = new ArrayList<DynamicObject>(10);
            }
            dys.add(dy);
            batchDyMap.put(batch, dys);
        }
        return batchDyMap;
    }

    private void dealSaveOpForAddNew(List<DynamicObject> successDys) {
        this.refreshSalaryFileEmpAndScopeForWaitAudit(successDys);
    }

    private void refreshSalaryFileEmpAndScopeForWaitAudit(List<DynamicObject> fileList) {
        ArrayList<DynamicObject> manageScopeList = new ArrayList<DynamicObject>(10);
        ArrayList<Long> salaryFileIds = new ArrayList<Long>(10);
        for (DynamicObject dataEntity : fileList) {
            salaryFileIds.add(dataEntity.getLong("id"));
            DynamicObject orgRel = this.getEmpposorgrelObj(dataEntity);
            DynamicObject manageScope = this.getManageScopeObj(dataEntity);
            if (manageScope == null) continue;
            manageScopeList.add(manageScope);
        }
        this.saveByOperation("hsas_filemanagingscope", salaryFileIds, manageScopeList);
    }

    private void saveByOperation(String entityName, List<Long> salaryFileIds, List<DynamicObject> objList) {
        QFilter filter = new QFilter("salaryfile", "in", salaryFileIds);
        SWCDataServiceHelper empHelper = new SWCDataServiceHelper(entityName);
        empHelper.deleteByFilter(new QFilter[]{filter});
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", "true");
        operateOption.setVariableValue("skipCheckDataPermission", "true");
        OperationResult operationResult = opImpl.localInvokeOperation("save", objList.toArray(new DynamicObject[objList.size()]), operateOption);
        log.info("SalaryFileSaveOp {} operationResult {}", (Object)entityName, (Object)operationResult.isSuccess());
    }

    private DynamicObject getManageScopeObj(DynamicObject dataEntity) {
        Long managingscopeId = dataEntity.getLong("managingscope.id");
        if (managingscopeId == 0L) {
            managingscopeId = dataEntity.getLong("managingscope");
        }
        if (managingscopeId != 0L) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_filemanagingscope");
            DynamicObject manageScope = serviceHelper.generateEmptyDynamicObject();
            manageScope.set("salaryfile", (Object)dataEntity.getLong("id"));
            manageScope.set("managingscope", (Object)managingscopeId);
            return manageScope;
        }
        return null;
    }

    private DynamicObject getEmpposorgrelObj(DynamicObject dataEntity) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_empposorgrel");
        DynamicObject empDyobj = serviceHelper.generateEmptyDynamicObject();
        ORM orm = ORM.create();
        Long newId = orm.genLongId("hsas_empposorgrel");
        empDyobj.set("id", (Object)newId);
        empDyobj.set("salaryfile", (Object)dataEntity.getLong("id"));
        empDyobj.set("empposinfo", (Object)dataEntity.getLong("empposinfo.id"));
        return empDyobj;
    }

    private void dealSaveOpForImport(List<DynamicObject> selectedRows) {
        SWCDataServiceHelper adminHelper = new SWCDataServiceHelper("haos_adminorghr");
        DynamicObject currUser = new SWCDataServiceHelper("bos_user").generateEmptyDynamicObject();
        currUser.set("id", (Object)RequestContext.get().getCurrUserId());
        ArrayList<DynamicObject> hisDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> waitSave = new ArrayList<DynamicObject>(10);
        ArrayList<Long> waitModifyFileIds = new ArrayList<Long>(10);
        ArrayList<Long> waitChangeFileIds = new ArrayList<Long>(10);
        for (DynamicObject row : selectedRows) {
            Long id = row.getLong("id");
            String status = row.getString("status");
            if (!"A".equals(status)) continue;
            waitModifyFileIds.add(id);
        }
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        DynamicObject[] dbFileDys = fileHelper.loadDynamicObjectArray((Object[])waitModifyFileIds.toArray(new Long[waitModifyFileIds.size()]));
        Map dbFileDyMap = Arrays.stream(dbFileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        for (DynamicObject row : selectedRows) {
            Long id = row.getLong("id");
            String status = row.getString("status");
            if ("A".equals(status)) {
                DynamicObject adminDy = adminHelper.generateEmptyDynamicObject();
                adminDy.set("id", (Object)row.getLong("adminorg.id"));
                row.set("adminorg", (Object)adminDy);
                DynamicObject dbFile = (DynamicObject)dbFileDyMap.get(id);
                if (dbFile == null) {
                    waitSave.add(row);
                } else {
                    HashSet<String> keySet = new HashSet<String>(2);
                    keySet.add("boid");
                    keySet.add("status");
                    keySet.add("sourcevid");
                    keySet.add("creator");
                    keySet.add("createtime");
                    SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)row, (DynamicObject)dbFile, keySet, null);
                    waitSave.add(dbFile);
                }
            }
            if (!"C".equals(status)) continue;
            waitChangeFileIds.add(row.getLong("id"));
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(row.getDataEntityType().getName());
            DynamicObject hisDyn = serviceHelper.generateEmptyDynamicObject();
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)row, (DynamicObject)hisDyn, null, null);
            hisDyn.set("status", (Object)"C");
            hisDyn.set("boid", (Object)row.getLong("id"));
            hisDyn.set("creator", (Object)currUser);
            hisDyn.set("createtime", (Object)new Date());
            hisDys.add(hisDyn);
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        OperationResult operationResult = opImpl.localInvokeOperation("save", waitSave.toArray(new DynamicObject[waitSave.size()]), operateOption);
        if (operationResult == null) {
            return;
        }
        log.info("dealSaveOpForImport   operationResult.isSuccess= {0}", (Object)operationResult.isSuccess());
        log.info("dealSaveOpForImport   operationResult.getMessage= {0}", (Object)operationResult.getMessage());
        StringBuilder sb = new StringBuilder();
        for (IOperateInfo operateInfo : operationResult.getAllErrorOrValidateInfo()) {
            if (sb.length() >= 1) {
                sb.append(';');
            }
            sb.append(operateInfo.getMessage());
        }
        log.info("dealSaveOpForImport   operationResult.sb.toString= {0}", (Object)sb.toString());
        if (operationResult == null) {
            throw new KDException(new ErrorCode("", "Batch save error."), new Object[0]);
        }
        if (!operationResult.isSuccess() && sb.length() >= 1) {
            throw new KDException(new ErrorCode("", sb.toString()), new Object[0]);
        }
        if (!operationResult.isSuccess()) {
            throw new KDException(new ErrorCode("", operationResult.getMessage()), new Object[0]);
        }
        this.refreshSalaryFileEmpAndScopeForWaitAudit(waitSave);
        if (hisDys.size() == 0) {
            return;
        }
        HisResponse res = BaseDataHisHelper.saveTimeVersion((DynamicObject[])hisDys.toArray(new DynamicObject[hisDys.size()]), (boolean)true);
        log.info("dealSaveOpForImport   saveTimeVersion getErrorMessage={0}", (Object)res.getErrorMessage());
        Map result = SalaryFileServiceHelper.genPersonChangeForSalaryFile(hisDys);
        if (null != result && !MapUtils.getBoolean((Map)result, (Object)"success").booleanValue()) {
            this.getOption().setVariableValue("showGenPersonChangeTip", MapUtils.getString((Map)result, (Object)"message"));
        }
        SWCSalaryFileServiceHelper.refreshSalaryFileEmpAndScope(waitChangeFileIds, (boolean)false);
        List pIds = hisDys.stream().map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        PersonCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String showGenPersonChangeTip = this.getOption().getVariableValue("showGenPersonChangeTip", null);
        if (null != showGenPersonChangeTip) {
            String message = this.getOperationResult().getMessage();
            this.getOperationResult().setMessage(message + showGenPersonChangeTip);
        }
        this.getOperationResult().setShowMessage(true);
    }
}

