/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.inporttask;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.opplugin.validator.importtask.ImportTaskValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class ImportTaskSaveOp
extends SWCDataBaseOp {
    protected static final Log logger = LogFactory.getLog(ImportTaskSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("taskstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ImportTaskValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        List importTaskIdList = Arrays.stream(e.getDataEntities()).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        if (SWCStringUtils.equals((String)"delete", (String)operationKey)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_verifyrecord");
            DynamicObjectCollection records = helper.queryOriginalCollection("id", new QFilter[]{new QFilter("importtask.id", "in", importTaskIdList)});
            if (!CollectionUtils.isEmpty((Collection)records)) {
                List recordIdList = records.stream().map(record -> record.getLong("id")).collect(Collectors.toList());
                helper.deleteByFilter(new QFilter[]{new QFilter("id", "in", recordIdList)});
                helper.setEntityName("hsas_verifydetail");
                helper.deleteByFilter(new QFilter[]{new QFilter("importtask.id", "in", recordIdList)});
            }
        } else if (SWCStringUtils.equals((String)"donothing_closetask", (String)operationKey)) {
            DynamicObject[] importTasks;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_importtask");
            QFilter filter = new QFilter("id", "in", importTaskIdList);
            filter.and(new QFilter("taskstatus", "=", (Object)"2"));
            for (DynamicObject importTask : importTasks = helper.query("id,taskstatus", new QFilter[]{filter})) {
                importTask.set("taskstatus", (Object)"7");
            }
            helper.update(importTasks);
        } else if (SWCStringUtils.equals((String)"donothing_unclosetask", (String)operationKey)) {
            DynamicObject[] importTasks;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_importtask");
            QFilter filter = new QFilter("id", "in", importTaskIdList);
            filter.and(new QFilter("taskstatus", "=", (Object)"7"));
            for (DynamicObject importTask : importTasks = helper.query("id,taskstatus", new QFilter[]{filter})) {
                importTask.set("taskstatus", (Object)"2");
            }
            helper.update(importTasks);
        } else if (SWCStringUtils.equals((String)"donothing_cleartask", (String)operationKey)) {
            this.clearTask(e.getDataEntities());
        }
    }

    private void clearTask(DynamicObject[] dataEntities) {
        DynamicObject[] importTasks;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_importtask");
        List importTaskIdList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        for (DynamicObject importTask : importTasks = helper.query("id,taskstatus", new QFilter[]{new QFilter("id", "in", importTaskIdList)})) {
            importTask.set("taskstatus", (Object)"9");
        }
        helper.update(importTasks);
        RequestContext ctx = RequestContext.get();
        SWCThreadPoolFactory.getCommonAsyncThreadpool().execute(() -> {
            DynamicObject[] importTaskArray;
            RequestContext.copyAndSet((RequestContext)ctx);
            SWCDataServiceHelper importTaskHelper = new SWCDataServiceHelper("hsas_importtask");
            for (DynamicObject importTask : importTaskArray = importTaskHelper.query("id,taskstatus,count", new QFilter[]{new QFilter("id", "in", (Object)importTaskIdList)})) {
                try (TXHandle required = TX.required();){
                    Long importTaskId = importTask.getLong("id");
                    SWCDataServiceHelper verifyRecordHelper = new SWCDataServiceHelper("hsas_verifyrecord");
                    DynamicObjectCollection verifyRecords = verifyRecordHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("importtask", "=", (Object)importTaskId)});
                    List verifyRecordIdList = verifyRecords.stream().map(verifyRecord -> verifyRecord.getLong("id")).collect(Collectors.toList());
                    SWCDataServiceHelper verifyDetailHelper = new SWCDataServiceHelper("hsas_verifydetail");
                    verifyDetailHelper.deleteByFilter(new QFilter[]{new QFilter("verifyrecord", "in", verifyRecordIdList)});
                    verifyRecordHelper.delete(verifyRecordIdList.toArray());
                    SWCDataServiceHelper temporaryDataHelper = new SWCDataServiceHelper("hsas_temporarydata");
                    temporaryDataHelper.deleteByFilter(new QFilter[]{new QFilter("importtask", "=", (Object)importTaskId)});
                    importTask.set("taskstatus", (Object)"8");
                    importTask.set("count", (Object)0);
                    importTaskHelper.updateOne(importTask);
                }
            }
        });
    }
}

