/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.personalbankcardeditbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.swc.hsas.business.modifybankaccount.helper.PerBankCardEditBillHelper;
import kd.swc.hsas.business.paysalarysetting.paysetting.UpdatePaySettingService;
import kd.swc.hsas.opplugin.validator.personalbankcardeditbill.PersonalBankCardEditBillValidator;
import kd.swc.hsbp.business.perbankcard.PerBankCardVerifyHelper;
import kd.swc.hsbp.business.perbankcard.PerBankcardServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.PerBankCardVO;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class PersonalBankCardEditBillOp
extends SWCDataBaseOp {
    private static Log LOGGER = LogFactory.getLog(PersonalBankCardEditBillOp.class);
    private static Set<String> OPERATION_KEY_SET = new HashSet<String>(3);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("failmsg");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.perbankcard");
        e.getFieldKeys().add("entryentity.perbankcard.boid");
        e.getFieldKeys().add("entryentity.perbankcard.number");
        e.getFieldKeys().add("entryentity.modifycardpurposemul");
        e.getFieldKeys().add("entryentity.modifycardpurposemul.fbasedataid_id");
        e.getFieldKeys().add("entryentity.modifybank");
        e.getFieldKeys().add("entryentity.modifybank.id");
        e.getFieldKeys().add("entryentity.modifyreltype");
        e.getFieldKeys().add("entryentity.modifyreltype.id");
        e.getFieldKeys().add("entryentity.modifybankaccount");
        e.getFieldKeys().add("entryentity.description");
        e.getFieldKeys().add("entryentity.modifyreceivername");
        e.getFieldKeys().add("person.id");
        e.getFieldKeys().add("employee.id");
        e.getFieldKeys().add("edittype");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new PersonalBankCardEditBillValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        this.updateBillStatus(operationKey, dataEntities);
        this.handleWorkFlow(operationKey, dataEntities);
        this.modifyBankCard(operationKey, dataEntities);
        if (OPERATION_KEY_SET.contains(operationKey) && !"submit".equals(operationKey)) {
            PerBankCardEditBillHelper.savePersonalBankCardEditBill((DynamicObject[])dataEntities);
        }
        if (PerBankcardServiceHelper.getUpdateSettingStatus().booleanValue()) {
            this.updatePaySetting(operationKey, dataEntities);
        }
    }

    private void updateBillStatus(String operationKey, DynamicObject[] dataEntities) {
        if (OPERATION_KEY_SET.contains(operationKey)) {
            if ("submit".equals(operationKey)) {
                DynamicObject[] bills;
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_perbceditbill");
                for (DynamicObject bill : bills = helper.query(Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getLong("id")).distinct().toArray())) {
                    bill.set("billstatus", (Object)"D");
                    bill.set("modifytime", (Object)new Date());
                }
                PerBankCardEditBillHelper.savePersonalBankCardEditBill((DynamicObject[])bills);
            } else {
                for (DynamicObject bill : dataEntities) {
                    if ("wfauditpass".equals(operationKey)) {
                        bill.set("billstatus", (Object)"C");
                        continue;
                    }
                    bill.set("billstatus", (Object)"E");
                }
            }
        }
    }

    private void handleWorkFlow(String operationKey, DynamicObject[] dataEntities) {
        if ("discard".equals(operationKey)) {
            try (TXHandle txHandle = TX.requiresNew();){
                for (DynamicObject data : dataEntities) {
                    String businessKey = data.getString("id");
                    if (!WorkflowServiceHelper.inProcess((String)businessKey)) continue;
                    WorkflowServiceHelper.abandonByBusienssKey((String)businessKey);
                }
            }
        }
    }

    private void modifyBankCard(String operationKey, DynamicObject[] dataEntities) {
        if (!"wfauditpass".equals(operationKey)) {
            return;
        }
        HashMap<Long, List<Map<String, Object>>> attachmentIdListMap = new HashMap<Long, List<Map<String, Object>>>(dataEntities.length);
        try (TXHandle txHandle = TX.requiresNew();){
            for (DynamicObject data : dataEntities) {
                Long id = data.getLong("id");
                attachmentIdListMap.put(id, this.getAttachmentList(id));
            }
        }
        ArrayList<PerBankCardVO> addBankCardList = new ArrayList<PerBankCardVO>(dataEntities.length);
        ArrayList<PerBankCardVO> modifyBankCardList = new ArrayList<PerBankCardVO>(dataEntities.length);
        HashMap<Long, List<DynamicObject>> bankCardBillMap = new HashMap<Long, List<DynamicObject>>(16);
        HashMap<String, Object> bankcardParam = new HashMap<String, Object>(16);
        bankcardParam.put("ishasright", "true");
        String personId = "";
        long[] perBankCards = ORM.create().genLongIds("hrpi_perbankcard", dataEntities.length);
        for (int index = 0; index < dataEntities.length; ++index) {
            long bankCardId;
            DynamicObject data = dataEntities[index];
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entrys)) continue;
            String editType = data.getString("edittype");
            DynamicObject entry = (DynamicObject)entrys.get(0);
            DynamicObject perBankCard = entry.getDynamicObject("perbankcard");
            PerBankCardVO perBankCardVO = new PerBankCardVO();
            if ("0".equals(editType)) {
                bankCardId = perBankCards[index];
                addBankCardList.add(perBankCardVO);
            } else {
                bankCardId = perBankCard.getLong("boid");
                perBankCardVO.setNumber(perBankCard.getString("number"));
                modifyBankCardList.add(perBankCardVO);
            }
            List billList = bankCardBillMap.getOrDefault(bankCardId, new ArrayList());
            billList.add(data);
            bankCardBillMap.put(bankCardId, billList);
            perBankCardVO.setId(Long.valueOf(bankCardId));
            perBankCardVO.setBankCardNum(entry.getString("modifybankaccount"));
            perBankCardVO.setUserName(entry.getString("modifyreceivername"));
            perBankCardVO.setBankDepositId(Long.valueOf(entry.getLong("modifybank.id")));
            List cardPurposeList = entry.getDynamicObjectCollection("modifycardpurposemul").stream().map(obj -> obj.getLong("fbasedataid_id")).collect(Collectors.toList());
            perBankCardVO.setCardPurposeIds(cardPurposeList);
            perBankCardVO.setAccountRelationId(Long.valueOf(entry.getLong("modifyreltype.id")));
            perBankCardVO.setDescription(entry.getString("description"));
            perBankCardVO.setPersonId(Long.valueOf(data.getLong("person.id")));
            perBankCardVO.setEmployeeId(Long.valueOf(data.getLong("employee.id")));
            perBankCardVO.setAttachmentDatas((List)attachmentIdListMap.get(data.getLong("id")));
            personId = data.getString("person.id");
        }
        String lockKey = "_updatePerBankCard_" + personId;
        try (DLock lock = DLock.create((String)lockKey);){
            if (lock.tryLock(5000L)) {
                Map result;
                if (!CollectionUtils.isEmpty(addBankCardList)) {
                    PerBankCardVerifyHelper.saveValidate(addBankCardList);
                    List<Map<String, Object>> addMapList = this.setBillFailMsg(addBankCardList, bankCardBillMap);
                    if (!addMapList.isEmpty()) {
                        bankcardParam.put("dataList", addMapList);
                        result = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPerBankCardService", (String)"addPerBankCardResult", (Object[])new Object[]{bankcardParam});
                        this.setBillFailMsg(result, bankCardBillMap);
                    }
                }
                if (!CollectionUtils.isEmpty(modifyBankCardList)) {
                    PerBankCardVerifyHelper.changeValidate(modifyBankCardList);
                    List<Map<String, Object>> modifyMapList = this.setBillFailMsg(modifyBankCardList, bankCardBillMap);
                    if (!modifyMapList.isEmpty()) {
                        bankcardParam.put("dataList", modifyMapList);
                        result = (Map)SWCMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPerBankCardService", (String)"modifyPerBankCardResult", (Object[])new Object[]{bankcardParam});
                        this.setBillFailMsg(result, bankCardBillMap);
                    }
                }
            }
        }
        catch (Exception e) {
            this.setBillFailMsg(e.getMessage().substring(0, 100), bankCardBillMap);
        }
    }

    private List<Map<String, Object>> getAttachmentList(Long pkId) {
        List attachmentData = AttachmentServiceHelper.getAttachments((String)"hsas_perbceditbill", (Object)pkId, (String)"attachmentpanel");
        if (CollectionUtils.isEmpty((Collection)attachmentData)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        return attachmentData;
    }

    private List<Map<String, Object>> setBillFailMsg(List<PerBankCardVO> bankCardList, Map<Long, List<DynamicObject>> bankCardBillMap) {
        ArrayList<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>(10);
        for (PerBankCardVO perBankCard : bankCardList) {
            String errorMsg = perBankCard.getErrorMsg();
            if (SWCStringUtils.isNotEmpty((String)errorMsg)) {
                List<DynamicObject> billList = bankCardBillMap.get(perBankCard.getId());
                for (DynamicObject bill : billList) {
                    errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u66f4\u65b0\u94f6\u884c\u5361\u5931\u8d25: %s\u3002", (String)"PersonalBankCardEditBillOp_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), errorMsg);
                    bill.set("failmsg", (Object)errorMsg);
                }
                continue;
            }
            dataMap.add(perBankCard.toMap());
        }
        return dataMap;
    }

    private void setBillFailMsg(String errorMsg, Map<Long, List<DynamicObject>> bankCardBillMap) {
        for (List<DynamicObject> billList : bankCardBillMap.values()) {
            for (DynamicObject bill : billList) {
                errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u66f4\u65b0\u94f6\u884c\u5361\u5931\u8d25: %s\u3002", (String)"PersonalBankCardEditBillOp_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), errorMsg);
                bill.set("failmsg", (Object)errorMsg);
            }
        }
    }

    private void setBillFailMsg(Map<String, Object> result, Map<Long, List<DynamicObject>> bankCardBillMap) {
        OperationResult operationResult;
        if (((Boolean)result.getOrDefault("success", Boolean.FALSE)).booleanValue() && !(operationResult = (OperationResult)result.get("data")).isSuccess()) {
            List infoList = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : infoList) {
                List<DynamicObject> billList = bankCardBillMap.get(operateInfo.getPkValue());
                if (billList == null) continue;
                billList.forEach(bill -> {
                    String errorCode = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u66f4\u65b0\u94f6\u884c\u5361\u5931\u8d25: %s\u3002", (String)"PersonalBankCardEditBillOp_0", (String)"swc-hsas-opplugin", (Object[])new Object[0]), operateInfo.getMessage());
                    bill.set("failmsg", (Object)errorCode);
                });
            }
        }
    }

    private void updatePaySetting(String operationKey, DynamicObject[] dataEntities) {
        if (!"wfauditpass".equals(operationKey)) {
            return;
        }
        UpdatePaySettingService updatePaySettingService = new UpdatePaySettingService();
        ArrayList<Long> personIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            if (!SWCStringUtils.isEmpty((String)data.getString("failmsg"))) continue;
            Long personId = data.getLong("person.id");
            personIds.add(personId);
        }
        if (personIds.isEmpty()) {
            return;
        }
        String lockKey = "_updatePerBankCard_" + personIds.get(0);
        try (DLock lock = DLock.create((String)lockKey);){
            if (lock.tryLock(5000L)) {
                updatePaySettingService.synUpdatePaySetting(personIds, Boolean.FALSE, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            LOGGER.info("_updatePerBankCard_error :{}", (Object)e.getMessage());
        }
    }

    static {
        OPERATION_KEY_SET.add("submit");
        OPERATION_KEY_SET.add("wfauditpass");
        OPERATION_KEY_SET.add("wfauditnotpass");
    }
}

