/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.opplugin.web.salaryfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.business.file.PersonCertCommonHelper;
import kd.swc.hsas.business.salaryfile.SWCSalaryFileServiceHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileHelper;
import kd.swc.hsas.business.salaryfile.SalaryFileServiceHelper;
import kd.swc.hsas.opplugin.validator.salaryfile.PersonCertValidator;
import kd.swc.hsas.opplugin.validator.salaryfile.SalaryFileCommonValidator;
import kd.swc.hsas.opplugin.validator.salaryfile.SalaryFileSaveValidator;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class SalaryFileChangeConfirmOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(SalaryFileChangeConfirmOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("person.personindexid");
        fieldKeys.add("person.name");
        fieldKeys.add("employee.person");
        fieldKeys.add("depemp.laborrelrecord");
        fieldKeys.add("adminorg");
        fieldKeys.add("empposinfo.adminorg");
        fieldKeys.add("empposinfo.adminorgvid");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SalaryFileCommonValidator());
        args.addValidator((AbstractValidator)new SalaryFileSaveValidator());
        args.addValidator((AbstractValidator)new PersonCertValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        Object[] selectedRows = args.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])selectedRows)) {
            return;
        }
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        for (Object dataEntity : selectedRows) {
            DynamicObject fileDy = fileHelper.generateEmptyDynamicObject();
            fileDy.set("id", (Object)dataEntity.getLong("boid"));
            dataEntity.set("salaryfile", (Object)fileDy);
            dataEntity.set("laborrelrecord", dataEntity.get("depemp.laborrelrecord"));
            DynamicObject person = dataEntity.getDynamicObject("person");
            if (person == null) {
                dataEntity.set("person", dataEntity.get("employee.person"));
            }
            dataEntity.set("name", dataEntity.get("person.name"));
            dataEntity.set("status", (Object)"C");
        }
        SalaryFileHelper.setEmpposinfo((DynamicObject[])selectedRows);
        SalaryFileHelper.setManagingScope((DynamicObject[])selectedRows);
        SalaryFileHelper.setAdminorgVid((DynamicObject[])selectedRows);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        this.dataEntities = e.getDataEntities();
        Map result = SalaryFileServiceHelper.genPersonChangeForSalaryFile(Arrays.asList(this.dataEntities));
        if (null != result && !MapUtils.getBoolean((Map)result, (Object)"success").booleanValue()) {
            this.getOption().setVariableValue("showGenPersonChangeTip", MapUtils.getString((Map)result, (Object)"message"));
        }
        ArrayList<Long> salaryFileIds = new ArrayList<Long>(10);
        for (DynamicObject dataEntity : this.dataEntities) {
            salaryFileIds.add(dataEntity.getLong("boid"));
        }
        SWCSalaryFileServiceHelper.refreshSalaryFileEmpAndScope(salaryFileIds, (boolean)false);
        List pIds = Arrays.stream(this.dataEntities).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        PersonCertCommonHelper.calPersonCertByPersonId(pIds);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String showGenPersonChangeTip = this.getOption().getVariableValue("showGenPersonChangeTip", null);
        if (null != showGenPersonChangeTip) {
            String message = this.getOperationResult().getMessage();
            this.getOperationResult().setMessage(message + showGenPersonChangeTip);
        }
        this.getOperationResult().setShowMessage(true);
    }
}

