/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;

public class SalaryDiffGroup
implements Serializable {
    private static final long serialVersionUID = 2199496553197824299L;
    private int seq;
    private Object[] dimValues;
    private Object[] relateValues;
    private Map<Long, List<Long>> tarIdsOfTask = Maps.newHashMapWithExpectedSize((int)12);
    private Map<Long, List<Long>> srcIdsOfTask = Maps.newHashMapWithExpectedSize((int)12);
    private long mainId;
    private Date mainDate;
    private Set<Long> personIds = Sets.newHashSetWithExpectedSize((int)12);
    private int tarSize = 0;
    private int srcSize = 0;
    private int personNum;

    public static SalaryDiffGroup newInstance(Object[] dimValues) {
        SalaryDiffGroup result = new SalaryDiffGroup();
        result.dimValues = dimValues;
        return result;
    }

    public void bizInfo() {
        this.personNum = this.personIds.size();
        this.personIds = Sets.newHashSetWithExpectedSize((int)12);
    }

    public void addTarId(Long id, Long taskId) {
        List dataList = this.tarIdsOfTask.computeIfAbsent(taskId, ky -> Lists.newLinkedList());
        dataList.add(id);
        ++this.tarSize;
    }

    public void addSrcId(Long id, Long taskId) {
        List dataList = this.srcIdsOfTask.computeIfAbsent(taskId, ky -> Lists.newLinkedList());
        dataList.add(id);
        ++this.srcSize;
    }

    public void addPersonId(Long personId) {
        this.personIds.add(personId);
    }

    public int changeFlagCode() {
        if (this.tarIdsOfTask.isEmpty()) {
            return 4;
        }
        return this.srcIdsOfTask.isEmpty() ? 2 : 1;
    }

    public void competeMainId(Date belongStartDate, Long dataId, Row row, List<String> relateOrderFields) {
        if (dataId == null) {
            return;
        }
        if (this.mainId == 0L || this.mainDate == null) {
            this.acceptMainId(dataId, belongStartDate, row, relateOrderFields, true);
            return;
        }
        if (belongStartDate != null && belongStartDate.after(this.mainDate)) {
            this.acceptMainId(dataId, belongStartDate, row, relateOrderFields, false);
        }
    }

    private void acceptMainId(Long dataId, Date belongStartDate, Row row, List<String> relateOrderFields, boolean init) {
        this.mainId = dataId;
        this.mainDate = belongStartDate;
        if (init) {
            this.relateValues = new Object[relateOrderFields.size()];
        }
        for (int index = 0; index < relateOrderFields.size(); ++index) {
            this.relateValues[index] = row.get(relateOrderFields.get(index));
        }
    }

    public int detailSize() {
        return this.tarSize + this.srcSize;
    }

    public Object dimValue(int index) {
        return this.dimValues[index];
    }

    public Object relateValue(int index) {
        return this.relateValues[index];
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public Object[] getDimValues() {
        return this.dimValues;
    }

    public void setDimValues(Object[] dimValues) {
        this.dimValues = dimValues;
    }

    public Object[] getRelateValues() {
        return this.relateValues;
    }

    public Map<Long, List<Long>> getTarIdsOfTask() {
        return this.tarIdsOfTask;
    }

    public void setTarIdsOfTask(Map<Long, List<Long>> tarIdsOfTask) {
        this.tarIdsOfTask = tarIdsOfTask;
    }

    public Map<Long, List<Long>> getSrcIdsOfTask() {
        return this.srcIdsOfTask;
    }

    public void setSrcIdsOfTask(Map<Long, List<Long>> srcIdsOfTask) {
        this.srcIdsOfTask = srcIdsOfTask;
    }

    public long getMainId() {
        return this.mainId;
    }

    public void setMainId(long mainId) {
        this.mainId = mainId;
    }

    public Date getMainDate() {
        return this.mainDate;
    }

    public void setMainDate(Date mainDate) {
        this.mainDate = mainDate;
    }

    public int getTarSize() {
        return this.tarSize;
    }

    public void setTarSize(int tarSize) {
        this.tarSize = tarSize;
    }

    public int getSrcSize() {
        return this.srcSize;
    }

    public void setSrcSize(int srcSize) {
        this.srcSize = srcSize;
    }

    public int getPersonNum() {
        if (this.personNum == 0) {
            return this.personIds.size();
        }
        return this.personNum;
    }

    public void setPersonNum(int personNum) {
        this.personNum = personNum;
    }
}

