/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.entity;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.Pair;
import kd.swc.hsas.report.api.RowDataMatcher;
import kd.swc.hsas.report.entity.SalaryDiffGroup;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SalaryDiffGroupMatcher {
    private int totalSeq = 1;
    private int changeFlag;
    private int groupBatchSize;
    private int detailBatchSize;
    private int detailSize;
    private String[] dimFields;
    private List<String> relateOrderFields;
    private Map<String, Boolean> dimOrder;
    private Map<String, Function<SalaryDiffGroup, Object>> valueFetcher;
    private RowDataMatcher tarDataMatcher;
    private RowDataMatcher srcDataMatcher;

    public SalaryDiffGroupMatcher() {
        this(1024);
    }

    public SalaryDiffGroupMatcher(int groupBatchSize) {
        this.groupBatchSize = groupBatchSize;
    }

    public RowMeta newDimRowMeta(RowMeta byBatchRowMeta) {
        int size = this.dimFields.length + 3 + (this.relateOrderFields == null ? 0 : this.relateOrderFields.size());
        String[] columns = Arrays.copyOf(this.dimFields, size);
        DataType[] types = new DataType[columns.length];
        for (int index = 0; index < this.dimFields.length; ++index) {
            types[index] = byBatchRowMeta.getField(this.dimFields[index]).getDataType();
        }
        columns[this.dimFields.length] = "personNum";
        types[this.dimFields.length] = DataType.IntegerType;
        columns[this.dimFields.length + 1] = "changeFlagCode";
        types[this.dimFields.length + 1] = DataType.IntegerType;
        columns[this.dimFields.length + 2] = "seq";
        types[this.dimFields.length + 2] = DataType.StringType;
        if (this.relateOrderFields != null) {
            int startIndex = this.dimFields.length + 3;
            for (int index = 0; index < this.relateOrderFields.size(); ++index) {
                columns[startIndex + index] = this.relateOrderFields.get(index);
                types[startIndex + index] = byBatchRowMeta.getField(this.relateOrderFields.get(index)).getDataType();
            }
        }
        return RowMetaFactory.createRowMeta((String[])columns, (DataType[])types);
    }

    public Pair<String, SalaryDiffGroup> addRow(Map<String, SalaryDiffGroup> diffGroupMap, Row row, boolean retry) {
        Object[] dimValues = new Object[this.dimFields.length];
        for (int i = 0; i < this.dimFields.length; ++i) {
            dimValues[i] = row.get(this.dimFields[i]);
        }
        String groupKey = this.groupKey(dimValues);
        SalaryDiffGroup diffGroup = diffGroupMap.get(groupKey);
        if (diffGroup == null) {
            diffGroup = SalaryDiffGroup.newInstance(dimValues);
            diffGroup.setSeq(this.totalSeq++);
            if (this.isNeedNewBatch(diffGroupMap)) {
                if (!retry) {
                    Iterator<Map.Entry<String, SalaryDiffGroup>> iterator = diffGroupMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, SalaryDiffGroup> next = iterator.next();
                        SalaryDiffGroup value = next.getValue();
                        if ((value.changeFlagCode() & this.changeFlag) != 0) continue;
                        this.detailSize -= value.detailSize();
                        iterator.remove();
                    }
                    return this.addRow(diffGroupMap, row, true);
                }
                this.match(diffGroup, row);
                this.detailSize = 1;
                return new Pair((Object)groupKey, (Object)diffGroup);
            }
            diffGroupMap.put(groupKey, diffGroup);
        }
        this.match(diffGroup, row);
        ++this.detailSize;
        return null;
    }

    public List<QFilter> addByBatchFilter(List<QFilter> qFilters) {
        QFilter filter = new QFilter("id", "=", (Object)0);
        filter = filter.or(this.tarDataMatcher.toQFilter());
        filter = filter.or(this.srcDataMatcher.toQFilter());
        if (CollectionUtils.isEmpty(qFilters)) {
            return Lists.newArrayList((Object[])new QFilter[]{filter});
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(qFilters.size() + 1));
        result.addAll(qFilters);
        result.add(filter);
        return result;
    }

    public String addByBatchField(List<String> groupByFields) {
        LinkedHashSet fieldSet = Sets.newLinkedHashSet(groupByFields);
        fieldSet.add(this.tarDataMatcher.filterField());
        fieldSet.add("id");
        fieldSet.add("hsas_employee.id");
        fieldSet.add("hsas_calpayrolltask.STARTDATE");
        fieldSet.add("caltask.id");
        if (this.relateOrderFields != null) {
            fieldSet.addAll(this.relateOrderFields);
        }
        return Joiner.on((char)',').join((Iterable)fieldSet);
    }

    public String addByBatchOrderBy(Map<String, String> orderByFieldMap, List<String> relateFields) {
        int newLength = this.dimFields.length + (orderByFieldMap == null ? 0 : orderByFieldMap.size());
        this.valueFetcher = Maps.newHashMapWithExpectedSize((int)newLength);
        for (int index = 0; index < this.dimFields.length; ++index) {
            int finalIndex = index;
            this.valueFetcher.put(this.dimFields[index], ele -> ele.dimValue(finalIndex));
        }
        if (orderByFieldMap == null || orderByFieldMap.isEmpty()) {
            this.dimOrder = Maps.newLinkedHashMapWithExpectedSize((int)this.dimFields.length);
            for (String dimField : this.dimFields) {
                this.dimOrder.put(dimField, Boolean.FALSE);
            }
            this.relateOrderFields = Lists.newArrayList();
            return null;
        }
        this.dimOrder = Maps.newLinkedHashMapWithExpectedSize((int)newLength);
        ArrayList list = Lists.newArrayList((Object[])this.dimFields);
        List<Object> safeRelateFields = relateFields == null ? Lists.newArrayList() : relateFields;
        this.relateOrderFields = Lists.newArrayListWithExpectedSize((int)safeRelateFields.size());
        for (Map.Entry<String, String> entry : orderByFieldMap.entrySet()) {
            String fieldName = entry.getKey();
            this.dimOrder.put(fieldName, SWCStringUtils.equalsIgnoreCase((String)entry.getValue(), (String)"DESC"));
            if (list.remove(fieldName)) continue;
            if (safeRelateFields.remove(fieldName)) {
                int curSize = this.relateOrderFields.size();
                this.valueFetcher.put(fieldName, ele -> ele.relateValue(curSize));
                this.relateOrderFields.add(entry.getKey());
                continue;
            }
            if ("personNum".equalsIgnoreCase(fieldName)) {
                this.valueFetcher.put(fieldName, SalaryDiffGroup::getPersonNum);
                continue;
            }
            if (!"changeFlag".equalsIgnoreCase(fieldName)) continue;
            this.valueFetcher.put(fieldName, SalaryDiffGroup::changeFlagCode);
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (String field : list) {
                this.dimOrder.put(field, Boolean.FALSE);
            }
        }
        return "id";
    }

    public String groupKey(Object[] dimValues) {
        return Joiner.on((char)'$').useForNull("NULL").join(dimValues);
    }

    public void match(SalaryDiffGroup diffGroup, Row row) {
        Long dataId = row.getLong("id");
        if (this.tarDataMatcher.match(row)) {
            diffGroup.addTarId(dataId, row.getLong("caltask.id"));
        } else if (this.srcDataMatcher.match(row)) {
            diffGroup.addSrcId(dataId, row.getLong("caltask.id"));
        }
        diffGroup.addPersonId(row.getLong("hsas_employee.id"));
        Date belongStartDate = row.getDate("hsas_calpayrolltask.STARTDATE");
        diffGroup.competeMainId(belongStartDate, dataId, row, this.relateOrderFields);
    }

    public Map<String, SalaryDiffGroup> newGroupBatchMap() {
        return Maps.newHashMapWithExpectedSize((int)this.getGroupBatchSize());
    }

    public Comparator<Map.Entry<String, SalaryDiffGroup>> comparator() {
        if (this.dimOrder == null) {
            return (grp1, grp2) -> 0;
        }
        return (grp1, grp2) -> {
            for (Map.Entry<String, Boolean> entry : this.dimOrder.entrySet()) {
                int res;
                Function<SalaryDiffGroup, Object> vf = this.valueFetcher.get(entry.getKey());
                if (vf == null || (res = this.compareVal(vf.apply((SalaryDiffGroup)grp1.getValue()), vf.apply((SalaryDiffGroup)grp2.getValue()))) == 0) continue;
                Boolean order = entry.getValue();
                if (order != null && order.booleanValue()) {
                    return -res;
                }
                return res;
            }
            return 0;
        };
    }

    private int compareVal(Object val1, Object val2) {
        if (val1 == null && val2 == null) {
            return 0;
        }
        if (val1 == null) {
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        if (!(val1 instanceof Comparable) || !(val2 instanceof Comparable)) {
            return 0;
        }
        return ((Comparable)val1).compareTo(val2);
    }

    protected boolean isNeedNewBatch(Map<String, SalaryDiffGroup> diffGroupMap) {
        return false;
    }

    public boolean isBatchByAsync() {
        return false;
    }

    public int getDetailSize() {
        return this.detailSize;
    }

    public int getGroupBatchSize() {
        return this.groupBatchSize;
    }

    public void setGroupBatchSize(int groupBatchSize) {
        this.groupBatchSize = groupBatchSize;
    }

    public int getDetailBatchSize() {
        return this.detailBatchSize;
    }

    public void setDetailBatchSize(int detailBatchSize) {
        this.detailBatchSize = detailBatchSize;
    }

    public String[] getDimFields() {
        return this.dimFields;
    }

    public void setDimFields(String[] dimFields) {
        this.dimFields = dimFields;
    }

    public Map<String, Boolean> getDimOrder() {
        return this.dimOrder;
    }

    public void setDimOrder(Map<String, Boolean> dimOrder) {
        this.dimOrder = dimOrder;
    }

    public RowDataMatcher getTarDataMatcher() {
        return this.tarDataMatcher;
    }

    public void setTarDataMatcher(RowDataMatcher tarDataMatcher) {
        this.tarDataMatcher = tarDataMatcher;
    }

    public RowDataMatcher getSrcDataMatcher() {
        return this.srcDataMatcher;
    }

    public void setSrcDataMatcher(RowDataMatcher srcDataMatcher) {
        this.srcDataMatcher = srcDataMatcher;
    }

    public void setChangeFlag(int changeFlag) {
        this.changeFlag = changeFlag;
    }

    public int getChangeFlag() {
        return this.changeFlag;
    }
}

