/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.helper;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.report.common.SalaryRptUtils;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class SalaryRptQueryParamHelper {
    public static QFilter buildTimeFilter(FilterInfo filterInfo) {
        String periodType = filterInfo.getString("period");
        QFilter filter = null;
        switch (periodType) {
            case "A": {
                filter = new QFilter("hsas_calpayrolltask.STARTDATE", "<=", (Object)filterInfo.getDate("belongenddate"));
                filter.and("hsas_calpayrolltask.ENDDATE", ">=", (Object)filterInfo.getDate("belongstartdate"));
                break;
            }
            case "B": {
                filter = new QFilter("belongperiod", ">=", (Object)SalaryRptUtils.getMonthFirstDay(filterInfo.getDate("startperiod"), 0));
                filter.and("belongperiod", "<", (Object)SalaryRptUtils.getMonthFirstDay(filterInfo.getDate("endperiod"), 1));
                break;
            }
            case "C": {
                Set<Long> periodIdList = SalaryRptQueryParamHelper.getIdListFromFilterInfo(filterInfo, "calperiod");
                filter = new QFilter("calperiod", "in", periodIdList);
                break;
            }
        }
        return filter;
    }

    public static QFilter buildPeriodFilter(FilterInfo filterInfo) {
        QFilter filter = new QFilter("hsas_calpayrolltask.STARTDATE", ">=", (Object)filterInfo.getDate("startperiod"));
        Date endDate = filterInfo.getDate("endperiod");
        endDate = SWCDateTimeUtils.addMonth((Date)endDate, (int)1);
        filter.and("hsas_calpayrolltask.ENDDATE", "<", (Object)endDate);
        return filter;
    }

    public static QFilter buildCurrencyFilter(FilterInfo filterInfo) {
        return new QFilter("hsas_calpayrolltask.payrollgroupv.currency", "=", (Object)filterInfo.getLong("calcurrency"));
    }

    public static QFilter buildOrgFilter(FilterInfo filterInfo, String entityCode) {
        Set<Long> orgList = SalaryRptQueryParamHelper.getIdListFromFilterInfo(filterInfo, "org");
        if (CollectionUtils.isEmpty(orgList)) {
            return null;
        }
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"/UHMBBGZQ65X", (String)entityCode);
        if (!permOrgs.hasAllOrgPerm()) {
            List hasPermOrgList = permOrgs.getHasPermOrgs();
            if (hasPermOrgList != null) {
                HashSet<Long> hasPermOrgs = new HashSet<Long>(hasPermOrgList);
                orgList = CollectionUtils.isEmpty(orgList) ? hasPermOrgs : orgList.stream().filter(obj -> hasPermOrgs.contains(obj)).collect(Collectors.toSet());
            } else {
                orgList = new HashSet<Long>(0);
            }
        } else if (CollectionUtils.isEmpty(orgList)) {
            return null;
        }
        return new QFilter("hsas_calpayrolltask.org", "in", orgList);
    }

    public static QFilter buildLaborRelTypeFilter(FilterInfo filterInfo) {
        Set<Long> laborRelTypeList = SalaryRptQueryParamHelper.getIdListFromFilterInfo(filterInfo, "laborreltype");
        if (CollectionUtils.isEmpty(laborRelTypeList)) {
            return null;
        }
        return new QFilter("hsas_empentrel.laborreltype", "in", laborRelTypeList);
    }

    public static QFilter buildCalStatusFilter(FilterInfo filterInfo) {
        HashSet calStatusList = SalaryRptQueryParamHelper.getStrListFromFilterInfo(filterInfo, "calstatus");
        if (CollectionUtils.isEmpty(calStatusList)) {
            calStatusList = Sets.newHashSet((Object[])new String[]{"2", "14", "3", "11", "7", "12", "4", "10"});
        }
        return new QFilter("calstatus", "in", calStatusList);
    }

    public static QFilter buildOnholdStatusFilter(FilterInfo filterInfo) {
        QFilter filter;
        HashSet onholdStatusSet = SalaryRptQueryParamHelper.getStrListFromFilterInfo(filterInfo, "onholdstatus");
        if (CollectionUtils.isEmpty(onholdStatusSet)) {
            onholdStatusSet = Sets.newHashSet((Object[])new String[]{"0", "1"});
        }
        if (onholdStatusSet.remove("0")) {
            filter = new QFilter("onholdstatus", "is null", null);
            filter.or("onholdstatus", "=", (Object)" ");
            if (onholdStatusSet.size() != 0) {
                filter.or("onholdstatus", "in", (Object)onholdStatusSet);
            }
        } else {
            filter = new QFilter("onholdstatus", "in", onholdStatusSet);
        }
        return filter;
    }

    public static QFilter buildBaseDataIdFilter(FilterInfo filterInfo, String formFieldCode, String filterFieldCode) {
        Set<Long> baseDataIds = SalaryRptQueryParamHelper.getIdListFromFilterInfo(filterInfo, formFieldCode);
        if (CollectionUtils.isEmpty(baseDataIds)) {
            return null;
        }
        return new QFilter(filterFieldCode, "in", baseDataIds);
    }

    public static QFilter buildPersonFilter(FilterInfo filterInfo) {
        String personFieldStr = filterInfo.getString("personfield");
        if (StringUtils.isEmpty((CharSequence)personFieldStr)) {
            return null;
        }
        String[] personFilters = personFieldStr.split(";");
        QFilter qFilter = null;
        for (int i = 0; i < personFilters.length; ++i) {
            String filterStr = '%' + personFilters[i] + '%';
            if (qFilter == null) {
                qFilter = new QFilter("empnumber", "like", (Object)filterStr);
                qFilter.or("name", "like", (Object)filterStr);
                continue;
            }
            qFilter.or("empnumber", "like", (Object)filterStr);
            qFilter.or("name", "like", (Object)filterStr);
        }
        return qFilter;
    }

    public static Set<Long> getIdListFromFilterInfo(FilterInfo filterInfo, String key) {
        Set<Object> idList = Sets.newHashSetWithExpectedSize((int)16);
        FilterItemInfo filterItemInfo = filterInfo.getFilterItem(key);
        if (!Objects.isNull(filterItemInfo)) {
            DynamicObject value;
            if (filterItemInfo.getValue() instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)filterItemInfo.getValue();
                if (!Objects.isNull(values)) {
                    idList = values.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
                }
            } else if (filterItemInfo.getValue() instanceof DynamicObject && !Objects.isNull(value = (DynamicObject)filterItemInfo.getValue())) {
                idList.add(value.getLong("id"));
            }
        }
        return idList;
    }

    public static Set<String> getStrListFromFilterInfo(FilterInfo filterInfo, String key) {
        String values;
        Set<Object> strSet = Sets.newHashSetWithExpectedSize((int)16);
        FilterItemInfo filterItemInfo = filterInfo.getFilterItem(key);
        if (filterItemInfo != null && !StringUtils.isEmpty((CharSequence)(values = (String)filterItemInfo.getValue()))) {
            String[] split = values.split(",");
            strSet = Arrays.stream(split).filter(str -> !StringUtils.isEmpty((CharSequence)str)).collect(Collectors.toSet());
        }
        return strSet;
    }
}

