/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.swc.hsas.report.api.SalaryRptParamHandler;
import kd.swc.hsas.report.entity.SalaryRptQueryInfo;
import kd.swc.hsas.report.helper.CalPersonQueryHelper;
import kd.swc.hsas.report.helper.SalaryRptAlgoHelper;
import kd.swc.hsas.report.impl.SalaryDetailRptParamHandler;
import kd.swc.hsas.report.web.SalaryRptPageAbstractPlugin;

public class SalaryDetailQueryRpt
extends SalaryRptPageAbstractPlugin {
    private final Log LOGGER = LogFactory.getLog(SalaryDetailQueryRpt.class);
    private final String CACHEKEY_LASTBATCHENDEMPNUMBER = "lastBatchEndEmpNumber";
    private final String CACHEKEY_COUNT = "count";
    private final String CACHEKEY_TOTALMAP = "totalMap";

    @Override
    protected DataSet doQueryBatchBy(ReportQueryParam queryParam, SalaryRptQueryInfo queryInfo, boolean isLoadAll) {
        DynamicObjectCollection idCollection;
        int queryByBatchSize = queryInfo.getQueryByBatchSize();
        int batchSize = queryInfo.getBatchSize();
        String selectFields = this.getSelectFields(queryInfo);
        ArrayList filters = Lists.newArrayList(queryInfo.getFilters());
        this.LOGGER.info("SalaryDetailQueryRpt doQueryBatchBy filters:{}", (Object)filters);
        this.timeLog.logStart("SalaryDetailQueryRpt doQueryBatchBy queryId");
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryInfo.getQueryEntityCode());
        if (!isLoadAll) {
            idCollection = HRQueryEntityHelper.getInstance().getQueryDyoColl(queryEntityType, selectFields, filters.toArray(new QFilter[0]), queryInfo.getOrderByStr(), 0, queryByBatchSize);
        } else {
            this.addEndPersonNumFilter(queryInfo, filters);
            idCollection = HRQueryEntityHelper.getInstance().getQueryDyoColl(queryEntityType, selectFields, filters.toArray(new QFilter[0]), queryInfo.getOrderByStr());
        }
        this.timeLog.logEnd("SalaryDetailQueryRpt doQueryBatchBy queryId");
        if (idCollection == null) {
            this.LOGGER.info("SalaryDetailQueryRpt doQueryBatchBy idCollection is null...");
            idCollection = new DynamicObjectCollection();
        }
        logger.info("SalaryDetailQueryRpt doQueryBatchBy idCollection size\uff1a" + idCollection.size());
        LinkedHashMap batchIdMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        int totalBatch = this.countTotalBatch(idCollection, queryInfo, batchIdMap, queryByBatchSize, batchSize, selectFields, isLoadAll);
        logger.info("SalaryDetailQueryRpt doQueryBatchBy totalBatch \uff1a" + totalBatch);
        queryInfo.setTotalBatch(totalBatch);
        if (!isLoadAll && idCollection.size() < queryByBatchSize) {
            queryInfo.setLoadAll(true);
            this.cacheIsLoadAll(queryInfo);
        } else {
            queryInfo.setLoadAll(isLoadAll);
        }
        this.cacheBatchIds(queryInfo, batchIdMap);
        queryParam.byBatchInfo().setCountPerBatch(1);
        List<Object> queryByIds = Lists.newArrayListWithCapacity((int)0);
        if (!isLoadAll) {
            queryByIds = this.rebuildBatchIds(totalBatch + 1);
        }
        return this.buildBatchDataSet(queryByIds);
    }

    @Override
    protected DataSet doQuery(ReportQueryParam reportQueryParam, Object o, SalaryRptQueryInfo queryInfo) {
        int currentBatchIndex = reportQueryParam.byBatchInfo().getCurrentBatchIndex();
        List<Long> idList = this.getCurrentBatchInfo(currentBatchIndex, queryInfo);
        this.LOGGER.info("SalaryDetailQueryRpt doQuery currentBatchIndex:{}", (Object)currentBatchIndex);
        if (idList == null || idList.isEmpty()) {
            this.LOGGER.info("SalaryDetailQueryRpt doQuery currentBatchIndex:{} idList is null or empty, return null.", (Object)currentBatchIndex);
            return SalaryRptAlgoHelper.buildDataSet(queryInfo.getRowMeta(), null, ((Object)((Object)this)).getClass().getName());
        }
        this.timeLog.logStart("SalaryDetailQueryRpt doQuery queryDetail");
        DataSet detailDataSet = new CalPersonQueryHelper().buildDetailDataSet(queryInfo.getQueryEntityCode(), idList, queryInfo.getMainSelectFields(), queryInfo.getItemTypeToIdMap(), queryInfo.getDataTypeMap(), queryInfo.getStatisticsTagRelMap());
        this.timeLog.logEnd("SalaryDetailQueryRpt doQuery queryDetail");
        detailDataSet = detailDataSet.addField("1", "rowtype");
        String[] orderBy = this.getOrderBy(queryInfo);
        if (orderBy != null) {
            detailDataSet = detailDataSet.orderBy(orderBy);
        }
        detailDataSet = this.addSeq(queryInfo, detailDataSet, idList.size());
        DataSet resultSet = this.addSubTotalDataSet(queryInfo, detailDataSet.copy(), orderBy);
        return this.addTotalDataSet(resultSet, detailDataSet, queryInfo, currentBatchIndex);
    }

    private int countTotalBatch(DynamicObjectCollection idCollection, SalaryRptQueryInfo queryInfo, Map<Integer, List<Long>> batchIdMap, int queryByBatchSize, int batchSize, String selectFields, boolean isLoadAll) {
        int totalBatch = queryInfo.getSumTypeSign().equals("1") ? this.collectionBatchBy(idCollection, queryInfo, batchIdMap, queryByBatchSize, batchSize, isLoadAll) : this.collectionPersonBatchBy(idCollection, queryInfo, batchIdMap, batchSize, isLoadAll, selectFields);
        return totalBatch;
    }

    private DataSet addSeq(SalaryRptQueryInfo queryInfo, DataSet detailDataSet, int size) {
        Integer lastSeq = queryInfo.getCustomPara("lastSeq", Integer.class);
        if (lastSeq == null) {
            lastSeq = 0;
        }
        queryInfo.addCustomPara("lastSeq", size + lastSeq);
        detailDataSet = detailDataSet.addField("1", "seqnumber").addBalanceField("seqnumber", "balance");
        detailDataSet = detailDataSet.addField("balance + " + lastSeq, "balance");
        detailDataSet = detailDataSet.addField("cast(balance as string)", "seq");
        return detailDataSet.removeFields(new String[]{"seqnumber"}).removeFields(new String[]{"balance"});
    }

    private int collectionBatchBy(DynamicObjectCollection idCollection, SalaryRptQueryInfo queryInfo, Map<Integer, List<Long>> batchIdMap, int queryByBatchSize, int batchSize, boolean isLoadAll) {
        int i;
        ArrayList batchIds = Lists.newArrayListWithExpectedSize((int)batchSize);
        int totalBatch = queryInfo.getTotalBatch();
        int n = i = isLoadAll ? queryByBatchSize : 0;
        while (i < idCollection.size()) {
            if (i == (isLoadAll ? queryByBatchSize : 0) || batchIds.size() == batchSize) {
                batchIds = Lists.newArrayListWithExpectedSize((int)batchSize);
                batchIdMap.put(++totalBatch, batchIds);
            }
            batchIds.add(((DynamicObject)idCollection.get(i)).getLong("id"));
            ++i;
        }
        return totalBatch;
    }

    private int collectionPersonBatchBy(DynamicObjectCollection idCollection, SalaryRptQueryInfo queryInfo, Map<Integer, List<Long>> batchIdMap, int batchSize, boolean isLoadAll, String selectFields) {
        String lastEmpNumber = "";
        HashSet lastEmpNumberIds = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList batchIds = Lists.newArrayListWithExpectedSize((int)batchSize);
        int totalBatch = queryInfo.getTotalBatch();
        for (int i = 0; i < idCollection.size(); ++i) {
            DynamicObject dyn = (DynamicObject)idCollection.get(i);
            String currEmpNumber = dyn.getString("empnumber");
            if (i == 0 || !lastEmpNumber.equals(currEmpNumber)) {
                lastEmpNumberIds = Sets.newHashSetWithExpectedSize((int)16);
                if (i == 0 || batchIds.size() >= batchSize) {
                    batchIds = Lists.newArrayListWithExpectedSize((int)batchSize);
                    batchIdMap.put(++totalBatch, batchIds);
                }
            }
            Long id = dyn.getLong("id");
            batchIds.add(id);
            lastEmpNumberIds.add(id);
            lastEmpNumber = currEmpNumber;
        }
        if (!isLoadAll && idCollection.size() >= queryInfo.getQueryByBatchSize() && !CollectionUtils.isEmpty((Collection)batchIds)) {
            batchIds.removeAll(lastEmpNumberIds);
            this.addPersonData(queryInfo, batchIds, lastEmpNumber, selectFields);
            queryInfo.addCustomPara("lastBatchEndEmpNumber", lastEmpNumber);
        }
        return totalBatch;
    }

    private DataSet addSubTotalDataSet(SalaryRptQueryInfo queryInfo, DataSet detailDataSet, String[] orderBy) {
        DataSet resultSet = null;
        switch (queryInfo.getSumTypeSign()) {
            case "1": {
                return detailDataSet;
            }
            case "0": {
                resultSet = this.buildSubTotalDataSet(detailDataSet, queryInfo);
                break;
            }
            case "2": {
                DataSet subTotalDataSet = this.buildSubTotalDataSet(detailDataSet, queryInfo);
                resultSet = detailDataSet.union(subTotalDataSet);
                break;
            }
        }
        if (orderBy != null && resultSet != null) {
            resultSet = resultSet.orderBy(orderBy);
        }
        return resultSet;
    }

    private String[] getOrderBy(SalaryRptQueryInfo queryInfo) {
        String orderByStr = queryInfo.getOrderByStr();
        if (StringUtils.isEmpty((Object)orderByStr)) {
            return null;
        }
        String[] orderBy = orderByStr.split(",");
        if (queryInfo.getSumTypeSign().equals("2")) {
            String[] newOrderBy = queryInfo.getCustomPara("newOrderBy", String[].class);
            if (newOrderBy == null) {
                newOrderBy = new String[orderBy.length + 1];
                for (int i = 0; i < newOrderBy.length; ++i) {
                    newOrderBy[i] = i < 2 ? orderBy[i] : (i == 2 ? "rowtype" : orderBy[i - 1]);
                }
                queryInfo.addCustomPara("newOrderBy", newOrderBy);
            }
            return newOrderBy;
        }
        return orderBy;
    }

    private List<Long> getCurrentBatchInfo(int currentBatchIndex, SalaryRptQueryInfo queryInfo) {
        CachedDataSet idDataSet;
        String cacheId = queryInfo.getPageId() + "_batch_" + currentBatchIndex;
        try {
            idDataSet = Algo.getCacheDataSet((String)cacheId);
        }
        catch (Exception exception) {
            this.LOGGER.info("SalaryDetailQueryRpt getCurrentBatchInfo getCacheDataSet(cacheId:{}) error : ", (Object)cacheId, (Object)exception);
            return null;
        }
        List list = idDataSet.getList(0, idDataSet.getRowCount());
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)idDataSet.getRowCount());
        list.forEach(obj -> idList.add(obj.getLong("id")));
        return idList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet addTotalDataSet(DataSet resultSet, DataSet detailDataSet, SalaryRptQueryInfo queryInfo, int currentBatchIndex) {
        try {
            if (!queryInfo.isShowTotal()) {
                DataSet dataSet = resultSet;
                return dataSet;
            }
            Map<String, Object> totalRowInfoMap = this.cacheTotalRowInfo(detailDataSet, queryInfo);
            if (currentBatchIndex == queryInfo.getTotalBatch() - 1 && queryInfo.isLoadAll()) {
                DataSet totalDataSet = this.buildTotalDataSet(detailDataSet, totalRowInfoMap);
                resultSet = resultSet.union(totalDataSet);
            }
        }
        finally {
            if (detailDataSet != null) {
                detailDataSet.close();
            }
        }
        return resultSet;
    }

    private DataSet buildTotalDataSet(DataSet dataSet, Map<String, Object> totalRowInfoMap) {
        String totalStr = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"SalaryDetailQueryRpt_1", (String)"swc-hsas-report", (Object[])new Object[0]);
        String personStr = ResManager.loadKDString((String)"\u4eba\u6b21", (String)"SalaryDetailQueryRpt_2", (String)"swc-hsas-report", (Object[])new Object[0]);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        String[] totalFieldNames = new String[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Object itemValue = totalRowInfoMap.get(fieldName);
            if (fieldName.equals("seq")) {
                fieldName = "'" + totalStr + "' " + "seq";
            } else if (fieldName.equals("empnumber")) {
                fieldName = "'" + totalRowInfoMap.get("count") + personStr + "' as " + "empnumber";
            } else if (fieldName.equals("rowtype")) {
                fieldName = "3 rowtype";
            } else if (itemValue != null) {
                if (itemValue instanceof BigDecimal) {
                    itemValue = ((BigDecimal)itemValue).toPlainString();
                }
                fieldName = itemValue + " " + fieldName;
            } else {
                fieldName = "null " + fieldName;
            }
            totalFieldNames[i] = fieldName;
        }
        dataSet = dataSet.groupBy().finish();
        return dataSet.select(totalFieldNames);
    }

    private Map<String, Object> cacheTotalRowInfo(DataSet detailDataSet, SalaryRptQueryInfo queryInfo) {
        Map totalRowInfoMap = queryInfo.getCustomPara("totalMap", Map.class);
        if (CollectionUtils.isEmpty((Map)totalRowInfoMap)) {
            totalRowInfoMap = Maps.newLinkedHashMapWithExpectedSize((int)(queryInfo.getSumFieldCodes().size() + 1));
            queryInfo.addCustomPara("totalMap", totalRowInfoMap);
        }
        this.itemValueCount(detailDataSet.copy(), queryInfo, totalRowInfoMap);
        this.fileNumberCount(detailDataSet.copy(), queryInfo, totalRowInfoMap);
        return totalRowInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemValueCount(DataSet detailDataSet, SalaryRptQueryInfo queryInfo, Map<String, Object> totalRowInfoMap) {
        try {
            Set<String> sumFieldCodes = queryInfo.getSumFieldCodes();
            GroupbyDataSet groupbyDataSet = detailDataSet.groupBy(new String[]{"hsas_calpayrolltask.payrollgroupv.currency"});
            if (!CollectionUtils.isEmpty(sumFieldCodes)) {
                sumFieldCodes.forEach(arg_0 -> ((GroupbyDataSet)groupbyDataSet).sum(arg_0));
            }
            DataSet totalDataSet = groupbyDataSet.finish();
            for (Row row : totalDataSet) {
                for (String sumFieldCode : sumFieldCodes) {
                    Object oldValue = totalRowInfoMap.get(sumFieldCode);
                    if (oldValue == null) {
                        oldValue = new BigDecimal(0);
                    }
                    BigDecimal currentValue = row.getBigDecimal(sumFieldCode) == null ? new BigDecimal(0) : row.getBigDecimal(sumFieldCode);
                    currentValue = currentValue.add((BigDecimal)oldValue);
                    totalRowInfoMap.put(sumFieldCode, currentValue);
                }
                totalRowInfoMap.put("hsas_calpayrolltask.payrollgroupv.currency", row.get("hsas_calpayrolltask.payrollgroupv.currency"));
            }
        }
        finally {
            if (detailDataSet != null) {
                detailDataSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileNumberCount(DataSet detailDataSet, SalaryRptQueryInfo queryInfo, Map<String, Object> totalRowInfoMap) {
        try {
            int empNumberCount;
            if (queryInfo.getSumTypeSign().equals("1")) {
                Set empNumberSet = queryInfo.getCustomPara("empNumberSet", Set.class);
                if (empNumberSet == null) {
                    empNumberSet = Sets.newHashSetWithExpectedSize((int)16);
                    queryInfo.addCustomPara("empNumberSet", empNumberSet);
                }
                this.collectEmpNum(detailDataSet, empNumberSet);
                empNumberCount = empNumberSet.size();
            } else {
                HashSet currPageEmpNumberSet = Sets.newHashSetWithExpectedSize((int)16);
                this.collectEmpNum(detailDataSet, currPageEmpNumberSet);
                Object oldPersonCount = totalRowInfoMap.get("count") == null ? Integer.valueOf(0) : totalRowInfoMap.get("count");
                empNumberCount = currPageEmpNumberSet.size() + (Integer)oldPersonCount;
            }
            totalRowInfoMap.put("count", empNumberCount);
        }
        finally {
            if (detailDataSet != null) {
                detailDataSet.close();
            }
        }
    }

    private void collectEmpNum(DataSet detailDataSet, Set<String> empNumberSet) {
        if (detailDataSet == null || empNumberSet == null) {
            return;
        }
        for (Row row : detailDataSet) {
            String empNumber = row.getString("empnumber");
            if (StringUtils.isEmpty((Object)empNumber)) continue;
            empNumberSet.add(empNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet buildSubTotalDataSet(DataSet detailDataSet, SalaryRptQueryInfo queryInfo) {
        try {
            Set<String> sumFieldCodes = queryInfo.getSumFieldCodes();
            String subTotalStr = ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"MonthlyDeptSalaryQueryRpt_1", (String)"swc-hsas-report", (Object[])new Object[0]);
            GroupbyDataSet subTotalGroupBy = detailDataSet.groupBy(new String[]{"empnumber", "hsas_employee.id", "hsas_calpayrolltask.payrollgroupv.currency"});
            if (!CollectionUtils.isEmpty(sumFieldCodes)) {
                sumFieldCodes.forEach(arg_0 -> ((GroupbyDataSet)subTotalGroupBy).sum(arg_0));
            }
            subTotalGroupBy.maxP("hsas_calpayrolltask.payrollgroupv.currency", "name", "name");
            DataSet subTotalDataSet = subTotalGroupBy.finish();
            String[] fieldNames = detailDataSet.getRowMeta().getFieldNames();
            String[] subTotalFieldNames = new String[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                if (fieldName.equals("seq")) {
                    fieldName = subTotalStr + " " + "seq";
                } else if (fieldName.equals("rowtype")) {
                    fieldName = "2 rowtype";
                } else if (!(sumFieldCodes.contains(fieldName) || fieldName.equals("empnumber") || fieldName.equals("hsas_calpayrolltask.payrollgroupv.currency") || fieldName.equals("name") || fieldName.equals("hsas_employee.id"))) {
                    fieldName = "null " + fieldName;
                }
                subTotalFieldNames[i] = fieldName;
            }
            DataSet dataSet = subTotalDataSet.select(subTotalFieldNames);
            return dataSet;
        }
        finally {
            if (detailDataSet != null) {
                detailDataSet.close();
            }
        }
    }

    private void addEndPersonNumFilter(SalaryRptQueryInfo queryInfo, List<QFilter> filters) {
        String lastBatchEndEmpNumber = queryInfo.getCustomPara("lastBatchEndEmpNumber", String.class);
        if (!queryInfo.getSumTypeSign().equals("1") && !StringUtils.isEmpty((Object)lastBatchEndEmpNumber)) {
            Map<String, String> orderByFieldMap = queryInfo.getOrderByFieldMap();
            String employeeSortType = orderByFieldMap.get("empnumber");
            String comparator = employeeSortType.equals("ASC") ? ">" : "<";
            filters.add(new QFilter("empnumber", comparator, (Object)lastBatchEndEmpNumber));
        }
    }

    private void addPersonData(SalaryRptQueryInfo queryInfo, List<Long> batchIds, String lastEmpNumber, String selectFields) {
        ArrayList filters = Lists.newArrayList(queryInfo.getFilters());
        filters.add(new QFilter("empnumber", "=", (Object)lastEmpNumber));
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryInfo.getQueryEntityCode());
        DynamicObjectCollection idCollection = HRQueryEntityHelper.getInstance().getQueryDyoColl(queryEntityType, selectFields, filters.toArray(new QFilter[0]), queryInfo.getOrderByStr());
        for (DynamicObject obj : idCollection) {
            batchIds.add(obj.getLong("id"));
        }
    }

    private void cacheBatchIds(SalaryRptQueryInfo queryInfo, Map<Integer, List<Long>> batchIdMap) {
        String pageId = queryInfo.getPageId();
        if (StringUtils.isEmpty((Object)pageId)) {
            throw new KDBizException("SalaryDetailQueryRpt cacheBatchIds : pageId can not null when cache idDataSet.");
        }
        if (CollectionUtils.isEmpty(batchIdMap)) {
            return;
        }
        for (Map.Entry<Integer, List<Long>> batchEntry : batchIdMap.entrySet()) {
            DataSet idDataSet = this.buildBatchDataSet(batchEntry.getValue());
            if (idDataSet == null) continue;
            CacheHint cacheHint = CacheHint.getDefault();
            cacheHint.setCacheId(pageId + "_batch_" + (batchEntry.getKey() - 1));
            idDataSet.cache(cacheHint);
            logger.info("SalaryDetailQueryRpt cacheBatchIds cacheHint\uff1a" + cacheHint.getCacheId());
        }
    }

    private List<Long> rebuildBatchIds(int totalBatch) {
        ArrayList queryByIds = Lists.newArrayListWithCapacity((int)totalBatch);
        for (int i = 0; i < totalBatch; ++i) {
            queryByIds.add(0L);
        }
        return queryByIds;
    }

    private String getSelectFields(SalaryRptQueryInfo queryInfo) {
        String batchBySelectFields = queryInfo.getCustomPara("batchBySelectFields", String.class);
        if (batchBySelectFields == null) {
            HashSet selectFields = Sets.newHashSet((Object[])new String[]{"id", "empnumber", "hsas_employee.id"});
            Map<String, String> orderByFieldMap = queryInfo.getOrderByFieldMap();
            if (orderByFieldMap != null) {
                orderByFieldMap.entrySet().forEach(obj -> selectFields.add(obj.getKey()));
            }
            batchBySelectFields = String.join((CharSequence)",", selectFields);
            queryInfo.addCustomPara("batchBySelectFields", batchBySelectFields);
        }
        return batchBySelectFields;
    }

    private DataSet buildBatchDataSet(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        logger.info("SalaryDetailQueryRpt buildBatchDataSet ids\uff1a" + ids.size());
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        for (Long id : ids) {
            dataSetBuilder.append(new Object[]{id});
        }
        return dataSetBuilder.build();
    }

    @Override
    protected SalaryRptParamHandler getRptQueryParamHandler() {
        return new SalaryDetailRptParamHandler();
    }
}

