/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.web;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportBatchLoadInfo;
import kd.bos.entity.report.ReportByBatchTaskResult;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.exception.KDBizException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.sdk.swc.hcdm.common.Pair;
import kd.swc.hsas.business.salaryrpt.entity.SchemeAdvanceInfo;
import kd.swc.hsas.common.enums.SalaryRptItemTypeEnum;
import kd.swc.hsas.report.api.RowDataMatcherSupplier;
import kd.swc.hsas.report.api.SalaryRptParamHandler;
import kd.swc.hsas.report.entity.SalaryDiffGroup;
import kd.swc.hsas.report.entity.SalaryDiffGroupMatcher;
import kd.swc.hsas.report.entity.SalaryDiffGroupPreOrderMatcher;
import kd.swc.hsas.report.entity.SalaryRptColumnInfo;
import kd.swc.hsas.report.entity.SalaryRptQueryInfo;
import kd.swc.hsas.report.helper.CalPersonQueryHelper;
import kd.swc.hsas.report.impl.SalaryDiffRptParamHandler;
import kd.swc.hsas.report.web.SalaryRptBaseAbstractPlugin;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.MapUtils;

public class SalaryDiffQueryRpt
extends SalaryRptBaseAbstractPlugin {
    private static final Log LOGGER = LogFactory.getLog(SalaryDiffQueryRpt.class);

    @Override
    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        this.removeCache(queryParam);
        return super.queryBatchBy(queryParam);
    }

    @Override
    protected DataSet queryBatchBy(ReportQueryParam queryParam, SalaryRptQueryInfo queryInfo) {
        if (queryParam == null || this.currentTraceStop(queryInfo)) {
            return this.emptyDataSet();
        }
        SalaryDiffGroupMatcher groupBatchMatcher = this.newSalaryDiffGroupMatcher(queryParam, queryInfo);
        String orderByStr = groupBatchMatcher.addByBatchOrderBy(queryInfo.getOrderByFieldMap(), queryInfo.getRelateFields());
        String selectFields = groupBatchMatcher.addByBatchField(queryInfo.getGroupByFields());
        List<QFilter> filters = groupBatchMatcher.addByBatchFilter(queryInfo.getFilters());
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryInfo.getQueryEntityCode());
        Map<String, SalaryDiffGroup> diffGroupMap = groupBatchMatcher.newGroupBatchMap();
        LOGGER.info("Trace by Quinn SalaryDiffQueryRpt.queryBatchBy select {} by {} ", (Object)selectFields, (Object)orderByStr);
        List pks = HRQueryEntityHelper.getInstance().queryAllPkByKSql(queryEntityType, filters.toArray(new QFilter[0]), null);
        if (!CollectionUtils.isEmpty((Collection)pks)) {
            List listList = Lists.partition((List)pks, (int)2000);
            LOGGER.info("Trace by Quinn: SalaryDiffQueryRpt.queryBatchBy detail size is {}", (Object)pks.size());
            for (List pkList : listList) {
                if (this.currentTraceStop(queryInfo)) {
                    return this.emptyDataSet();
                }
                QFilter qFilter = new QFilter("id", "in", (Object)pkList);
                DataSet dimSet = HRQueryEntityHelper.getInstance().getQueryDataSet(queryEntityType, selectFields, new QFilter[]{qFilter}, null);
                Throwable throwable = null;
                try {
                    if (dimSet == null) continue;
                    queryInfo.setRowMeta(groupBatchMatcher.newDimRowMeta(dimSet.getRowMeta()));
                    while (dimSet.hasNext()) {
                        Row row = dimSet.next();
                        Pair<String, SalaryDiffGroup> group = groupBatchMatcher.addRow(diffGroupMap, row, false);
                        if (group == null) continue;
                        this.cacheSalaryDiffGroup(diffGroupMap, queryInfo, false);
                        diffGroupMap = groupBatchMatcher.newGroupBatchMap();
                        diffGroupMap.put((String)group.getKey(), (SalaryDiffGroup)group.getValue());
                        if (!groupBatchMatcher.isBatchByAsync()) continue;
                        Map<String, SalaryDiffGroup> diffGroupMapFinal = diffGroupMap;
                        ThreadPools.executeOnce((String)"kd.swc.hsas.report.web.SalaryDiffQueryRpt", () -> this.resolveBatchBy(dimSet, diffGroupMapFinal, groupBatchMatcher, queryInfo));
                        DataSet dataSet = this.buildBatchByDataSet(queryParam, queryInfo, false);
                        return dataSet;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dimSet == null) continue;
                    if (throwable != null) {
                        try {
                            dimSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dimSet.close();
                    continue;
                }
                LOGGER.info("Trace by Quinn: SalaryDiffQueryRpt.queryBatchBy current group size is {}", (Object)diffGroupMap.size());
                if (diffGroupMap.size() <= 50000) continue;
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u7ef4\u5ea6\u6570\u636e\u8fc7\u5927\uff0c\u8bf7\u51cf\u5c11\u67e5\u8be2\u7ef4\u5ea6\u6216\u67e5\u8be2\u6570\u636e\u8303\u56f4\u540e\u91cd\u65b0\u67e5\u8be2\u3002", (String)"SalaryDiffQueryRpt_5", (String)"swc-hsas-report", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            int changeFlagFinal = groupBatchMatcher.getChangeFlag();
            diffGroupMap.entrySet().removeIf(ele -> (((SalaryDiffGroup)ele.getValue()).changeFlagCode() & changeFlagFinal) == 0);
            ArrayList list = Lists.newArrayList(diffGroupMap.entrySet());
            list.sort(groupBatchMatcher.comparator());
            if (groupBatchMatcher.isBatchByAsync()) {
                this.cacheSalaryDiffGroupBatch(list, queryInfo, true);
            } else {
                for (int index = 0; index < list.size(); ++index) {
                    ((SalaryDiffGroup)((Map.Entry)list.get(index)).getValue()).setSeq(index + 1);
                }
                if (diffGroupMap.size() <= queryInfo.getBatchSize()) {
                    this.cacheSalaryDiffGroupBatch(list, queryInfo, true);
                } else {
                    List partition = Lists.partition((List)list, (int)queryInfo.getBatchSize());
                    for (int index = 0; index < partition.size(); ++index) {
                        this.cacheSalaryDiffGroupBatch((List)partition.get(index), queryInfo, index == partition.size() - 1);
                    }
                }
            }
        }
        LOGGER.info("Trace by Quinn group size is {}, total batch is {} ", (Object)diffGroupMap.size(), (Object)queryInfo.getTotalBatch());
        return this.buildBatchByDataSet(queryParam, queryInfo, true);
    }

    private boolean currentTraceStop(SalaryRptQueryInfo queryInfo) {
        if (queryInfo == null) {
            return true;
        }
        String pageId = queryInfo.getPageId();
        SWCPageCache pageCache = new SWCPageCache(pageId);
        String queryTraceId = (String)pageCache.get("currentQueryTraceId", String.class);
        return !StringUtil.equals((String)queryTraceId, (String)queryInfo.getQueryTraceId());
    }

    @Override
    protected DataSet query(ReportQueryParam reportQueryParam, Object obj, SalaryRptQueryInfo queryInfo) {
        Map<Object, Object> groupOfBatch;
        LOGGER.info("Trace By Quinn: query start in");
        if (reportQueryParam == null || this.currentTraceStop(queryInfo)) {
            return this.emptyDataSet();
        }
        int currentBatchIndex = reportQueryParam.byBatchInfo().getCurrentBatchIndex();
        int complete = this.waitBatchComplete(currentBatchIndex, queryInfo);
        LOGGER.info("Trace By Quinn: query start index {}", (Object)currentBatchIndex);
        if (complete == -1) {
            String message = ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u8d85\u65f6\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"SalaryDetailFormRpt_5", (String)"swc-hsas-formplugin", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (complete == -2) {
            groupOfBatch = Maps.newHashMap();
        } else {
            if (complete > 0) {
                queryInfo = this.queryInfo;
            }
            groupOfBatch = this.fetchSalaryDiffGroup(queryInfo, currentBatchIndex);
        }
        if (this.currentTraceStop(queryInfo)) {
            return this.emptyDataSet();
        }
        DataSet result = this.buildQueryBasicDataSet(groupOfBatch, queryInfo);
        boolean emptyGroup = CollectionUtils.isEmpty((Map)groupOfBatch);
        LOGGER.info("Trace By Quinn: after buildQueryBasicDataSet, groupOfBatch empty: {}", (Object)emptyGroup);
        if (!emptyGroup) {
            result = this.mergeDetailSet(result, queryInfo, groupOfBatch, true);
            result = this.mergeDetailSet(result, queryInfo, groupOfBatch, false);
        }
        result = this.cacheTotalData(result, queryInfo, currentBatchIndex, groupOfBatch);
        result = this.addChangeFlagField(result, queryInfo);
        return result;
    }

    @Override
    protected SalaryRptParamHandler getRptQueryParamHandler() {
        return new SalaryDiffRptParamHandler();
    }

    @Override
    protected boolean needCellStyleRule(SalaryRptColumnInfo columnInfo) {
        if (columnInfo == null || !columnInfo.isItem() || columnInfo.isHide()) {
            return false;
        }
        String fieldCode = columnInfo.getFieldCode();
        return !fieldCode.endsWith("_tar") && !fieldCode.endsWith("_src") && !fieldCode.endsWith("_diffRate");
    }

    private SalaryDiffGroupMatcher newSalaryDiffGroupMatcher(ReportQueryParam queryParam, SalaryRptQueryInfo queryInfo) {
        SalaryDiffGroupMatcher groupBatch;
        boolean noNeedRepOrder;
        Boolean batchByPreOrder = queryInfo.getCustomPara("batchByPreOrder", Boolean.class);
        List<String> groupFields = queryInfo.getGroupByFields();
        Map<String, String> orderByFieldMap = queryInfo.getOrderByFieldMap();
        boolean bl = noNeedRepOrder = orderByFieldMap == null || groupFields.containsAll(orderByFieldMap.keySet());
        if (noNeedRepOrder && batchByPreOrder != null && batchByPreOrder.booleanValue()) {
            groupBatch = new SalaryDiffGroupPreOrderMatcher(queryInfo.getQueryByBatchSize());
            Boolean batchAsync = queryInfo.getCustomPara("batchAsync", Boolean.class);
            if (batchAsync != null && batchAsync.booleanValue()) {
                ((SalaryDiffGroupPreOrderMatcher)groupBatch).setBatchByAsync(true);
            }
        } else {
            groupBatch = new SalaryDiffGroupMatcher(queryInfo.getQueryByBatchSize());
        }
        groupBatch.setDetailBatchSize(queryInfo.getBatchSize());
        groupBatch.setGroupBatchSize(queryInfo.getQueryByBatchSize());
        groupBatch.setDimFields(queryInfo.getGroupByFields().toArray(new String[0]));
        FilterInfo filterInfo = queryParam.getFilter();
        String periodWay = filterInfo.getString("period");
        RowDataMatcherSupplier supplier = RowDataMatcherSupplier.byPeriodWay(periodWay);
        groupBatch.setTarDataMatcher(supplier.tarMatcher(filterInfo));
        groupBatch.setSrcDataMatcher(supplier.srcMatcher(filterInfo));
        queryInfo.addCustomPara("currency", filterInfo.getDynamicObject("calcurrency").get("id"));
        SchemeAdvanceInfo schemeAdvanceInfo = queryInfo.getCustomPara("schemeAdvanceInfo", SchemeAdvanceInfo.class);
        int changeFlag = 0;
        if (schemeAdvanceInfo == null) {
            changeFlag = 7;
        } else {
            if (schemeAdvanceInfo.isShowUnChng()) {
                changeFlag = 1;
            }
            if (schemeAdvanceInfo.isShowAdd()) {
                changeFlag |= 2;
            }
            if (schemeAdvanceInfo.isShowDel()) {
                changeFlag |= 4;
            }
        }
        groupBatch.setChangeFlag(changeFlag);
        return groupBatch;
    }

    private void resolveBatchBy(DataSet dataSet, Map<String, SalaryDiffGroup> diffGroupMap, SalaryDiffGroupMatcher matcher, SalaryRptQueryInfo queryInfo) {
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Pair<String, SalaryDiffGroup> group = matcher.addRow(diffGroupMap, row, false);
            if (group == null) continue;
            this.cacheSalaryDiffGroup(diffGroupMap, queryInfo, false);
            diffGroupMap = Maps.newLinkedHashMapWithExpectedSize((int)matcher.getGroupBatchSize());
            diffGroupMap.put(group.getKey(), group.getValue());
        }
        this.cacheSalaryDiffGroup(diffGroupMap, queryInfo, true);
        String pageId = queryInfo.getPageId();
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        ReportTaskResult reportTaskResult = reportCache.getReportTaskResult(pageId, "reportlistap");
        if (!(reportTaskResult instanceof ReportByBatchTaskResult)) {
            return;
        }
        ReportBatchLoadInfo batchLoadInfo = ((ReportByBatchTaskResult)reportTaskResult).getBatchLoadInfo();
        batchLoadInfo.setBatchCount(queryInfo.getTotalBatch());
        reportCache.setReportTaskResult(pageId, "reportlistap", reportTaskResult);
    }

    private DataSet mergeDetailSet(DataSet result, SalaryRptQueryInfo queryInfo, Map<String, SalaryDiffGroup> groupOfBatch, boolean isTar) {
        JoinDataSet joinDataSet;
        HashSet rightFields;
        LOGGER.info("Trace By Quinn: mergeDetailSet, {}", (Object)isTar);
        DataSet dataSet = null;
        HashMap pkListOfTask = Maps.newHashMapWithExpectedSize((int)24);
        List<String> groupByFields = queryInfo.getGroupByFields();
        int batchSize = 2000;
        for (Map.Entry<String, SalaryDiffGroup> entry : groupOfBatch.entrySet()) {
            int groupSize;
            SalaryDiffGroup group = entry.getValue();
            Map<Long, List<Long>> dataIdsOfTask = isTar ? group.getTarIdsOfTask() : group.getSrcIdsOfTask();
            int n = groupSize = isTar ? group.getTarSize() : group.getSrcSize();
            if (groupSize > batchSize) {
                LOGGER.info("Trace By Quinn: mergeDetailSet large batch, {}", (Object)isTar);
                if (!pkListOfTask.isEmpty()) {
                    dataSet = this.mergeData(dataSet, pkListOfTask, groupByFields, batchSize, isTar);
                    pkListOfTask.clear();
                }
                dataSet = this.mergeData(dataSet, dataIdsOfTask, groupByFields, batchSize, isTar);
                continue;
            }
            for (Map.Entry<Long, List<Long>> pkEntry : dataIdsOfTask.entrySet()) {
                List list = pkListOfTask.computeIfAbsent(pkEntry.getKey(), ky -> Lists.newLinkedList());
                list.addAll((Collection)pkEntry.getValue());
            }
            if (!this.needBatchDeal(pkListOfTask, batchSize)) continue;
            LOGGER.info("Trace By Quinn: mergeDetailSet middle batch, {}", (Object)isTar);
            dataSet = this.mergeData(dataSet, pkListOfTask, groupByFields, batchSize, isTar);
            pkListOfTask.clear();
        }
        if (!pkListOfTask.isEmpty() || dataSet == null) {
            LOGGER.info("Trace By Quinn: mergeDetailSet tail batch, {}", (Object)isTar);
            dataSet = this.mergeData(dataSet, pkListOfTask, groupByFields, batchSize, isTar);
            pkListOfTask.clear();
        }
        if (dataSet != null) {
            rightFields = Sets.newHashSet((Object[])dataSet.getRowMeta().getFieldNames());
            rightFields.removeAll(groupByFields);
            joinDataSet = result.leftJoin(dataSet);
            for (String groupByField : groupByFields) {
                joinDataSet = joinDataSet.on(groupByField, groupByField);
            }
        } else {
            return result;
        }
        joinDataSet = joinDataSet.select(result.getRowMeta().getFieldNames(), rightFields.toArray(new String[0]));
        dataSet = joinDataSet.finish();
        return dataSet;
    }

    private boolean needBatchDeal(Map<Long, List<Long>> dataIdsOfTask, int batchSize) {
        for (Map.Entry<Long, List<Long>> entry : dataIdsOfTask.entrySet()) {
            if (entry.getValue().size() < batchSize) continue;
            return true;
        }
        return false;
    }

    private DataSet mergeData(DataSet dataSet, Map<Long, List<Long>> dataIdsOfTask, List<String> groupByFields, int batchSize, boolean isTar) {
        LOGGER.info("Trace By Quinn: mergeData, {}", (Object)isTar);
        DataSet dataSetTmp = this.mergeData(this.queryInfo, Collections.singletonList(Long.MIN_VALUE), Collections.singleton(Long.MIN_VALUE), isTar);
        for (Map.Entry<Long, List<Long>> pkEntry : dataIdsOfTask.entrySet()) {
            List<Long> dataIds = pkEntry.getValue();
            Set<Long> taskSetTmp = Collections.singleton(pkEntry.getKey());
            List partition = Lists.partition(dataIds, (int)batchSize);
            for (int index = 0; index < partition.size(); ++index) {
                try (DataSet dataSetX = this.mergeData(this.queryInfo, (List)partition.get(index), taskSetTmp, isTar);){
                    dataSetTmp = dataSetTmp.union(dataSetX);
                }
                if (index % 100 != 99) continue;
                dataSetTmp = this.bizDataSet(groupByFields, dataSetTmp);
            }
        }
        dataSetTmp = this.bizDataSet(groupByFields, dataSetTmp);
        dataSet = dataSet == null ? dataSetTmp : dataSet.union(dataSetTmp);
        return dataSet;
    }

    private DataSet bizDataSet(List<String> groupByFields, DataSet dataSetTmp) {
        GroupbyDataSet groupbyDataSet = dataSetTmp.groupBy(groupByFields.toArray(new String[0]));
        StringBuilder query = new StringBuilder();
        for (String field : groupByFields) {
            query.append(field).append(';');
        }
        ArrayList sumFields = Lists.newArrayList((Object[])dataSetTmp.getRowMeta().getFieldNames());
        sumFields.removeAll(groupByFields);
        query.append('\n');
        for (String sumFieldCode : sumFields) {
            query.append(sumFieldCode).append(';');
            groupbyDataSet = groupbyDataSet.sum(sumFieldCode, sumFieldCode);
        }
        LOGGER.info("Trace By Quinn: bizDataSet\n{}", (Object)query.toString());
        dataSetTmp = groupbyDataSet.finish();
        return dataSetTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet mergeData(SalaryRptQueryInfo queryInfo, List<Long> pkList, Collection<Long> taskSet, boolean isTar) {
        LOGGER.info("Trace By Quinn: mergeData-queryInfo, {}", (Object)isTar);
        List<String> groupByFields = queryInfo.getGroupByFields();
        ArrayList queryFields = Lists.newArrayListWithExpectedSize((int)(groupByFields.size() + 1));
        queryFields.addAll(groupByFields);
        queryFields.add("id");
        Map<String, List<Long>> itemTypeToIdMap = queryInfo.getItemTypeToIdMap();
        Throwable throwable = null;
        try (DataSet detailDataSet = new CalPersonQueryHelper().buildDetailDataSet(queryInfo.getQueryEntityCode(), pkList, taskSet, (List<String>)queryFields, itemTypeToIdMap, queryInfo.getDataTypeMap(), queryInfo.getStatisticsTagRelMap());){
            DataSet dataSet;
            ArrayList sumFields = Lists.newArrayListWithCapacity((int)queryInfo.getSumFieldCodes().size());
            DataSet dealDataSet = detailDataSet;
            try {
                dealDataSet = this.adaptDataSetToTarSrc(isTar, itemTypeToIdMap, sumFields, dealDataSet);
                GroupbyDataSet groupbyDataSet = dealDataSet.groupBy(queryInfo.getGroupByFields().toArray(new String[0]));
                for (String fieldCode : sumFields) {
                    groupbyDataSet = groupbyDataSet.sum("case when " + fieldCode + " is null then 0 else " + fieldCode + " end ", fieldCode);
                }
                dataSet = groupbyDataSet.finish();
            }
            catch (Throwable throwable2) {
                try {
                    dealDataSet.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            dealDataSet.close();
            return dataSet;
        }
    }

    private DataSet adaptDataSetToTarSrc(boolean isTar, Map<String, List<Long>> itemTypeToIdMap, List<String> sumFields, DataSet dealDataSet) {
        Field[] fields = dealDataSet.getRowMeta().getFields();
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)fields.length);
        for (Map.Entry<String, List<Long>> entry : itemTypeToIdMap.entrySet()) {
            SalaryRptItemTypeEnum itemEnum = SalaryRptItemTypeEnum.getEnumByCode((String)entry.getKey());
            for (Long itemId : entry.getValue()) {
                Iterator<String> field = itemEnum.getCode() + "_" + itemId;
                String realField = isTar ? field + "_tar" : field + "_src";
                fieldMap.put(field, realField);
                sumFields.add(realField);
            }
        }
        ArrayList groupFiles = Lists.newArrayListWithExpectedSize((int)fields.length);
        LinkedHashMap sumFiles = Maps.newLinkedHashMapWithExpectedSize((int)fields.length);
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            String realField = (String)fieldMap.get(field.getName());
            if (realField != null) {
                sumFiles.put(realField, field);
                continue;
            }
            groupFiles.add(field);
        }
        String[] newFields = new String[fields.length];
        DataType[] dataTypes = new DataType[fields.length];
        int index = 0;
        for (Field groupFile : groupFiles) {
            newFields[index] = groupFile.getName();
            dataTypes[index++] = groupFile.getDataType();
        }
        for (String sumField : sumFields) {
            Field field = (Field)sumFiles.get(sumField);
            if (field == null) continue;
            newFields[index] = sumField;
            dataTypes[index++] = field.getDataType();
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])newFields, (DataType[])dataTypes);
        LinkedList data = Lists.newLinkedList();
        while (dealDataSet.hasNext()) {
            Row row = dealDataSet.next();
            Object[] item = new Object[fields.length];
            data.add(item);
            for (int ind = 0; ind < newFields.length; ++ind) {
                Field field = (Field)sumFiles.get(newFields[ind]);
                item[ind] = field == null ? row.get(newFields[ind]) : row.get(field.getName());
            }
        }
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "1")).createDataSet((Collection)data, rowMeta);
    }

    public DataSet addChangeFlagField(DataSet dataSet, SalaryRptQueryInfo queryInfo) {
        String add = ResManager.loadKDString((String)"\u65b0\u589e", (String)"SalaryDiffQueryRpt_2", (String)"swc-hsas-report", (Object[])new Object[0]);
        String del = ResManager.loadKDString((String)"\u51cf\u5c11", (String)"SalaryDiffQueryRpt_3", (String)"swc-hsas-report", (Object[])new Object[0]);
        dataSet = dataSet.addField("case when changeFlagCode = 4 then '" + del + "' when changeFlagCode = 2 then '" + add + "' else ' ' end", "changeflag");
        SchemeAdvanceInfo schemeAdvanceInfo = queryInfo.getCustomPara("schemeAdvanceInfo", SchemeAdvanceInfo.class);
        if (!schemeAdvanceInfo.isChngRecShowDiv()) {
            dataSet = dataSet.updateField("changeFlagCode", "1");
        }
        return dataSet;
    }

    protected void removeCache(ReportQueryParam queryParam) {
        Map param = queryParam.getCustomParam();
        String pageId = MapUtils.getString((Map)param, (Object)"pageid");
        SWCPageCache pageCache = new SWCPageCache(pageId);
        pageCache.remove("report_isLoadAll");
        String queryInfoStr = (String)pageCache.get("queryInfo", String.class);
        if (SWCStringUtils.isEmpty((String)queryInfoStr)) {
            return;
        }
        SalaryRptQueryInfo queryInfo = (SalaryRptQueryInfo)SerializationUtils.deSerializeFromBase64((String)queryInfoStr);
        int totalBatch = queryInfo.getTotalBatch();
        String cacheId = pageId + "_batch_";
        for (int index = 0; index < totalBatch; ++index) {
            Algo.removeCacheDataSet((String)(cacheId + index));
            pageCache.remove("dimMap_" + index);
        }
        pageCache.remove("queryInfo");
        pageCache.remove("allTotalData");
        pageCache.remove("allItemFields");
        pageCache.saveChanges();
    }

    private void cacheSalaryDiffGroup(Map<String, SalaryDiffGroup> salaryDiffGroup, SalaryRptQueryInfo queryInfo, boolean complete) {
        String pageId = queryInfo.getPageId();
        SWCPageCache pageCache = new SWCPageCache(pageId);
        queryInfo.setBatchByComplete(complete);
        if (salaryDiffGroup == null) {
            salaryDiffGroup = Maps.newHashMap();
        }
        int currentIndex = queryInfo.getTotalBatch();
        queryInfo.setTotalBatch(currentIndex + 1);
        for (Map.Entry entry : salaryDiffGroup.entrySet()) {
            ((SalaryDiffGroup)entry.getValue()).bizInfo();
        }
        pageCache.put("dimMap_" + currentIndex, (Object)SerializationUtils.serializeToBase64((Object)salaryDiffGroup));
        pageCache.put("queryInfo", (Object)SerializationUtils.serializeToBase64((Object)queryInfo));
        pageCache.saveChanges();
    }

    private void cacheSalaryDiffGroupBatch(List<Map.Entry<String, SalaryDiffGroup>> list, SalaryRptQueryInfo queryInfo, boolean complete) {
        LinkedHashMap diffGroupMapTemp = Maps.newLinkedHashMapWithExpectedSize((int)list.size());
        for (Map.Entry<String, SalaryDiffGroup> entry : list) {
            diffGroupMapTemp.put(entry.getKey(), entry.getValue());
        }
        this.cacheSalaryDiffGroup(diffGroupMapTemp, queryInfo, complete);
    }

    private Map<String, SalaryDiffGroup> fetchSalaryDiffGroup(SalaryRptQueryInfo queryInfo, int currentBatchIndex) {
        String pageId = queryInfo.getPageId();
        SWCPageCache pageCache = new SWCPageCache(pageId);
        String dimMapStr = (String)pageCache.get("dimMap_" + currentBatchIndex, String.class);
        if (dimMapStr == null) {
            return new HashMap<String, SalaryDiffGroup>(0);
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)dimMapStr);
    }

    public DataSet cacheTotalData(DataSet dataSet, SalaryRptQueryInfo queryInfo, int currentBatchIndex, Map<String, SalaryDiffGroup> groupOfBatch) {
        String pageId = queryInfo.getPageId();
        SWCPageCache pageCache = new SWCPageCache(pageId);
        ArrayList itemFields = Lists.newArrayListWithExpectedSize((int)60);
        Map<String, BigDecimal> allTotalData = this.fetchAllTotalData(queryInfo, itemFields, pageCache, currentBatchIndex);
        if (CollectionUtils.isEmpty(allTotalData)) {
            return dataSet;
        }
        ArrayList<Object[]> valuesNew = new ArrayList<Object[]>(queryInfo.getBatchSize());
        RowMeta metaNew = this.genNewRowMeta(dataSet, itemFields, allTotalData, valuesNew);
        if (queryInfo.isShowTotal() && queryInfo.isBatchByComplete() && currentBatchIndex == queryInfo.getTotalBatch() - 1 && !allTotalData.isEmpty() && (queryInfo.getTotalBatch() > 1 || !CollectionUtils.isEmpty(groupOfBatch))) {
            String[] fieldNames = metaNew.getFieldNames();
            Object[] item = new Object[fieldNames.length];
            valuesNew.add(item);
            for (int index = 0; index < fieldNames.length; ++index) {
                BigDecimal value = allTotalData.get(fieldNames[index]);
                item[index] = value;
            }
            for (String field : itemFields) {
                String srcFiled = field + "_src";
                String rateFiled = field + "_diffRate";
                BigDecimal difValue = allTotalData.get(field);
                BigDecimal srcValue = allTotalData.get(srcFiled);
                item[metaNew.getFieldIndex((String)rateFiled)] = BigDecimal.ZERO.compareTo(srcValue) == 0 ? "-" : difValue.multiply(new BigDecimal(100)).divide(srcValue, 2, RoundingMode.HALF_UP) + "%";
            }
            String changeFlagCodeDesc = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"SalaryDiffQueryRpt_4", (String)"swc-hsas-report", (Object[])new Object[0]);
            item[metaNew.getFieldIndex((String)"seq")] = changeFlagCodeDesc;
            item[metaNew.getFieldIndex((String)"rowtype")] = "3";
            item[metaNew.getFieldIndex((String)"hsas_calpayrolltask.payrollgroupv.currency")] = queryInfo.getCustomPara("currency", Long.class);
        }
        pageCache.put("allTotalData", (Object)SerializationUtils.serializeToBase64(allTotalData));
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "2")).createDataSet(valuesNew, metaNew);
    }

    private RowMeta genNewRowMeta(DataSet dataSet, List<String> itemFields, Map<String, BigDecimal> allTotalData, List<Object[]> valuesNew) {
        RowMeta oldMeta = dataSet.getRowMeta();
        Field[] fields = oldMeta.getFields();
        int newSize = fields.length + itemFields.size() * 2 + 1;
        ArrayList<String> columns = new ArrayList<String>(newSize);
        ArrayList<Object> types = new ArrayList<Object>(newSize);
        for (Field field : fields) {
            columns.add(field.getName());
            types.add(field.getDataType());
        }
        columns.add("rowtype");
        types.add(DataType.StringType);
        BigDecimal base = new BigDecimal(100);
        while (dataSet.hasNext()) {
            Object[] items = new Object[newSize];
            valuesNew.add(items);
            Row next = dataSet.next();
            for (int index = 0; index < fields.length; ++index) {
                items[index] = next.get(fields[index].getName());
            }
            BigDecimal personNum = next.getBigDecimal("personNum");
            allTotalData.put("personNum", allTotalData.get("personNum").add(personNum));
            int index = fields.length;
            items[index++] = "1";
            for (String field : itemFields) {
                String tarFiled = field + "_tar";
                String srcFiled = field + "_src";
                BigDecimal tarValue = next.getBigDecimal(tarFiled);
                BigDecimal srcValue = next.getBigDecimal(srcFiled);
                tarValue = tarValue == null ? BigDecimal.ZERO : tarValue;
                srcValue = srcValue == null ? BigDecimal.ZERO : srcValue;
                BigDecimal difValue = tarValue.subtract(srcValue);
                items[index++] = difValue;
                items[index++] = BigDecimal.ZERO.compareTo(srcValue) == 0 ? "-" : difValue.multiply(base).divide(srcValue, 2, RoundingMode.HALF_UP) + "%";
                allTotalData.put(tarFiled, allTotalData.get(tarFiled).add(tarValue));
                allTotalData.put(srcFiled, allTotalData.get(srcFiled).add(srcValue));
                allTotalData.put(field, allTotalData.get(field).add(difValue));
            }
        }
        for (String field : itemFields) {
            columns.add(field);
            types.add(oldMeta.getField(field + "_tar").getDataType());
            columns.add(field + "_diffRate");
            types.add(DataType.StringType);
        }
        RowMeta metaNew = RowMetaFactory.createRowMeta((String[])columns.toArray(new String[0]), (DataType[])types.toArray(new DataType[0]));
        return metaNew;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, BigDecimal> fetchAllTotalData(SalaryRptQueryInfo queryInfo, List<String> itemFields, SWCPageCache pageCache, int currentBatchIndex) {
        HashMap<String, BigDecimal> allTotalData;
        String dimMapStr = (String)pageCache.get("allTotalData", String.class);
        if (dimMapStr == null) {
            allTotalData = new HashMap<String, BigDecimal>(0);
            if (currentBatchIndex != 0) return allTotalData;
            for (Map.Entry<String, List<Long>> entry : queryInfo.getItemTypeToIdMap().entrySet()) {
                SalaryRptItemTypeEnum itemEnum = SalaryRptItemTypeEnum.getEnumByCode((String)entry.getKey());
                for (Long itemId : entry.getValue()) {
                    String field = itemEnum.getCode() + "_" + itemId;
                    itemFields.add(field);
                    String tarFiled = field + "_tar";
                    String srcFiled = field + "_src";
                    allTotalData.put(field, BigDecimal.ZERO);
                    allTotalData.put(tarFiled, BigDecimal.ZERO);
                    allTotalData.put(srcFiled, BigDecimal.ZERO);
                }
            }
            allTotalData.put("personNum", BigDecimal.ZERO);
            pageCache.put("allItemFields", (Object)SerializationUtils.serializeToBase64(itemFields));
            return allTotalData;
        } else {
            allTotalData = (HashMap<String, BigDecimal>)SerializationUtils.deSerializeFromBase64((String)dimMapStr);
            String itemFieldsStr = (String)pageCache.get("allItemFields", String.class);
            if (itemFieldsStr == null) return allTotalData;
            List itemTemp = (List)SerializationUtils.deSerializeFromBase64((String)itemFieldsStr);
            itemFields.addAll(itemTemp);
        }
        return allTotalData;
    }

    private int waitBatchComplete(int currentBatchIndex, SalaryRptQueryInfo queryInfo) {
        for (int i = 0; i < 300; ++i) {
            if (currentBatchIndex < queryInfo.getTotalBatch()) {
                return i;
            }
            if (queryInfo.isBatchByComplete()) {
                return -2;
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
            this.queryInfo = this.getCacheQueryInfo(queryInfo.getPageId());
        }
        LOGGER.info("SalaryDiffQueryRpt.waitBatchComplete fail {} of {}", (Object)currentBatchIndex, (Object)queryInfo.getTotalBatch());
        return -1;
    }

    private DataSet buildQueryBasicDataSet(Map<String, SalaryDiffGroup> diffGroupMap, SalaryRptQueryInfo queryInfo) {
        RowMeta rowMeta = queryInfo.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        List<String> relateFields = queryInfo.getRelateFields();
        int newSize = fieldNames.length + (CollectionUtils.isEmpty(relateFields) ? 0 : relateFields.size());
        diffGroupMap = diffGroupMap == null ? Maps.newHashMap() : diffGroupMap;
        HashMap indexOfMainId = Maps.newHashMapWithExpectedSize((int)diffGroupMap.size());
        ArrayList values = Lists.newArrayListWithExpectedSize((int)diffGroupMap.size());
        for (Map.Entry<Object, Object> entry : diffGroupMap.entrySet()) {
            SalaryDiffGroup group = (SalaryDiffGroup)entry.getValue();
            Object[] objectArray = group.getDimValues();
            Object[] val = Arrays.copyOf(objectArray, newSize);
            val[objectArray.length] = group.getPersonNum();
            val[objectArray.length + 1] = group.changeFlagCode();
            val[objectArray.length + 2] = group.getSeq() + "";
            Object[] relateValues = group.getRelateValues();
            if (relateValues != null && relateValues.length > 0) {
                int startIndex = objectArray.length + 3;
                for (int index = 0; index < relateValues.length; ++index) {
                    val[startIndex + index] = group.relateValue(index);
                }
            }
            if (group.getMainId() != 0L) {
                indexOfMainId.put(group.getMainId(), values.size());
            }
            values.add(val);
        }
        ArrayList<String> fields = new ArrayList<String>(newSize);
        ArrayList<Object> dataTypes = new ArrayList<Object>(newSize);
        fields.addAll(Arrays.asList(fieldNames));
        dataTypes.addAll(Arrays.asList(rowMeta.getDataTypes()));
        if (!CollectionUtils.isEmpty(relateFields)) {
            fields.addAll(relateFields);
            QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryInfo.getQueryEntityCode());
            String string = Joiner.on((char)',').join(relateFields) + ",id";
            DataSet relateSet = HRQueryEntityHelper.getInstance().getQueryDataSet(queryEntityType, string, new QFilter[]{new QFilter("id", "in", indexOfMainId.keySet())}, null);
            Object object = null;
            try {
                RowMeta meta = relateSet.getRowMeta();
                for (String field : relateFields) {
                    dataTypes.add(meta.getField(field).getDataType());
                }
                while (relateSet.hasNext()) {
                    Row row = relateSet.next();
                    Long id = row.getLong("id");
                    Object[] item = (Object[])values.get((Integer)indexOfMainId.get(id));
                    int startIndex = item.length - relateFields.size();
                    for (int index = 0; index < relateFields.size(); ++index) {
                        item[startIndex + index] = row.get(relateFields.get(index));
                    }
                }
            }
            catch (Throwable meta) {
                object = meta;
                throw meta;
            }
            finally {
                if (relateSet != null) {
                    if (object != null) {
                        try {
                            relateSet.close();
                        }
                        catch (Throwable meta) {
                            ((Throwable)object).addSuppressed(meta);
                        }
                    } else {
                        relateSet.close();
                    }
                }
            }
        }
        if (CollectionUtils.isEmpty(diffGroupMap)) {
            for (Map.Entry entry : queryInfo.getItemTypeToIdMap().entrySet()) {
                SalaryRptItemTypeEnum itemEnum = SalaryRptItemTypeEnum.getEnumByCode((String)((String)entry.getKey()));
                for (Long itemId : (List)entry.getValue()) {
                    String field = itemEnum.getCode() + "_" + itemId;
                    fields.add(field + "_tar");
                    dataTypes.add(DataType.BigDecimalType);
                    fields.add(field + "_src");
                    dataTypes.add(DataType.BigDecimalType);
                }
            }
        }
        RowMeta meta = RowMetaFactory.createRowMeta((String[])fields.toArray(new String[0]), (DataType[])dataTypes.toArray(new DataType[0]));
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "3")).createDataSet((Collection)values, meta);
    }

    private DataSet buildBatchByDataSet(ReportQueryParam queryParam, SalaryRptQueryInfo queryInfo, boolean complete) {
        IReportBatchQueryInfo byBatchInfo = queryParam.byBatchInfo();
        byBatchInfo.setCountPerBatch(1);
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"id"}, (DataType[])new DataType[]{DataType.IntegerType});
        queryInfo.setBatchByComplete(complete);
        int batchNum = complete ? queryInfo.getTotalBatch() : 10000;
        ArrayList values = Lists.newArrayListWithExpectedSize((int)batchNum);
        for (int i = 0; i < batchNum; ++i) {
            values.add(new Object[]{0});
        }
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "4")).createDataSet((Collection)values, rowMeta);
    }

    private DataSet emptyDataSet() {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"id"}, (DataType[])new DataType[]{DataType.IntegerType});
        ArrayList values = Lists.newArrayListWithExpectedSize((int)0);
        return Algo.create((String)(((Object)((Object)this)).getClass().getName() + "5")).createDataSet((Collection)values, rowMeta);
    }
}

