/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.report.api.SalaryRptParamHandler;
import kd.swc.hsas.report.entity.SalaryRptQueryInfo;
import kd.swc.hsas.report.helper.CalPersonQueryHelper;
import kd.swc.hsas.report.impl.SalaryDptMonthSumRptParamHandler;
import kd.swc.hsas.report.web.SalaryAsyncSumAbstractPlugin;
import kd.swc.hsbp.business.report.AdminOrgHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.ListUtils;
import org.jetbrains.annotations.NotNull;

public class SalaryDptMonthSumQueryRpt
extends SalaryAsyncSumAbstractPlugin {
    private boolean isIncludeLower;
    private Long adminOrgId;
    private String adminOrgLongNumber;
    private Integer adminOrgLevel;
    private List<Map<String, Object>> adminOrgList;
    private Map<Long, String> adminOrgLongNumberMap;
    private int lastLevel;
    private static final String KEY_ISSHOWLOWER = "isshowlower";
    private static final String FIELD_ORGLONGNUMBER = "structlongnumber";
    private static final String FIELD_BELONGPERIODSTR = "periodstr";
    private static final String FIELD_ADMINORGNUMBER = "adminorg.number";
    private static final String FIELD_ADMINORGID = "adminorg.id";
    private static final String FIELD_ADMINORGLEVEL = "level";

    @Override
    protected void beforeQuery(ReportQueryParam reportQueryParam, Object selectObj, SalaryRptQueryInfo queryInfo) {
        super.beforeQuery(reportQueryParam, selectObj, queryInfo);
        this.isIncludeLower = reportQueryParam.getFilter().getBoolean(KEY_ISSHOWLOWER);
        this.lastLevel = reportQueryParam.getFilter().getInt("lastlevel");
        this.adminOrgId = queryInfo.getCustomPara("adminOrgId", Long.class);
        this.adminOrgLongNumber = queryInfo.getCustomPara("adminOrgLongNumber", String.class);
        this.adminOrgLevel = queryInfo.getCustomPara("adminOrgLevel", Integer.class);
        this.timeLog.logStart("SalaryDptMonthSumQueryRpt beforeQuery initAllOrgData");
        Set<Long> adminOrgIds = this.initAllOrgData();
        this.timeLog.logEnd("SalaryDptMonthSumQueryRpt beforeQuery initAllOrgData");
        queryInfo.getFilters().add(new QFilter(queryInfo.getCustomPara("filterFieldCode", String.class), "in", adminOrgIds));
    }

    @Override
    protected boolean buildDimDataSet(ReportQueryParam reportQueryParam) {
        List<String> groupByFields = this.queryInfo.getGroupByFields();
        List<String> mainSelectFields = this.queryInfo.getMainSelectFields();
        ArrayList<String> selectFields = new ArrayList<String>(10);
        HashMap<String, List<Long>> itemIdMap = new HashMap<String, List<Long>>(16);
        for (String groupByField : groupByFields) {
            if (mainSelectFields.contains(groupByField)) {
                selectFields.add(groupByField);
                continue;
            }
            if (FIELD_ADMINORGID.equals(groupByField) && mainSelectFields.contains("hsas_empposorgrelhr.adminorg.id")) {
                selectFields.add("hsas_empposorgrelhr.adminorg.id");
                continue;
            }
            if (FIELD_BELONGPERIODSTR.equals(groupByField) && mainSelectFields.contains("belongperiod")) {
                selectFields.add("belongPeriod");
                continue;
            }
            if (!groupByField.startsWith("item")) continue;
            String itemTypeCode = groupByField.substring(0, groupByField.indexOf(95));
            String itemId = groupByField.substring(groupByField.indexOf(95) + 1);
            if (itemIdMap.get(itemTypeCode) == null) {
                itemIdMap.put(itemTypeCode, new ArrayList(10));
            }
            ((List)itemIdMap.get(itemTypeCode)).add(Long.valueOf(itemId));
        }
        if (!selectFields.contains("id")) {
            selectFields.add("id");
        }
        List subCalPersonIds = ListUtils.partition((List)this.calPersonIds, (int)10000);
        this.dimDataSet = new HashSet(16);
        CalPersonQueryHelper queryHelper = new CalPersonQueryHelper();
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)this.queryInfo.getQueryEntityCode());
        for (List subIds : subCalPersonIds) {
            try (DataSet detailDataSet = queryHelper.buildDetailDataSet(queryEntityType, subIds, selectFields, itemIdMap, this.queryInfo.getDataTypeMap(), this.queryInfo.getStatisticsTagRelMap());){
                for (Row row : detailDataSet) {
                    this.dimDataSet.add(this.getDimStr(selectFields, row));
                }
            }
            if (this.dimDataSet.size() <= 10000) continue;
            String message = ResManager.loadKDString((String)"\u67e5\u8be2\u7ef4\u5ea6\u6570\u636e\u8fc7\u5927\uff0c\u8bf7\u51cf\u5c11\u67e5\u8be2\u7ef4\u5ea6\u6216\u67e5\u8be2\u6570\u636e\u8303\u56f4\u540e\u91cd\u65b0\u67e5\u8be2\u3002", (String)"SalaryAsyncSumAbstractPlugin_0", (String)"swc-hsas-report", (Object[])new Object[0]);
            reportQueryParam.setMessage(message);
            return false;
        }
        return true;
    }

    @NotNull
    private String getDimStr(List<String> selectFields, Row row) {
        StringBuilder dimStringBuilder = new StringBuilder();
        for (String selectField : selectFields) {
            if (FIELD_ADMINORGID.equals(selectField) || "hsas_empposorgrelhr.adminorg.id".equals(selectField)) {
                Long adminOrgId = row.getLong(selectField);
                String longNumber = this.adminOrgLongNumberMap.get(adminOrgId);
                String tmpLongNumber = AdminOrgHelper.getAdminOrgNumberByLevel((String)longNumber, (int)this.lastLevel);
                dimStringBuilder.append(tmpLongNumber);
                continue;
            }
            if ("belongPeriod".equals(selectField)) {
                Date belongPeriod = row.getDate(selectField);
                String belongPeriodStr = "";
                if (belongPeriod != null) {
                    belongPeriodStr = SWCDateTimeUtils.format((Date)belongPeriod, (String)"yyyy-MM");
                }
                dimStringBuilder.append(belongPeriodStr);
                continue;
            }
            dimStringBuilder.append(row.getString(selectField));
        }
        return dimStringBuilder.toString();
    }

    @Override
    protected void buildPreDataSet(DataSet detailDataSet) {
        detailDataSet = detailDataSet.addField("to_char(belongperiod, 'yyyy-MM')", FIELD_BELONGPERIODSTR);
        super.buildPreDataSet(detailDataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataSet buildResultData() {
        this.timeLog.logStart("SalaryDptMonthSumQueryRpt buildResultData");
        DataSet orgDataSet = null;
        DataSet dptMonthSumDataSet = null;
        DataSet totalDataSet = null;
        DataSet resultDataSet = null;
        try {
            DataSet dataSet;
            DataSet dptSumDataSet;
            this.timeLog.logStart("SalaryDptMonthSumQueryRpt buildAdminOrgDataSet");
            orgDataSet = this.buildAdminOrgDataSet();
            this.timeLog.logEnd("SalaryDptMonthSumQueryRpt buildAdminOrgDataSet");
            this.timeLog.logStart("SalaryDptMonthSumQueryRpt buildDptMonthSumDataSet");
            dptMonthSumDataSet = this.buildDptMonthSumDataSet(this.preDataSet, orgDataSet);
            this.timeLog.logEnd("SalaryDptMonthSumQueryRpt buildDptMonthSumDataSet");
            if (this.isShowTotal) {
                this.timeLog.logStart("SalaryDptMonthSumQueryRpt buildTotalDataSet");
                totalDataSet = this.buildTotalDataSet(dptMonthSumDataSet.copy());
                this.timeLog.logEnd("SalaryDptMonthSumQueryRpt buildTotalDataSet");
            }
            if (this.isIncludeLower) {
                this.timeLog.logStart("SalaryDptMonthSumQueryRpt buildDptMonthUpSumDataSet");
                dptMonthSumDataSet = this.buildDptMonthUpSumDataSet(dptMonthSumDataSet);
                this.timeLog.logEnd("SalaryDptMonthSumQueryRpt buildDptMonthUpSumDataSet");
            }
            this.timeLog.logStart("SalaryDptMonthSumQueryRpt buildSortDptMonthSumDataSet");
            dptMonthSumDataSet = this.buildSortDptMonthSumDataSet(dptMonthSumDataSet);
            this.timeLog.logEnd("SalaryDptMonthSumQueryRpt buildSortDptMonthSumDataSet");
            String[] fieldNames = this.queryInfo.getRowMeta().getFieldNames();
            if ("0".equals(this.queryInfo.getSumTypeSign())) {
                this.timeLog.logStart("SalaryDptMonthSumQueryRpt buildDptSumDataSet1");
                dptSumDataSet = this.buildDptSumDataSet(dptMonthSumDataSet);
                Throwable throwable = null;
                try {
                    resultDataSet = dptSumDataSet.select(fieldNames).orderBy(new String[]{"structlongnumber asc"}).select(fieldNames);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dptSumDataSet != null) {
                        if (throwable != null) {
                            try {
                                dptSumDataSet.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            dptSumDataSet.close();
                        }
                    }
                }
                this.timeLog.logEnd("SalaryDptMonthSumQueryRpt buildDptSumDataSet1");
            } else if ("1".equals(this.queryInfo.getSumTypeSign())) {
                resultDataSet = dptMonthSumDataSet.select(fieldNames).orderBy(new String[]{"structlongnumber asc"}).select(fieldNames);
            } else {
                this.timeLog.logStart("SalaryDptMonthSumQueryRpt buildDptSumDataSet2");
                dptSumDataSet = this.buildDptSumDataSet(dptMonthSumDataSet.copy());
                Throwable throwable = null;
                try {
                    resultDataSet = dptMonthSumDataSet.select(fieldNames).union(dptSumDataSet.select(fieldNames)).orderBy(new String[]{"structlongnumber asc", "rowtype asc"}).select(fieldNames);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (dptSumDataSet != null) {
                        if (throwable != null) {
                            try {
                                dptSumDataSet.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            dptSumDataSet.close();
                        }
                    }
                }
                this.timeLog.logEnd("SalaryDptMonthSumQueryRpt buildDptSumDataSet2");
            }
            if (this.isShowTotal) {
                dataSet = resultDataSet.union(totalDataSet);
                return dataSet;
            }
            dataSet = resultDataSet.copy();
            return dataSet;
        }
        finally {
            if (dptMonthSumDataSet != null) {
                dptMonthSumDataSet.close();
            }
            if (totalDataSet != null) {
                totalDataSet.close();
            }
            if (resultDataSet != null) {
                resultDataSet.close();
            }
            if (orgDataSet != null) {
                orgDataSet.close();
            }
            this.timeLog.logEnd("SalaryDptMonthSumQueryRpt buildResultData");
        }
    }

    private Set<Long> initAllOrgData() {
        this.timeLog.logStart("SalaryDptMonthSumQueryRpt getAllSubOrg");
        List<Map<String, Object>> tmpAdminOrgList = this.getAllSubOrg();
        this.timeLog.logEnd("SalaryDptMonthSumQueryRpt getAllSubOrg");
        this.adminOrgList = new ArrayList<Map<String, Object>>(10);
        this.adminOrgLongNumberMap = new HashMap<Long, String>(16);
        HashSet<Long> adminOrgIds = new HashSet<Long>(this.adminOrgList.size());
        this.timeLog.logStart("SalaryDptMonthSumQueryRpt getAdminOrgSetByPermItem");
        Set adminOrgPermIds = SWCPermissionServiceHelper.getAdminOrgSetByPermItem((String)"/UHMBBGZQ65X", (String)"hsas_monthdeptsalsumrptquery", (String)"47150e89000000ac", (String)"adminorg");
        this.timeLog.logEnd("SalaryDptMonthSumQueryRpt getAdminOrgSetByPermItem");
        this.timeLog.logStart("SalaryDptMonthSumQueryRpt buildOrgSet");
        for (Map<String, Object> stringObjectMap : tmpAdminOrgList) {
            boolean hasNoPerm;
            Long tmpOrgId = MapUtils.getLong(stringObjectMap, (Object)"orgId");
            String tmpLongNumber = MapUtils.getString(stringObjectMap, (Object)"structLongNumber");
            int tmpLevel = AdminOrgHelper.getAdminOrgLevel((String)tmpLongNumber);
            boolean isExcluded = !this.isIncludeLower && tmpLevel > this.lastLevel;
            boolean bl = hasNoPerm = adminOrgPermIds != null && !adminOrgPermIds.contains(tmpOrgId);
            if (isExcluded || hasNoPerm) continue;
            HashMap<String, Object> tmpAdminOrgMap = new HashMap<String, Object>(16);
            tmpAdminOrgMap.put("orgId", tmpOrgId);
            tmpAdminOrgMap.put("orgName", stringObjectMap.get("orgName"));
            tmpAdminOrgMap.put("orgNumber", stringObjectMap.get("orgNumber"));
            tmpAdminOrgMap.put("orgLevel", tmpLevel);
            tmpAdminOrgMap.put("structLongNumber", tmpLongNumber);
            this.adminOrgList.add(tmpAdminOrgMap);
            this.adminOrgLongNumberMap.put(tmpOrgId, tmpLongNumber);
            adminOrgIds.add(tmpOrgId);
        }
        this.timeLog.logEnd("SalaryDptMonthSumQueryRpt buildOrgSet");
        return adminOrgIds;
    }

    private List<Map<String, Object>> getAllSubOrg() {
        return AdminOrgHelper.getAllSubAdminOrg((Long)this.adminOrgId);
    }

    /*
     * WARNING - void declaration
     */
    private DataSet buildTotalDataSet(DataSet dataSet) {
        void var4_7;
        GroupbyDataSet groupByDataSet = dataSet.groupBy(new String[]{"hsas_calpayrolltask.payrollgroupv.currency"});
        for (String string : this.queryInfo.getSumFieldCodes()) {
            groupByDataSet = groupByDataSet.sum(string, string);
        }
        DataSet totalDataSet = groupByDataSet.finish();
        for (String groupByField : this.queryInfo.getGroupByFields()) {
            if ("hsas_calpayrolltask.payrollgroupv.currency".equals(groupByField)) continue;
            totalDataSet = totalDataSet.addNullField(groupByField);
        }
        totalDataSet = totalDataSet.addNullField("personnum");
        totalDataSet = totalDataSet.addNullField(FIELD_ORGLONGNUMBER);
        totalDataSet = totalDataSet.addNullField(FIELD_ADMINORGNUMBER);
        int n = this.adminOrgLevel;
        while (var4_7 <= this.lastLevel) {
            totalDataSet = totalDataSet.addNullField(this.getOrgField((int)var4_7));
            ++var4_7;
        }
        String string = "'".concat(ResManager.loadKDString((String)"\u603b\u8ba1", (String)"SalaryDptMonthSumQueryRpt_2", (String)"swc-hsas-report", (Object[])new Object[0])).concat("'");
        totalDataSet = totalDataSet.addField(string, "seq");
        totalDataSet = totalDataSet.addField("3", "rowtype");
        totalDataSet = totalDataSet.select(this.queryInfo.getRowMeta().getFieldNames());
        return totalDataSet;
    }

    private DataSet buildSortDptMonthSumDataSet(DataSet dataSet) {
        dataSet = dataSet.addField("1", "rowtype");
        dataSet = dataSet.orderBy(new String[]{"structlongnumber asc"});
        dataSet = this.buildSeqDataSet(dataSet);
        return dataSet;
    }

    private DataSet buildDptSumDataSet(DataSet dataSet) {
        Object[] groupByFields = this.queryInfo.getCustomPara("adminOrgFieldArr", String[].class);
        groupByFields = (String[])SWCArrayUtils.concatAll((Object[])groupByFields, (Object[][])new String[][]{{FIELD_ADMINORGNUMBER, FIELD_ORGLONGNUMBER, "hsas_calpayrolltask.payrollgroupv.currency"}});
        GroupbyDataSet orgGroupByDataSet = dataSet.groupBy((String[])groupByFields);
        for (String sumField : this.queryInfo.getSumFieldCodes()) {
            orgGroupByDataSet = orgGroupByDataSet.sum(sumField, sumField);
        }
        DataSet orgSumDataSet = orgGroupByDataSet.finish();
        orgSumDataSet = orgSumDataSet.addNullField(new String[]{FIELD_BELONGPERIODSTR, "personnum"});
        orgSumDataSet = orgSumDataSet.addField("2", "rowtype");
        String title = ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"SalaryDptMonthSumQueryRpt_1", (String)"swc-hsas-report", (Object[])new Object[0]);
        orgSumDataSet = orgSumDataSet.addField("'".concat(title).concat("'"), "seq");
        return orgSumDataSet;
    }

    private DataSet buildDptMonthSumDataSet(DataSet dataSet, DataSet orgDataSet) {
        GroupbyDataSet groupByDataSet = dataSet.groupBy(this.queryInfo.getGroupByFields().toArray(new String[0]));
        for (String sumField : this.queryInfo.getSumFieldCodes()) {
            groupByDataSet = groupByDataSet.sum(sumField, sumField);
        }
        DataSet dptMonthSumDataSet = groupByDataSet.finish();
        dptMonthSumDataSet = this.addPersonNumField(dptMonthSumDataSet);
        String[] selectPerpies = this.buildDptMonthSelectPerpies();
        dptMonthSumDataSet = orgDataSet.join(dptMonthSumDataSet).on(FIELD_ADMINORGID, FIELD_ADMINORGID).select(selectPerpies).finish();
        return dptMonthSumDataSet;
    }

    private String[] buildDptMonthSelectPerpies() {
        String[] fieldNames = this.queryInfo.getRowMeta().getFieldNames();
        fieldNames = Arrays.copyOfRange(fieldNames, 1 + this.lastLevel - this.adminOrgLevel + 1, fieldNames.length - 1);
        ArrayList<String> orgFieldLists = new ArrayList<String>(10);
        for (int i = this.adminOrgLevel.intValue(); i <= this.lastLevel; ++i) {
            orgFieldLists.add(this.getOrgField(i));
            if (!this.isIncludeLower) continue;
            orgFieldLists.add(this.getOrgNumberField(i));
            orgFieldLists.add(this.getOrgLongNumberField(i));
        }
        fieldNames = (String[])SWCArrayUtils.concatAll((Object[])orgFieldLists.toArray(new String[0]), (Object[][])new String[][]{fieldNames});
        return fieldNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet buildDptMonthUpSumDataSet(DataSet periodSumDataSet) {
        String[] fieldNames = this.queryInfo.getRowMeta().getFieldNames();
        fieldNames = Arrays.copyOfRange(fieldNames, 1, fieldNames.length - 1);
        DataSet dptPeriodUpSumDataSet = null;
        for (int i = this.adminOrgLevel.intValue(); i <= this.lastLevel; ++i) {
            ArrayList<String> groupByFields = new ArrayList<String>(10);
            for (int j = this.adminOrgLevel.intValue(); j <= i; ++j) {
                groupByFields.add(this.getOrgField(j));
            }
            groupByFields.add(this.getOrgNumberField(i));
            groupByFields.add(this.getOrgLongNumberField(i));
            groupByFields.add("hsas_calpayrolltask.payrollgroupv.currency");
            groupByFields.add(FIELD_BELONGPERIODSTR);
            GroupbyDataSet orgGroupByDataSet = periodSumDataSet.copy().where(this.getOrgNumberField(i) + " <> ' '").groupBy(groupByFields.toArray(new String[0]));
            for (String sumField : this.queryInfo.getSumFieldCodes()) {
                orgGroupByDataSet = orgGroupByDataSet.sum(sumField, sumField);
            }
            orgGroupByDataSet.sum("personnum", "personnum");
            try (DataSet orgSumDataSet = null;){
                orgSumDataSet = orgGroupByDataSet.finish();
                orgSumDataSet = orgSumDataSet.addField(this.getOrgNumberField(i), FIELD_ADMINORGNUMBER);
                orgSumDataSet = orgSumDataSet.addField(this.getOrgLongNumberField(i), FIELD_ORGLONGNUMBER);
                for (int k = i + 1; k <= this.lastLevel; ++k) {
                    orgSumDataSet = orgSumDataSet.addNullField(this.getOrgField(k));
                }
                if (dptPeriodUpSumDataSet == null) {
                    dptPeriodUpSumDataSet = orgSumDataSet.select(fieldNames);
                    continue;
                }
                dptPeriodUpSumDataSet = dptPeriodUpSumDataSet.union(orgSumDataSet.select(fieldNames));
                continue;
            }
        }
        return dptPeriodUpSumDataSet;
    }

    private String getOrgField(int index) {
        String format = "org_%d";
        return String.format(Locale.ROOT, format, index);
    }

    private String getOrgNumberField(int index) {
        String format = "orgnumber_%d";
        return String.format(Locale.ROOT, format, index);
    }

    private String getOrgLongNumberField(int index) {
        String format = "orglongnumber_%d";
        return String.format(Locale.ROOT, format, index);
    }

    private DataSet buildAdminOrgDataSet() {
        RowMeta rowMeta = this.buildAdminOrgRowMeta();
        Collection<Object[]> coll = this.buildAdminOrgData(rowMeta);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    private Map<String, Map<String, Object>> buildAdminOrgMap() {
        HashMap<String, Map<String, Object>> adminOrgMap = new HashMap<String, Map<String, Object>>(this.adminOrgList.size());
        for (Map<String, Object> adminOrgDataMap : this.adminOrgList) {
            String structlongnumber = MapUtils.getString(adminOrgDataMap, (Object)"structLongNumber");
            int level = MapUtils.getInteger(adminOrgDataMap, (Object)"orgLevel");
            if (level > this.lastLevel) continue;
            adminOrgMap.put(structlongnumber, adminOrgDataMap);
        }
        return adminOrgMap;
    }

    private Collection<Object[]> buildAdminOrgData(RowMeta rowMeta) {
        Map<String, Map<String, Object>> adminOrgMap = this.buildAdminOrgMap();
        ArrayList<Object[]> coll = new ArrayList<Object[]>(this.adminOrgList.size());
        int startIndex = this.adminOrgLongNumber.lastIndexOf(33) + 1;
        for (Map<String, Object> adminOrgDataMap : this.adminOrgList) {
            Object[] obj = new Object[rowMeta.getFieldNames().length];
            String structLongNumber = MapUtils.getString(adminOrgDataMap, (Object)"structLongNumber");
            String tmpCurrLevelLongNumber = structLongNumber.substring(startIndex);
            String[] orgNumberArray = tmpCurrLevelLongNumber.split("!");
            StringBuilder tmpNumberBuilder = startIndex > 1 ? new StringBuilder(structLongNumber.substring(0, startIndex - 1)) : new StringBuilder();
            int index = 0;
            int levelIndex = this.adminOrgLevel;
            String tmpLongNumber = "";
            for (String orgNumber : orgNumberArray) {
                Map<String, Object> adminOrgNameMap;
                if (levelIndex > this.lastLevel) break;
                if (tmpNumberBuilder.length() > 0) {
                    tmpNumberBuilder = tmpNumberBuilder.append('!');
                }
                obj[index] = (adminOrgNameMap = adminOrgMap.get(tmpLongNumber = (tmpNumberBuilder = tmpNumberBuilder.append(orgNumber)).toString())) == null ? " " : MapUtils.getString(adminOrgNameMap, (Object)"orgName");
                ++index;
                if (this.isIncludeLower) {
                    obj[index] = adminOrgNameMap == null ? " " : MapUtils.getString(adminOrgNameMap, (Object)"orgNumber");
                    obj[++index] = tmpLongNumber;
                    ++index;
                }
                ++levelIndex;
            }
            while (index < rowMeta.getFieldNames().length - 4) {
                obj[index] = " ";
                ++index;
            }
            obj[index] = MapUtils.getString(adminOrgDataMap, (Object)"orgNumber");
            obj[++index] = tmpLongNumber;
            obj[++index] = MapUtils.getString(adminOrgDataMap, (Object)"orgLevel");
            obj[++index] = MapUtils.getString(adminOrgDataMap, (Object)"orgId");
            coll.add(obj);
        }
        return coll;
    }

    private RowMeta buildAdminOrgRowMeta() {
        ArrayList<String> fieldNameLists = new ArrayList<String>(10);
        ArrayList<Object> dataTypeLists = new ArrayList<Object>(10);
        for (int i = this.adminOrgLevel.intValue(); i <= this.lastLevel; ++i) {
            fieldNameLists.add(this.getOrgField(i));
            dataTypeLists.add(DataType.StringType);
            if (!this.isIncludeLower) continue;
            fieldNameLists.add(this.getOrgNumberField(i));
            dataTypeLists.add(DataType.StringType);
            fieldNameLists.add(this.getOrgLongNumberField(i));
            dataTypeLists.add(DataType.StringType);
        }
        fieldNameLists.add(FIELD_ADMINORGNUMBER);
        dataTypeLists.add(DataType.StringType);
        fieldNameLists.add(FIELD_ORGLONGNUMBER);
        dataTypeLists.add(DataType.StringType);
        fieldNameLists.add(FIELD_ADMINORGLEVEL);
        dataTypeLists.add(DataType.StringType);
        fieldNameLists.add(FIELD_ADMINORGID);
        dataTypeLists.add(DataType.LongType);
        String[] fieldNames = fieldNameLists.toArray(new String[0]);
        DataType[] dataTypes = dataTypeLists.toArray(new DataType[0]);
        return RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
    }

    @Override
    protected SalaryRptParamHandler getRptQueryParamHandler() {
        return new SalaryDptMonthSumRptParamHandler();
    }
}

