/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.web;

import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.swc.hsas.report.entity.SalaryRptQueryInfo;
import kd.swc.hsas.report.web.SalaryRptBaseAbstractPlugin;
import kd.swc.hsbp.common.cache.SWCPageCache;

public abstract class SalaryRptPageAbstractPlugin
extends SalaryRptBaseAbstractPlugin {
    protected static final Log logger = LogFactory.getLog(SalaryRptPageAbstractPlugin.class);

    @Override
    public DataSet queryBatchBy(ReportQueryParam queryParam, SalaryRptQueryInfo queryInfo) {
        this.removeCache(queryInfo);
        this.timeLog.logStart("SalaryRptPageAbstractPlugin doQueryBatchBy first");
        DataSet dataSet = this.doQueryBatchBy(queryParam, queryInfo, false);
        this.timeLog.logEnd("SalaryRptPageAbstractPlugin doQueryBatchBy first");
        if (!queryInfo.isLoadAll()) {
            this.asynQueryBatchBy(queryParam, queryInfo);
        }
        return dataSet;
    }

    @Override
    public DataSet query(ReportQueryParam reportQueryParam, Object o, SalaryRptQueryInfo queryInfo) {
        int count = 0;
        while (queryInfo.isNeedWaitQueryBatchBy(reportQueryParam)) {
            try {
                if (count > 45) {
                    this.timeLog.logEnd("wait queryBatchBy timed out...");
                    break;
                }
                Thread.sleep(1000L);
                this.queryInfo = queryInfo = this.getCacheQueryInfo(queryInfo.getPageId());
                ++count;
            }
            catch (InterruptedException e) {
                logger.info("SalaryRptPageAbstractPlugin query error : {}", (Object)e);
            }
        }
        return this.doQuery(reportQueryParam, o, queryInfo);
    }

    protected void asynQueryBatchBy(ReportQueryParam queryParam, SalaryRptQueryInfo queryInfo) {
        ThreadPools.executeOnce((String)"kd.swc.hsas.report.web.SalaryRptPageAbstractPlugin.asynQueryBatchBy", () -> {
            try (Object dataSetAll = null;){
                this.timeLog.logStart("SalaryRptPageAbstractPlugin asynQueryBatchBy");
                this.timeLog.logStart("SalaryRptPageAbstractPlugin asynQueryBatchBy doQueryBatchBy");
                this.doQueryBatchBy(queryParam, queryInfo, true);
                this.timeLog.logEnd("SalaryRptPageAbstractPlugin asynQueryBatchBy doQueryBatchBy");
                this.cacheIsLoadAll(queryInfo);
                this.timeLog.logEnd("SalaryRptPageAbstractPlugin asynQueryBatchBy");
            }
        });
    }

    protected void removeCache(SalaryRptQueryInfo queryInfo) {
        String pageId = queryInfo.getPageId();
        SWCPageCache pageCache = new SWCPageCache(pageId);
        pageCache.remove("report_isLoadAll");
        Integer totalBatch = (Integer)pageCache.get("report_totalBatch", Integer.class);
        pageCache.remove("report_totalBatch");
        String cacheId = pageId + "_batch_";
        if (totalBatch != null) {
            Integer i = 0;
            while (i < totalBatch) {
                Algo.removeCacheDataSet((String)(cacheId + i));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        pageCache.saveChanges();
    }

    protected void cacheIsLoadAll(SalaryRptQueryInfo queryInfo) {
        String pageId = queryInfo.getPageId();
        SWCPageCache pageCache = new SWCPageCache(pageId);
        pageCache.put("report_isLoadAll", (Object)queryInfo.isLoadAll());
        pageCache.put("report_totalBatch", (Object)queryInfo.getTotalBatch());
        pageCache.saveChanges();
    }

    protected abstract DataSet doQueryBatchBy(ReportQueryParam var1, SalaryRptQueryInfo var2, boolean var3);

    protected abstract DataSet doQuery(ReportQueryParam var1, Object var2, SalaryRptQueryInfo var3);
}

