/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.web;

import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsas.report.api.SalaryRptParamHandler;
import kd.swc.hsas.report.impl.SalarySumRptParamHandler;
import kd.swc.hsas.report.web.SalaryAsyncSumAbstractPlugin;
import org.apache.commons.lang3.StringUtils;

public class SalarySumQueryRpt
extends SalaryAsyncSumAbstractPlugin {
    private static final Log log = LogFactory.getLog(SalarySumQueryRpt.class);
    private final String logPrefix = ((Object)((Object)this)).getClass().getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DataSet buildResultData() {
        log.info("{} buildResultData start", (Object)this.logPrefix);
        DataSet sumDataSet = null;
        DataSet totalDataSet = null;
        try {
            this.timeLog.logStart(this.logPrefix + " buildSumDataSet");
            sumDataSet = this.buildSumDataSet(this.preDataSet.copy());
            this.timeLog.logEnd(this.logPrefix + " buildSumDataSet");
            this.timeLog.logStart(this.logPrefix + " buildResultData");
            if (this.isShowTotal) {
                totalDataSet = this.buildTotalDataSet(sumDataSet);
                DataSet dataSet = sumDataSet.union(totalDataSet);
                return dataSet;
            }
            DataSet dataSet = sumDataSet.copy();
            return dataSet;
        }
        finally {
            if (sumDataSet != null) {
                sumDataSet.close();
            }
            if (totalDataSet != null) {
                totalDataSet.close();
            }
            this.timeLog.logEnd(this.logPrefix + " buildResultData");
            log.info("{} buildResultData end", (Object)this.logPrefix);
        }
    }

    protected DataSet buildSumDataSet(DataSet dataSet) {
        this.timeLog.logStart(this.logPrefix + " buildSumDataSet 1");
        GroupbyDataSet groupByDataSet = dataSet.groupBy(this.queryInfo.getGroupByFields().toArray(new String[0]));
        for (String sumField : this.queryInfo.getSumFieldCodes()) {
            groupByDataSet = groupByDataSet.sum(sumField, sumField);
        }
        DataSet sumDataSet = groupByDataSet.finish();
        this.timeLog.logEnd(this.logPrefix + " buildSumDataSet 1");
        this.timeLog.logStart(this.logPrefix + " buildSumDataSet 2");
        sumDataSet = this.addPersonNumField(sumDataSet);
        this.timeLog.logEnd(this.logPrefix + " buildSumDataSet 2");
        this.timeLog.logStart(this.logPrefix + " buildSumDataSet 3");
        sumDataSet = sumDataSet.addField("1", "rowtype");
        if (!StringUtils.isEmpty((CharSequence)this.queryInfo.getOrderByStr())) {
            sumDataSet = sumDataSet.orderBy(this.queryInfo.getOrderByStr().split(","));
        }
        this.timeLog.logEnd(this.logPrefix + " buildSumDataSet 3");
        this.timeLog.logStart(this.logPrefix + " buildSumDataSet 4");
        sumDataSet = this.buildSeqDataSet(sumDataSet);
        this.timeLog.logEnd(this.logPrefix + " buildSumDataSet 4");
        this.timeLog.logStart(this.logPrefix + " buildSumDataSet 5");
        sumDataSet = this.addFiledWhenBuildSumDataSet(sumDataSet);
        sumDataSet = sumDataSet.select(this.queryInfo.getRowMeta().getFieldNames());
        this.timeLog.logEnd(this.logPrefix + " buildSumDataSet 5");
        return sumDataSet;
    }

    protected DataSet buildTotalDataSet(DataSet dataSet) {
        GroupbyDataSet groupByDataSet = dataSet.groupBy(new String[]{"hsas_calpayrolltask.payrollgroupv.currency"});
        for (String sumField : this.queryInfo.getSumFieldCodes()) {
            groupByDataSet = groupByDataSet.sum(sumField, sumField);
        }
        DataSet totalDataSet = groupByDataSet.finish();
        int totalPersonCount = this.buildTotalPersonCount(this.personDataSet);
        totalDataSet = totalDataSet.addField(String.valueOf(totalPersonCount), "personnum");
        totalDataSet = totalDataSet.addField("3", "rowtype");
        for (String groupByField : this.queryInfo.getGroupByFields()) {
            if ("hsas_calpayrolltask.payrollgroupv.currency".equals(groupByField)) continue;
            totalDataSet = totalDataSet.addNullField(groupByField);
        }
        String title = "'".concat(ResManager.loadKDString((String)"\u603b\u8ba1", (String)"SalarySumQueryRpt_1", (String)"swc-hsas-report", (Object[])new Object[0])).concat("'");
        totalDataSet = totalDataSet.addField(title, "seq");
        totalDataSet = this.addFiledWhenBuildTotalDataSet(totalDataSet);
        totalDataSet = totalDataSet.select(this.queryInfo.getRowMeta().getFieldNames());
        return totalDataSet;
    }

    protected DataSet addFiledWhenBuildSumDataSet(DataSet sumDataSet) {
        return sumDataSet;
    }

    protected DataSet addFiledWhenBuildTotalDataSet(DataSet totalDataSet) {
        return totalDataSet;
    }

    protected int buildTotalPersonCount(DataSet dataSet) {
        GroupbyDataSet groupByDataSet = dataSet.copy().groupBy(null);
        groupByDataSet = groupByDataSet.countDistinct(new String[]{"hsas_employee.id"}, "personnum");
        return groupByDataSet.finish().next().getInteger("personnum");
    }

    @Override
    protected SalaryRptParamHandler getRptQueryParamHandler() {
        return new SalarySumRptParamHandler();
    }
}

