/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.opplugin.validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexBaseInfo;
import kd.bos.mutex.impl.MutexLockDataInfo;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCNetworkControlValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(SWCNetworkControlValidator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        DataMutex dataMutex = null;
        try {
            dataMutex = DataMutex.create();
            String entityId = dataEntities[0].getDataEntity().getDataEntityType().getName();
            String groupId = MutexHelper.getMutexGroupId((String)entityId, (String)"modify");
            ArrayList<MutexBaseInfo> queryList = new ArrayList<MutexBaseInfo>(dataEntities.length);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                String pkId = dataEntity.getDataEntity().getString("id");
                MutexBaseInfo baseInfo = new MutexBaseInfo();
                baseInfo.setDataObjId(pkId);
                baseInfo.setGroupId(groupId);
                baseInfo.setEntityNumber(entityId);
                queryList.add(baseInfo);
            }
            List lockInfos = dataMutex.getLockInfo(queryList);
            if (lockInfos == null || lockInfos.size() == 0) {
                return;
            }
            Map<String, MutexLockDataInfo> lockInfoMap = lockInfos.stream().collect(Collectors.toMap(info -> info.getDataObjId(), info -> info, (v1, v2) -> v1));
            MutexLockDataInfo lockInfo = null;
            for (ExtendedDataEntity dataEntity : dataEntities) {
                String msg;
                String pkId = dataEntity.getDataEntity().getString("id");
                lockInfo = lockInfoMap.get(pkId);
                if (null == lockInfo || null == (msg = this.getMutexNotification(lockInfo))) continue;
                this.addErrorMessage(dataEntity, msg);
            }
        }
        finally {
            try {
                if (null != dataMutex) {
                    dataMutex.close();
                }
            }
            catch (IOException exception) {
                LOGGER.error((Throwable)exception);
            }
        }
    }

    private String getMutexNotification(MutexLockDataInfo lockInfo) {
        Map userInfo;
        String userId = lockInfo.getUserId();
        if (!SWCStringUtils.isEmpty((String)userId) && null != (userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(userId)))) {
            String userName = (String)userInfo.get("name");
            if (!SWCStringUtils.isEmpty((String)userName)) {
                return ResManager.loadKDString((String)"{0}\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"SWCNetworkControlValidator_0", (String)"swc-hsbp-formplugin", (Object[])new Object[]{userName});
            }
            return ResManager.loadKDString((String)"\u7f51\u7edc\u4e92\u65a5\u68c0\u6d4b\u51fa\u6709\u4eba\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"SWCHisBlockBaseDataEdit_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
        }
        return null;
    }
}

