/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.dynamic.grid;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.xdb.util.Pair;
import kd.swc.hsbp.common.dynamic.grid.FieldParamContainer;

public class ComboFieldParamContainer
extends FieldParamContainer {
    private static final long serialVersionUID = 5115000709108473366L;
    private String defValue;
    private List<ComboItem> items = new ArrayList<ComboItem>();

    @Override
    public String getDefValue() {
        return this.defValue;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    public List<ComboItem> getItems() {
        return this.items;
    }

    public void setItems(List<ComboItem> items) {
        this.items = items;
    }

    public boolean addItems(Pair<String, String> ... comboItems) {
        for (Pair<String, String> comboItem : comboItems) {
            ComboItem item = new ComboItem();
            item.setValue((String)comboItem.getKey());
            item.setCaption(new LocaleString((String)comboItem.getValue()));
            item.setItemVisible(true);
            item.setDisable(false);
            this.items.add(item);
        }
        return true;
    }

    public boolean addItems(ComboItem ... comboItems) {
        for (ComboItem comboItem : comboItems) {
            this.items.add(comboItem);
        }
        return true;
    }

    @Override
    <T extends DynamicProperty> T createProp() {
        return (T)new ComboProp();
    }

    @Override
    <T extends DynamicProperty> void setPropProperty(T prop) {
        ComboProp comboProp = (ComboProp)prop;
        List propItems = this.items.stream().map(item -> new ValueMapItem(item.getImageKey(), item.getValue(), item.getCaption(), item.isItemVisible())).collect(Collectors.toList());
        comboProp.setComboItems(propItems);
    }

    @Override
    <T extends DynamicProperty> void doRegisterProp(T prop, EntityType entityType) {
        entityType.registerSimpleProperty((DynamicSimpleProperty)((ComboProp)prop));
    }

    @Override
    <T extends Field> T createField() {
        return (T)new ComboField();
    }

    @Override
    protected <T extends Field> void setFieldProperties(T field) {
        super.setFieldProperties(field);
        ComboField comboField = (ComboField)field;
        comboField.setItems(this.items);
        comboField.setEntityMetadata(this.getEntityMetadata());
        comboField.setDefValue(this.defValue);
    }
}

