/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.swc.hsbp.common.entity.SWCI18NParam;
import kd.swc.hsbp.common.enums.ConditionValueTypeEnum;
import kd.swc.hsbp.common.enums.RuleOperatorEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;

public enum ConditionFieldTypeEnum {
    TYPE_ID("Id", new SWCI18NParam("id", "ConditionFieldTypeEnum_0", "swc-hsbp-common")),
    TYPE_ENUM("Enum", new SWCI18NParam("\u679a\u4e3e", "ConditionFieldTypeEnum_1", "swc-hsbp-common")),
    TYPE_NUM("BigDecimal", new SWCI18NParam("\u6570\u503c", "ConditionFieldTypeEnum_2", "swc-hsbp-common")),
    TYPE_DATE("Date", new SWCI18NParam("\u65e5\u671f", "ConditionFieldTypeEnum_3", "swc-hsbp-common")),
    TYPE_TEXT("String", new SWCI18NParam("\u6587\u672c", "ConditionFieldTypeEnum_4", "swc-hsbp-common"));

    private String code;
    private SWCI18NParam name;

    private ConditionFieldTypeEnum(String code, SWCI18NParam name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public SWCI18NParam getName() {
        return this.name;
    }

    public static String getDesc(String code) {
        ConditionFieldTypeEnum[] valueArr;
        if (code == null) {
            return null;
        }
        for (ConditionFieldTypeEnum fieldTypeEnum : valueArr = ConditionFieldTypeEnum.values()) {
            if (!fieldTypeEnum.getCode().equals(code)) continue;
            return fieldTypeEnum.getDesc();
        }
        return null;
    }

    public String getDesc() {
        return this.name.loadKDString();
    }

    public static String getCompareTypeByValue(String valueCode) {
        return RuleOperatorEnum.getEnum(valueCode).getName();
    }

    public static List<RuleOperatorEnum> getJudgeConditionByType(String type) {
        List<RuleOperatorEnum> list;
        switch (type) {
            case "Id": 
            case "Enum": {
                list = Arrays.asList(RuleOperatorEnum.IN, RuleOperatorEnum.NOT_IN, RuleOperatorEnum.EQUAL, RuleOperatorEnum.NOT_EQUAL, RuleOperatorEnum.IS_NULL, RuleOperatorEnum.IS_NOT_NULL);
                break;
            }
            case "BigDecimal": {
                list = Arrays.asList(RuleOperatorEnum.EQUAL, RuleOperatorEnum.NOT_EQUAL, RuleOperatorEnum.GREATER_THAN, RuleOperatorEnum.LESS_THAN, RuleOperatorEnum.GREATER_OR_EQUAL, RuleOperatorEnum.LESS_OR_EQUAL);
                break;
            }
            case "Date": {
                list = Arrays.asList(RuleOperatorEnum.EQUAL, RuleOperatorEnum.NOT_EQUAL, RuleOperatorEnum.IS_NULL, RuleOperatorEnum.IS_NOT_NULL, RuleOperatorEnum.GREATER_THAN, RuleOperatorEnum.LESS_THAN, RuleOperatorEnum.GREATER_OR_EQUAL, RuleOperatorEnum.LESS_OR_EQUAL);
                break;
            }
            case "String": {
                list = Arrays.asList(RuleOperatorEnum.IN, RuleOperatorEnum.NOT_IN, RuleOperatorEnum.EQUAL, RuleOperatorEnum.NOT_EQUAL, RuleOperatorEnum.IS_NULL, RuleOperatorEnum.IS_NOT_NULL, RuleOperatorEnum.CONTAINS, RuleOperatorEnum.NOT_CONTAINS, RuleOperatorEnum.STARTS_WITH, RuleOperatorEnum.ENDS_WITH);
                break;
            }
            default: {
                list = new ArrayList<RuleOperatorEnum>(0);
            }
        }
        return list;
    }

    public static List<ConditionValueTypeEnum> getValueTypeByCondition(String type, String calingFetch, String dimensionality) {
        List<ConditionValueTypeEnum> list;
        switch (type) {
            case "==": 
            case "!=": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_FIXED, ConditionValueTypeEnum.TYPE_FTITEM));
                if (SWCStringUtils.equals("0", dimensionality)) {
                    list.add(ConditionValueTypeEnum.TYPE_PERSON);
                } else {
                    list.add(ConditionValueTypeEnum.TYPE_TASK);
                }
                if (!SWCStringUtils.equals("true", calingFetch)) break;
                list.add(ConditionValueTypeEnum.TYPE_SPITEM);
                break;
            }
            case ">": 
            case "<": 
            case ">=": 
            case "<=": 
            case "startsWith": 
            case "endsWith": 
            case "contains": 
            case "not_contains": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_FIXED, ConditionValueTypeEnum.TYPE_FTITEM));
                if (!SWCStringUtils.equals("true", calingFetch)) break;
                list.add(ConditionValueTypeEnum.TYPE_SPITEM);
                break;
            }
            case "in": 
            case "not_in": {
                list = Collections.singletonList(ConditionValueTypeEnum.TYPE_FIXED);
                break;
            }
            default: {
                list = new ArrayList<ConditionValueTypeEnum>(0);
            }
        }
        return list;
    }

    public static boolean getMultiSelectByCompareType(String compareType) {
        List<String> multiSelectTypeList = Arrays.asList("in", "not_in");
        return multiSelectTypeList.contains(compareType);
    }

    public static List<ConditionValueTypeEnum> getValueTypeByFieldType(String fieldType, String calingFetch, String dimensionality) {
        List<ConditionValueTypeEnum> list;
        switch (fieldType) {
            case "Id": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_PERSON, ConditionValueTypeEnum.TYPE_FIXED));
                if (SWCStringUtils.equals("0", dimensionality)) {
                    list.add(ConditionValueTypeEnum.TYPE_PERSON);
                    break;
                }
                list.add(ConditionValueTypeEnum.TYPE_TASK);
                break;
            }
            case "Enum": {
                list = Collections.singletonList(ConditionValueTypeEnum.TYPE_FIXED);
                break;
            }
            case "BigDecimal": 
            case "Date": 
            case "String": {
                list = new ArrayList<ConditionValueTypeEnum>(Arrays.asList(ConditionValueTypeEnum.TYPE_FIXED, ConditionValueTypeEnum.TYPE_FTITEM));
                if (!SWCStringUtils.equals("true", calingFetch)) break;
                list.add(ConditionValueTypeEnum.TYPE_SPITEM);
                break;
            }
            default: {
                list = new ArrayList<ConditionValueTypeEnum>(0);
            }
        }
        return list;
    }
}

