/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IClientViewProxy;
import org.apache.commons.lang.StringUtils;

public class SWCGridUtils {
    public static void setGridStyle(IClientViewProxy clientViewProxy, String gridKey, int rowIndex, String columnKey, String color) {
        ArrayList rowStyle = new ArrayList();
        HashMap<String, String> mapStyle = new HashMap<String, String>();
        mapStyle.put("fc", color);
        HashMap<String, Object> val = new HashMap<String, Object>();
        val.put("r", rowIndex);
        val.put("c", columnKey);
        val.put("s", mapStyle);
        rowStyle.add(val);
        clientViewProxy.invokeControlMethod(gridKey, "setCellStyle", new Object[]{rowStyle});
    }

    public static List<Map<String, Object>> setGridStyle(int[] rows, String columnKey, String color, String styleName) {
        ArrayList<Map<String, Object>> rowStyle = new ArrayList<Map<String, Object>>(10);
        for (int rowIndex : rows) {
            HashMap<String, Object> val = new HashMap<String, Object>(3);
            val.put("r", rowIndex);
            val.put("c", columnKey);
            HashMap<String, String> mapStyle = new HashMap<String, String>(1);
            mapStyle.put(styleName, color);
            val.put("s", mapStyle);
            rowStyle.add(val);
        }
        return rowStyle;
    }

    public static void lockCell(IClientViewProxy clientViewProxy, String gridKey, int[] rows, String colName, boolean isLock) {
        ArrayList list = new ArrayList(1);
        HashMap<String, Object> args = new HashMap<String, Object>(2);
        args.put("o", "s");
        HashMap<String, Object> vMap = new HashMap<String, Object>(3);
        vMap.put("r", rows);
        vMap.put("k", colName);
        vMap.put("l", isLock);
        args.put("v", new Object[]{vMap});
        list.add(args);
        clientViewProxy.invokeControlMethod(gridKey, "lock", new Object[]{list});
    }

    public static void lockCell(IClientViewProxy clientViewProxy, String gridKey, int[] rows, String[] colNames, boolean isLock) {
        ArrayList list = new ArrayList(colNames.length);
        for (String colName : colNames) {
            HashMap<String, Object> args = new HashMap<String, Object>(2);
            args.put("o", "s");
            HashMap<String, Object> vMap = new HashMap<String, Object>(3);
            vMap.put("r", rows);
            vMap.put("k", colName);
            vMap.put("l", isLock);
            args.put("v", new Object[]{vMap});
            list.add(args);
        }
        clientViewProxy.invokeControlMethod(gridKey, "lock", new Object[]{list});
    }

    public static void lockCell(IClientViewProxy clientViewProxy, String gridKey, Map<String, int[]> colMap, boolean isLock) {
        ArrayList list = new ArrayList(colMap.size());
        for (Map.Entry<String, int[]> col : colMap.entrySet()) {
            HashMap<String, Object> args = new HashMap<String, Object>(2);
            args.put("o", "s");
            HashMap<String, Object> vMap = new HashMap<String, Object>(3);
            vMap.put("r", col.getValue());
            vMap.put("k", col.getKey());
            vMap.put("l", isLock);
            args.put("v", new Object[]{vMap});
            list.add(args);
        }
        clientViewProxy.invokeControlMethod(gridKey, "lock", new Object[]{list});
    }

    public static Map<String, Object> buildSeqColumn(String gridKey) {
        Map<String, Object> map = SWCGridUtils.buildSeqColumn(gridKey, null, null, null, true);
        return map;
    }

    public static Map<String, Object> buildRkColumn(String gridKey) {
        Map<String, Object> map = SWCGridUtils.buildRkColumn(gridKey, null, null, null, true);
        return map;
    }

    public static Map<String, Object> buildRkColumn(String gridKey, LocaleString header, LocaleString width, String textAlign, boolean visible) {
        if (header == null) {
            header = new LocaleString("rk");
        }
        if (width == null) {
            width = new LocaleString("50px");
        }
        Map<String, Object> column = SWCGridUtils.buildCommonColumn(gridKey, "rk", header, width, textAlign, visible, false);
        return column;
    }

    public static Map<String, Object> buildSeqColumn(String gridKey, LocaleString header, LocaleString width, String textAlign, boolean visible) {
        if (header == null) {
            header = new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"SWCGridUtils_0", (String)"swc-hsbp-common", (Object[])new Object[0]));
        }
        if (width == null) {
            width = new LocaleString("50px");
        }
        Map<String, Object> column = SWCGridUtils.buildCommonColumn(gridKey, "seq", header, width, textAlign, visible, false);
        HashMap<String, String> editor = new HashMap<String, String>();
        editor.put("type", "long");
        column.put("editor", editor);
        return column;
    }

    public static Map<String, Object> buildTextColumn(String gridKey, String columnKey, LocaleString header, int maxLength, boolean lock, boolean isRequired) {
        Map<String, Object> map = SWCGridUtils.buildTextColumn(gridKey, columnKey, header, maxLength, null, null, true, lock, isRequired);
        return map;
    }

    public static Map<String, Object> buildTextColumn(String gridKey, String columnKey, LocaleString header, int maxLength, LocaleString width, String textAlign, boolean visible, boolean lock, boolean isRequired) {
        Map<String, Object> column = SWCGridUtils.buildCommonColumn(gridKey, columnKey, header, width, textAlign, visible, lock);
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "text");
        editor.put("maxlength", maxLength);
        editor.put("mi", isRequired);
        column.put("editor", editor);
        return column;
    }

    public static Map<String, Object> buildCurrencyColumn(String gridKey, String columnKey, LocaleString header, LocaleString width, boolean isRequired) {
        Map<String, Object> column = SWCGridUtils.buildCommonColumn(gridKey, columnKey, header, width, null, false, false);
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("dsp", "name");
        editor.put("dst", 0);
        editor.put("ei", "bd_currency");
        editor.put("ep", 0);
        editor.put("type", "basedata");
        editor.put("mi", isRequired);
        column.put("editor", editor);
        return column;
    }

    public static Map<String, Object> buildNumberColumn(String gridKey, String columnKey, LocaleString header, int precion, int scale, boolean lock, boolean isRequired) {
        Map<String, Object> map = SWCGridUtils.buildNumberColumn(gridKey, columnKey, header, precion, scale, null, null, true, lock, isRequired);
        return map;
    }

    public static Map<String, Object> buildAmountColumn(String gridKey, String columnKey, LocaleString header, LocaleString width, int precion, int scale, boolean lock, String currencyField, boolean isRequired) {
        Map<String, Object> map = SWCGridUtils.buildNumberColumn(gridKey, columnKey, header, precion, scale, width, null, true, lock, isRequired);
        Map editor = (Map)map.get("editor");
        editor.put("nt", "amount");
        editor.put("sf", currencyField);
        map.put("editor", editor);
        return map;
    }

    public static Map<String, Object> buildIntColumn(String gridKey, String columnKey, LocaleString header, int precion, LocaleString width, int scale, boolean lock, boolean isRequired) {
        Map<String, Object> map = SWCGridUtils.buildNumberColumn(gridKey, columnKey, header, precion, scale, width, null, true, lock, isRequired);
        Map editor = (Map)map.get("editor");
        editor.put("nt", "D");
        map.put("editor", editor);
        return map;
    }

    public static Map<String, Object> buildNumberColumn(String gridKey, String columnKey, LocaleString header, int precion, int scale, LocaleString width, String textAlign, boolean visible, boolean lock, boolean isRequired) {
        Map<String, Object> column = SWCGridUtils.buildCommonColumn(gridKey, columnKey, header, width, textAlign, visible, lock);
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "number");
        editor.put("mi", isRequired);
        editor.put("pc", precion + scale);
        editor.put("sc", scale);
        editor.put("qan", Boolean.TRUE);
        editor.put("zs", Boolean.TRUE);
        column.put("editor", editor);
        return column;
    }

    public static Map<String, Object> buildBoolColumn(String gridKey, String columnKey, LocaleString header, LocaleString width, boolean lock, boolean isRequired) {
        Map<String, Object> map = SWCGridUtils.buildBoolColumn(gridKey, columnKey, header, width, null, true, lock, isRequired);
        return map;
    }

    public static Map<String, Object> buildBoolColumn(String gridKey, String columnKey, LocaleString header, LocaleString width, String textAlign, boolean visible, boolean lock, boolean isRequired) {
        Map<String, Object> column = SWCGridUtils.buildCommonColumn(gridKey, columnKey, header, width, textAlign, visible, lock);
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "checkbox");
        editor.put("mi", isRequired);
        column.put("editor", editor);
        return column;
    }

    public static Map<String, Object> buildDateColumn(String gridKey, String columnKey, LocaleString header, LocaleString width, boolean lock, boolean isRequired) {
        Map<String, Object> map = SWCGridUtils.buildDateColumn(gridKey, columnKey, header, width, null, true, lock, isRequired);
        return map;
    }

    public static Map<String, Object> buildDateColumn(String gridKey, String columnKey, LocaleString header, LocaleString width, String textAlign, boolean visible, boolean lock, boolean isRequired) {
        Map<String, Object> column = SWCGridUtils.buildCommonColumn(gridKey, columnKey, header, width, textAlign, visible, lock);
        column.put("entity", gridKey);
        column.put("dataIndex", columnKey);
        column.put("coltype", 3);
        column.put("header", header);
        column.put("vi", visible);
        column.put("w", width);
        column.put("text-align", textAlign);
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("today", new Date());
        editor.put("type", "date");
        editor.put("regiontype", 2);
        editor.put("mi", isRequired);
        column.put("editor", editor);
        return column;
    }

    public static Map<String, Object> buildCommonColumn(String gridKey, String columnKey, LocaleString header, LocaleString width, String textAlign, boolean visible, boolean lock) {
        if (width == null) {
            width = new LocaleString("120px");
        }
        if (StringUtils.isEmpty((String)textAlign)) {
            textAlign = "default";
        }
        HashMap<String, Object> column = new HashMap<String, Object>();
        column.put("entity", gridKey);
        column.put("dataIndex", columnKey);
        column.put("coltype", 1);
        column.put("header", header);
        if (visible) {
            column.put("vi", 63);
        } else {
            column.put("vi", Boolean.FALSE);
        }
        column.put("l", lock);
        column.put("w", width);
        column.put("text-align", textAlign);
        return column;
    }

    public static void buildCulumnTips(Map<String, Object> column, String tipsTitle, String tipsContent, String locale) {
        HashMap<String, Object> tips = new HashMap<String, Object>();
        HashMap<String, String> content = new HashMap<String, String>();
        content.put(locale, tipsContent);
        tips.put("content", content);
        tips.put("link", Boolean.FALSE);
        tips.put("showIcon", Boolean.TRUE);
        HashMap<String, String> title = new HashMap<String, String>();
        title.put(locale, tipsTitle);
        tips.put("title", title);
        tips.put("triggerType", "hover");
        tips.put("type", "text");
        column.put("tips", tips);
    }
}

