/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;

public class SWCStringUtils {
    public static final int INDEX_NOT_FOUND = -1;
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] JAVA_KEYWORDS = new String[]{"assert", "abstract", "continue", "for", "new", "switch", "boolean", "default", "goto", "null", "synchronized", "break", "do", "if", "package", "this", "byte", "double", "implements", "private", "threadsafe", "byvalue", "else", "import", "protected", "throw", "case", "extends", "instanceof", "public", "transient", "catch", "false", "int", "return", "true", "char", "final", "interface", "short", "try", "class", "finally", "long", "static", "void", "const", "float", "native", "super", "while", "volatile", "strictfp"};
    private static String VOWELS = "AEIOU";
    private static String FRONTV = "EIY";
    private static String VARSON = "CSPTG";
    private static final int SEPERATOR_DEFAULT_SIZE = 9;

    public static String[] split(String line, int seperator) {
        int jIndex;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return null;
        }
        if (line.indexOf(seperator) < 0) {
            return new String[]{line};
        }
        ArrayList<String> valList = new ArrayList<String>(10);
        int index = 0;
        while ((jIndex = line.indexOf(seperator, index)) >= 0) {
            valList.add(line.substring(index, jIndex).trim());
            index = jIndex + 1;
        }
        valList.add(line.substring(index).trim());
        return valList.toArray(new String[valList.size()]);
    }

    public static String[] split(String line, String seperator) {
        int jIndex;
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new String[]{""};
        }
        if (line.indexOf(seperator) < 0) {
            return new String[]{line};
        }
        ArrayList<String> list = new ArrayList<String>(10);
        int index = 0;
        while ((jIndex = line.indexOf(seperator, index)) >= 0) {
            list.add(line.substring(index, jIndex).trim());
            index = jIndex + seperator.length();
        }
        list.add(line.substring(index).trim());
        return list.toArray(new String[list.size()]);
    }

    public static String fixNumber(long num) {
        return SWCStringUtils.fixNumber(num, 8);
    }

    public static String fixNumber(long num, int len) {
        char[] bArr = new char[len];
        for (int i = 0; i < len; ++i) {
            bArr[i] = 48;
        }
        return new DecimalFormat(new String(bArr)).format(num);
    }

    public static String fixNumber(int num) {
        return SWCStringUtils.fixNumber((long)num, 4);
    }

    public static String fixNumber(int num, int len) {
        return SWCStringUtils.fixNumber((long)num, len);
    }

    public static final boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static final boolean isNotEmpty(String str) {
        return !SWCStringUtils.isEmpty(str);
    }

    public static boolean equals(String s1, String s2) {
        if (SWCStringUtils.isEmpty(s1)) {
            return SWCStringUtils.isEmpty(s2);
        }
        return s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (SWCStringUtils.isEmpty(s1)) {
            return SWCStringUtils.isEmpty(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static String numStr4Java(String str, char c0, char c1) {
        if (str == null) {
            return null;
        }
        StringBuilder stringbuilder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c2 = str.charAt(i);
            if (c2 == c0) continue;
            if (c2 == c1) {
                stringbuilder.append('.');
                continue;
            }
            stringbuilder.append(c2);
        }
        return stringbuilder.toString();
    }

    public static String takeCommasFromNumStr(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(44) == -1) {
            return str;
        }
        return SWCStringUtils.numStr4Java(str, ',', '.');
    }

    public static String[] enumeration2StringArray(Enumeration<String> enumeration, int index) {
        int jIndex = 0;
        String[] as = new String[index];
        while (enumeration.hasMoreElements()) {
            as[jIndex++] = enumeration.nextElement();
        }
        return as;
    }

    public static byte[] chars2bytes(char[] ac) {
        byte[] abyte0 = new byte[ac.length * 2];
        int index = 0;
        for (int j = 0; j < ac.length; ++j) {
            char ch = ac[j];
            char c1 = ac[j];
            abyte0[index++] = (byte)(ch >> 8);
            abyte0[index++] = (byte)c1;
        }
        return abyte0;
    }

    public static char[] bytes2chars(byte[] abyte0) throws Exception {
        if (abyte0.length % 2 != 0) {
            throw new Exception("Cannot convert an odd number of bytes");
        }
        char[] ac = new char[abyte0.length / 2];
        int index = 0;
        for (int j = 0; j < ac.length; ++j) {
            byte byte0 = abyte0[index++];
            byte byte1 = abyte0[index++];
            ac[j] = (char)(byte0 << 8 & 0xFF00 | byte1 & 0xFF);
        }
        return ac;
    }

    public static String padStringWidth(String str, int length) {
        StringBuffer stringbuffer = null;
        if (str != null) {
            int length1;
            stringbuffer = new StringBuffer(str);
            stringbuffer.setLength(length);
            for (int l = length1 = str.length(); l < length; ++l) {
                stringbuffer.setCharAt(l, ' ');
            }
        } else {
            stringbuffer = new StringBuffer(length);
            stringbuffer.setLength(length);
            for (int k = 0; k < length; ++k) {
                stringbuffer.setCharAt(k, ' ');
            }
        }
        return stringbuffer.toString();
    }

    public static String padStringWidth(int num, int length) {
        return SWCStringUtils.padStringWidth(String.valueOf(num), length);
    }

    public static String padStringWidth(float fval, int length) {
        return SWCStringUtils.padStringWidth(String.valueOf(fval), length);
    }

    public static String padStringWidth(long lval, int length) {
        return SWCStringUtils.padStringWidth(String.valueOf(lval), length);
    }

    public static String padStringWidth(double dval, int length) {
        return SWCStringUtils.padStringWidth(String.valueOf(dval), length);
    }

    public static String toHexString(long lval, int chars) {
        char[] buf = new char[chars];
        int charPos = chars;
        while (--charPos >= 0) {
            buf[charPos] = hexDigits[(int)(lval & 0xFL)];
            lval >>>= 4;
        }
        return new String(buf);
    }

    public static String GBToUnicode(String str) {
        try {
            return new String(str.getBytes("8859_1"), "GB2312");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String unicodeToGB(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        try {
            return new String(str.getBytes("GB2312"), "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String cnulls(Object obj) {
        return SWCStringUtils.cnulls(obj, "");
    }

    public static String cnulls(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj.toString();
    }

    public static String cnulls(String str, String defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return str;
    }

    public static String cnulls(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public static String formatCurrency(double cy) {
        return NumberFormat.getCurrencyInstance().format(cy);
    }

    public static String formatNumber(double dval, int bit) {
        StringBuilder patternBuilder = new StringBuilder("#,##0");
        if (bit > 0) {
            patternBuilder.append('.');
            for (int i = 0; i < bit; ++i) {
                patternBuilder.append('0');
            }
        }
        return new DecimalFormat(patternBuilder.toString()).format(dval);
    }

    public static int compareToIgnoreCase(String str1, String str2) {
        return str1.toLowerCase(Locale.ROOT).compareTo(str2.toLowerCase(Locale.ROOT));
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.toLowerCase(Locale.ROOT).endsWith(suffix.toLowerCase(Locale.ROOT));
    }

    public static int indexOfIgnoreCase(String str, int find) {
        return str.toLowerCase().indexOf(Character.toLowerCase((char)find));
    }

    public static int indexOfIgnoreCase(String str, int find, int start) {
        return str.toLowerCase().indexOf(Character.toLowerCase((char)find), start);
    }

    public static int indexOfIgnoreCase(String str, String find) {
        return str.toLowerCase().indexOf(find.toLowerCase());
    }

    public static int indexOfIgnoreCase(String str, String find, int start) {
        return str.toLowerCase().indexOf(find.toLowerCase(), start);
    }

    public static int lastIndexOfIgnoreCase(String str, int find) {
        return str.toLowerCase().lastIndexOf(Character.toLowerCase((char)find));
    }

    public static int lastIndexOfIgnoreCase(String str, int find, int start) {
        return str.toLowerCase().lastIndexOf(Character.toLowerCase((char)find), start);
    }

    public static int lastIndexOfIgnoreCase(String str, String find) {
        return str.toLowerCase().lastIndexOf(find.toLowerCase());
    }

    public static int lastIndexOfIgnoreCase(String str, String find, int start) {
        return str.toLowerCase().lastIndexOf(find.toLowerCase(), start);
    }

    public static int occurencesOf(String str, char ch) {
        char[] arr = new char[str.length()];
        str.getChars(0, arr.length, arr, 0);
        int count = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != ch) continue;
            ++count;
        }
        return count;
    }

    public static int occurencesOfIgnoreCase(String str, char ch) {
        return SWCStringUtils.occurencesOf(str.toLowerCase(), Character.toLowerCase(ch));
    }

    public static final String replace(String chars, String oldChars, String newChars) {
        if (oldChars == null) {
            return null;
        }
        StringBuilder str = new StringBuilder(chars);
        int begin = chars.indexOf(oldChars);
        if (begin < 0) {
            return str.toString();
        }
        int end = begin + oldChars.length();
        str.replace(begin, end, newChars);
        return str.toString();
    }

    public static String replaceIgnoreCase(String chars, String oldChars, String newChars) {
        int pos;
        String lowerStr = chars.toLowerCase();
        int len = newChars.length();
        int lastPos = pos = lowerStr.indexOf(oldChars);
        while (pos > -1) {
            String firstPart = chars.substring(0, pos);
            String lastPart = chars.substring(pos + oldChars.length(), chars.length());
            chars = firstPart + newChars + lastPart;
            lastPos = pos + len;
            pos = chars.indexOf(oldChars, lastPos);
        }
        return chars;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT));
    }

    public static boolean startsWithIgnoreCase(String str, String prefix, int start) {
        return str.toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT), start);
    }

    public static String byteArrayToString(byte[] ba) {
        int length = ba.length;
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static byte[] hexFromString(String hex) {
        int len = hex.length();
        byte[] buf = new byte[(len + 1) / 2];
        int index = 0;
        int jIndex = 0;
        if (len % 2 == 1) {
            buf[jIndex++] = (byte)SWCStringUtils.fromDigit(hex.charAt(index++));
        }
        while (index < len) {
            buf[jIndex++] = (byte)(SWCStringUtils.fromDigit(hex.charAt(index++)) << 4 | SWCStringUtils.fromDigit(hex.charAt(index++)));
        }
        return buf;
    }

    public static int fromDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("invalid hex digit '" + ch + "'");
    }

    public static String escapeXMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\'') {
                output.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String escapeHTMLstr(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder output = new StringBuilder();
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char ch = input.charAt(i);
            if (ch == '&') {
                output.append("&amp;");
                continue;
            }
            if (ch == '<') {
                output.append("&lt;");
                continue;
            }
            if (ch == '>') {
                output.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                output.append("&quot;");
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String headCharUpperCase(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        String headChar = str.substring(0, 1).toUpperCase();
        if (str.length() == 1) {
            return headChar;
        }
        return headChar + str.substring(1, str.length());
    }

    public static String headCharLowerCase(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        String headChar = str.substring(0, 1).toLowerCase();
        if (str.length() == 1) {
            return headChar;
        }
        return headChar + str.substring(1, str.length());
    }

    public static String left(String str, int bit) {
        return str.substring(str.length() - bit);
    }

    public static String right(String str, int bit) {
        return str.substring(str.length() - bit, str.length());
    }

    public static boolean isJavaIdentifier(String str) {
        if (SWCStringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i]) && (i != 0 || Character.isJavaIdentifierStart(chars[i]))) continue;
            return false;
        }
        return !Arrays.asList(JAVA_KEYWORDS).contains(str);
    }

    public static boolean isJavaClassName(String name) {
        if (SWCStringUtils.isEmpty(name)) {
            return true;
        }
        if (name.startsWith(" ") || name.startsWith(".") || name.endsWith(" ") || name.endsWith(".")) {
            return false;
        }
        String[] pks = SWCStringUtils.split(name, ".");
        for (int i = 0; i < pks.length; ++i) {
            if (SWCStringUtils.isJavaIdentifier(pks[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileName(String name) {
        return !SWCStringUtils.isEmpty(name) && name.indexOf(60) <= -1 && name.indexOf(42) <= -1 && name.indexOf(47) <= -1 && name.indexOf(58) <= -1 && name.indexOf(63) <= -1 && name.indexOf(92) <= -1 && name.indexOf(34) <= -1;
    }

    public static String arrayToString(Object[] objArray, String operator) {
        if (objArray != null && objArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < objArray.length; ++i) {
                sb.append(objArray[i]);
                sb.append(operator);
            }
            if (operator != null && operator.length() > 0) {
                if (sb.indexOf(operator) == 0) {
                    sb.delete(0, operator.length());
                } else if (sb.lastIndexOf(operator) == sb.length() - operator.length()) {
                    sb.delete(sb.length() - operator.length(), sb.length());
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static String[] stringArrayAppend(String[] array, String appendObj) {
        if (array == null) {
            array = new String[]{};
        }
        String[] newArray = new String[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = appendObj;
        return newArray;
    }

    public static String trim(String str) {
        return str != null ? str.trim() : null;
    }

    public static String addBracket(String str) {
        if (SWCStringUtils.isEmpty(str)) {
            return str;
        }
        return "(" + str + ")";
    }

    public static String abbreviate(String txt, int len) {
        StringBuilder resultBuilder = new StringBuilder();
        String[] str = SWCStringUtils.splitByUpperCaseChar(txt);
        if (str.length < len) {
            String abb = SWCStringUtils.metaphone(str[0], len - str.length + 1);
            if (abb.length() == 0) {
                abb = str[0].substring(0, len - str.length + 1).toUpperCase();
            }
            abb = abb.substring(0, 1) + abb.substring(1).toLowerCase();
            resultBuilder.append(abb);
            for (int i = 1; i < str.length; ++i) {
                resultBuilder.append(str[i].charAt(0));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                resultBuilder.append(str[i].charAt(0));
            }
        }
        return resultBuilder.toString();
    }

    private static String metaphone(String txt, int maxCodeLen) {
        if (txt == null || txt.length() == 0) {
            return "";
        }
        if (maxCodeLen <= 0) {
            return "";
        }
        if (maxCodeLen > txt.length()) {
            return txt;
        }
        if (txt.length() == 1) {
            return txt.toUpperCase();
        }
        boolean hard = false;
        char[] inwd = txt.toUpperCase().toCharArray();
        StringBuilder local = new StringBuilder();
        StringBuilder code = new StringBuilder();
        switch (inwd[0]) {
            case 'G': 
            case 'K': 
            case 'P': {
                if (inwd[1] == 'N') {
                    local.append(inwd, 1, inwd.length - 1);
                    break;
                }
                local.append(inwd);
                break;
            }
            case 'A': {
                if (inwd[1] == 'E') {
                    local.append(inwd, 1, inwd.length - 1);
                    break;
                }
                local.append(inwd);
                break;
            }
            case 'W': {
                if (inwd[1] == 'R') {
                    local.append(inwd, 1, inwd.length - 1);
                    break;
                }
                if (inwd[1] == 'H') {
                    local.append(inwd, 1, inwd.length - 1);
                    local.setCharAt(0, 'W');
                    break;
                }
                local.append(inwd);
                break;
            }
            case 'X': {
                inwd[0] = 83;
                local.append(inwd);
                break;
            }
            default: {
                local.append(inwd);
            }
        }
        int wdsz = local.length();
        int sz = 0;
        while (code.length() < maxCodeLen && sz < wdsz) {
            char symb = local.charAt(sz);
            if (symb != 'C' && SWCStringUtils.isPreviousChar(local, sz, symb)) {
                ++sz;
            } else {
                switch (symb) {
                    case 'A': 
                    case 'E': 
                    case 'I': 
                    case 'O': 
                    case 'U': {
                        if (sz != 0) break;
                        code.append(symb);
                        break;
                    }
                    case 'B': {
                        if (SWCStringUtils.isPreviousChar(local, sz, 'M') && SWCStringUtils.isLastChar(wdsz, sz)) break;
                        code.append(symb);
                        break;
                    }
                    case 'C': {
                        if (SWCStringUtils.isPreviousChar(local, sz, 'S') && !SWCStringUtils.isLastChar(wdsz, sz) && FRONTV.indexOf(local.charAt(sz + 1)) >= 0) break;
                        if (SWCStringUtils.regionMatch(local, sz, "CIA")) {
                            code.append('X');
                            break;
                        }
                        if (!SWCStringUtils.isLastChar(wdsz, sz) && FRONTV.indexOf(local.charAt(sz + 1)) >= 0) {
                            code.append('S');
                            break;
                        }
                        if (SWCStringUtils.isPreviousChar(local, sz, 'S') && SWCStringUtils.isNextChar(local, sz, 'H')) {
                            code.append('K');
                            break;
                        }
                        if (SWCStringUtils.isNextChar(local, sz, 'H')) {
                            if (sz == 0 && wdsz >= 3 && SWCStringUtils.isVowel(local, 2)) {
                                code.append('K');
                                break;
                            }
                            code.append('X');
                            break;
                        }
                        code.append('C');
                        break;
                    }
                    case 'D': {
                        if (!SWCStringUtils.isLastChar(wdsz, sz + 1) && SWCStringUtils.isNextChar(local, sz, 'G') && FRONTV.indexOf(local.charAt(sz + 2)) >= 0) {
                            code.append('J');
                            sz += 2;
                            break;
                        }
                        code.append('D');
                        break;
                    }
                    case 'G': {
                        if (SWCStringUtils.isLastChar(wdsz, sz + 1) && SWCStringUtils.isNextChar(local, sz, 'H') || !SWCStringUtils.isLastChar(wdsz, sz + 1) && SWCStringUtils.isNextChar(local, sz, 'H') && !SWCStringUtils.isVowel(local, sz + 2) || sz > 0 && (SWCStringUtils.regionMatch(local, sz, "GN") || SWCStringUtils.regionMatch(local, sz, "GNED"))) break;
                        hard = SWCStringUtils.isPreviousChar(local, sz, 'G');
                        if (!SWCStringUtils.isLastChar(wdsz, sz) && FRONTV.indexOf(local.charAt(sz + 1)) >= 0 && !hard) {
                            code.append('J');
                            break;
                        }
                        code.append('G');
                        break;
                    }
                    case 'H': {
                        if (SWCStringUtils.isLastChar(wdsz, sz) || sz > 0 && VARSON.indexOf(local.charAt(sz - 1)) >= 0 || !SWCStringUtils.isVowel(local, sz + 1)) break;
                        code.append('H');
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'F': 
                    case 'J': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'R': {
                        code.append(symb);
                        break;
                    }
                    case 'K': {
                        if (sz > 0) {
                            if (SWCStringUtils.isPreviousChar(local, sz, 'C')) break;
                            code.append(symb);
                            break;
                        }
                        code.append(symb);
                        break;
                    }
                    case 'P': {
                        code.append(symb);
                        break;
                    }
                    case 'Q': {
                        code.append('Q');
                        break;
                    }
                    case 'S': {
                        if (SWCStringUtils.regionMatch(local, sz, "SH") || SWCStringUtils.regionMatch(local, sz, "SIO") || SWCStringUtils.regionMatch(local, sz, "SIA")) {
                            code.append('X');
                            break;
                        }
                        code.append('S');
                        break;
                    }
                    case 'T': {
                        if (SWCStringUtils.regionMatch(local, sz, "TIA") || SWCStringUtils.regionMatch(local, sz, "TIO")) {
                            code.append('X');
                            break;
                        }
                        if (SWCStringUtils.regionMatch(local, sz, "TCH") || SWCStringUtils.regionMatch(local, sz, "TH")) break;
                        code.append('T');
                        break;
                    }
                    case 'V': {
                        code.append('V');
                        break;
                    }
                    case 'W': 
                    case 'Y': {
                        if (SWCStringUtils.isLastChar(wdsz, sz) || !SWCStringUtils.isVowel(local, sz + 1)) break;
                        code.append(symb);
                        break;
                    }
                    case 'X': {
                        code.append('X');
                        break;
                    }
                    case 'Z': {
                        code.append('Z');
                        break;
                    }
                }
                ++sz;
            }
            if (code.length() <= maxCodeLen) continue;
            code.setLength(maxCodeLen);
        }
        return code.toString();
    }

    private static String[] splitByUpperCaseChar(String line) {
        if (line == null) {
            return null;
        }
        if ((line = line.trim()).length() == 0) {
            return new String[]{""};
        }
        ArrayList<String> list = new ArrayList<String>();
        int pos = 0;
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if ((ch < 'A' || ch > 'Z') && (ch < '0' || ch > '9')) continue;
            String str = line.substring(pos, i).trim();
            if (str.length() > 0) {
                list.add(str);
            }
            pos = i;
        }
        list.add(line.substring(pos).trim());
        return list.toArray(new String[list.size()]);
    }

    private static final boolean isVowel(StringBuilder string, int index) {
        return VOWELS.indexOf(string.charAt(index)) >= 0;
    }

    private static boolean isPreviousChar(StringBuilder string, int index, char ch) {
        boolean matches = false;
        if (index > 0 && index < string.length()) {
            matches = string.charAt(index - 1) == ch;
        }
        return matches;
    }

    private static boolean isNextChar(StringBuilder string, int index, char ch) {
        boolean matches = false;
        if (index >= 0 && index < string.length() - 1) {
            matches = string.charAt(index + 1) == ch;
        }
        return matches;
    }

    private static boolean regionMatch(StringBuilder string, int index, String test) {
        boolean matches = false;
        if (index >= 0 && index + test.length() - 1 < string.length()) {
            String substring = string.substring(index, index + test.length());
            matches = substring.equals(test);
        }
        return matches;
    }

    private static final boolean isLastChar(int wdsz, int sz) {
        return sz + 1 == wdsz;
    }

    public static String[] fastSplit(String line, int seperator) {
        if (line == null || line.length() == 0) {
            return null;
        }
        line = line.trim();
        int[] pos = new int[9];
        int iTimes = SWCStringUtils.calcSeperatorTimes(line, seperator, pos);
        String[] arr = new String[iTimes + 1];
        if (iTimes <= 0) {
            arr[0] = line;
        } else if (iTimes > 9) {
            int jIndex;
            int times = 0;
            int index = 0;
            while ((jIndex = line.indexOf(seperator, index)) >= 0) {
                arr[times] = line.substring(index, jIndex).trim();
                index = jIndex + 1;
                ++times;
            }
            arr[times] = line.substring(index).trim();
        } else {
            arr[0] = line.substring(0, pos[0]).trim();
            for (int i = 0; i < iTimes - 1; ++i) {
                arr[i + 1] = line.substring(pos[i] + 1, pos[i + 1]).trim();
            }
            arr[iTimes] = line.substring(pos[iTimes - 1] + 1).trim();
        }
        return arr;
    }

    private static int calcSeperatorTimes(String src, int seperator, int[] pos) {
        int jIndex;
        if (src == null || src.equals("")) {
            return 0;
        }
        int times = 0;
        int index = 0;
        while ((jIndex = src.indexOf(seperator, index)) >= 0) {
            if (times < 9) {
                pos[times] = jIndex;
            }
            index = jIndex + 1;
            ++times;
        }
        return times;
    }

    public static String[] fastSplit(String line, String seperator) {
        if (line == null || line.length() == 0) {
            return null;
        }
        line = line.trim();
        int[] pos = new int[9];
        int iTimes = SWCStringUtils.calcSeperatorTimes(line, seperator, pos);
        String[] arr = new String[iTimes + 1];
        if (iTimes <= 0) {
            arr[0] = line;
        } else if (iTimes > 9) {
            int jIndex;
            int times = 0;
            int index = 0;
            while ((jIndex = line.indexOf(seperator, index)) >= 0) {
                arr[times] = line.substring(index, jIndex).trim();
                index = jIndex + 1;
                ++times;
            }
            arr[times] = line.substring(index).trim();
        } else {
            arr[0] = line.substring(0, pos[0]).trim();
            for (int i = 0; i < iTimes - 1; ++i) {
                arr[i + 1] = line.substring(pos[i] + 1, pos[i + 1]).trim();
            }
            arr[iTimes] = line.substring(pos[iTimes - 1] + 1).trim();
        }
        return arr;
    }

    private static int calcSeperatorTimes(String src, String seperator, int[] pos) {
        int jIndex;
        if (src == null || src.equals("")) {
            return 0;
        }
        int times = 0;
        int index = 0;
        while ((jIndex = src.indexOf(seperator, index)) >= 0) {
            if (times < 9) {
                pos[times] = jIndex;
            }
            index = jIndex + 1;
            ++times;
        }
        return times;
    }

    public static String substringBeforeLast(String str, String separator) {
        if (SWCStringUtils.isEmpty(str) || SWCStringUtils.isEmpty(separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String replaceParamsOfMsg(String[] params, String strMsg) {
        for (int i = 0; i < params.length; ++i) {
            String replacement = params[i];
            if (null == replacement) {
                replacement = "";
            }
            strMsg = strMsg.replaceFirst("#" + i, replacement);
        }
        return strMsg;
    }

    public static String replaceOneParamOfString(String param, String strMsg) {
        String[] params = new String[]{param};
        strMsg = SWCStringUtils.replaceParamsOfMsg(params, strMsg);
        return strMsg;
    }

    public static String getMD5str(String str) {
        try {
            MessageDigest cmd = MessageDigest.getInstance("MD5");
            cmd.update(str.getBytes("utf-8"));
            byte[] resultBytes = cmd.digest();
            StringBuilder buf = new StringBuilder();
            for (byte aByte : resultBytes) {
                buf.append(String.format(Locale.ROOT, "%02X", aByte));
            }
            return buf.toString().toUpperCase();
        }
        catch (Exception arg7) {
            return "";
        }
    }

    public static LocaleString joinLocaleString(String separator, LocaleString ... localeStrings) {
        if (localeStrings == null || localeStrings.length == 0) {
            return null;
        }
        LocaleString first = localeStrings[0];
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)first.keySet().size());
        for (String lcId : first.keySet()) {
            ArrayList tempValues = Lists.newArrayListWithCapacity((int)localeStrings.length);
            for (int i = 0; i < localeStrings.length; ++i) {
                LocaleString tempLocalString = localeStrings[i];
                String str = (String)tempLocalString.get((Object)lcId);
                tempValues.add(str);
            }
            resultMap.putIfAbsent(lcId, StringUtils.join((Object[])tempValues.toArray(new String[0]), (String)separator));
        }
        return LocaleString.fromMap((Map)resultMap);
    }

    public static String join(Collection coll, char separator) {
        return StringUtils.join((Iterable)coll, (char)separator);
    }

    public static String formatException(Throwable throwable) throws IOException {
        String result = null;
        StringWriter stringWriter = null;
        PrintWriter writer = null;
        try {
            stringWriter = new StringWriter();
            writer = new PrintWriter(stringWriter);
            throwable.printStackTrace(writer);
            StringBuffer buffer = stringWriter.getBuffer();
            result = buffer.toString();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stringWriter != null) {
                stringWriter.close();
            }
        }
        return result;
    }
}

