/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.Instance;

public class SWCTypesContainer {
    private static Map<String, Class<?>> typesDict = new ConcurrentHashMap();
    private static Map<Class<?>, Object> instancesDict = new ConcurrentHashMap();
    private static TypeCreator typeCreator = new TypeCreator(){

        @Override
        public <T> T createInstance(Class<T> cls) throws Exception {
            return cls.newInstance();
        }
    };

    public static Object getOrRegisterSingletonInstance(String type) {
        Class<?> aClass = SWCTypesContainer.getOrRegister(type);
        if (aClass != null) {
            return instancesDict.computeIfAbsent(aClass, cls -> SWCTypesContainer.createInstance(cls));
        }
        return null;
    }

    public static Class<?> getOrRegister(String type) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("type");
        }
        return typesDict.computeIfAbsent(type, clsName -> {
            try {
                return Class.forName(clsName.trim());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("%s: %s not find.", Instance.getAppName(), clsName), e);
            }
        });
    }

    public static void removeRegister(String type) {
        typesDict.remove(type);
    }

    public static <T> T createInstance(String className) {
        Class<?> type = SWCTypesContainer.getOrRegister(className);
        if (type == null) {
            throw new RuntimeException(String.format(Locale.ROOT, "%1$s failed to  Create Instance.", className));
        }
        return SWCTypesContainer.createInstance(type);
    }

    public static <T> T createInstance(Class<?> cls) {
        if (cls == null) {
            throw new RuntimeException(" failed to  Create Instance,Class is Null.");
        }
        try {
            return (T)typeCreator.createInstance(cls);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ROOT, "%1$s failed to  Create Instance:" + e.getMessage(), cls.getName()), e);
        }
    }

    public static void setTypeCreator(TypeCreator typeCreator) {
        SWCTypesContainer.typeCreator = typeCreator;
    }

    @FunctionalInterface
    public static interface TypeCreator {
        public <T> T createInstance(Class<T> var1) throws Exception;
    }
}

