/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import java.util.Arrays;
import java.util.List;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class StringCheckUtils {
    private static final List<String> NUMBER_SPECIAL_CHAR_LIST = Arrays.asList("[", "]", "\u3010", "\u3011");
    private static final List<String> FULL_WIDTH_SPECIAL_CHAR_LIST = Arrays.asList("\u3001", "\uff08", "\uff09", "\uff01", "\u300a", "\u300b", "\u3002", "\uff0c", "\u3010", "\u3011", "\uffe5", "\u2026", "\u2014", "\u201c", "\uff1b", "\uff1a", "\u00b7", "~", "\u2019", "\uff1f");
    private static final String[] JAVAVARIABLEFORBIDCHAR_ARRAY = new String[]{"+", "-", "/", "*", "(", ")", "=", "<", ">", " ", ".", "@", "!", "#", "$", "%", "^", "&", "-", "`", "\"", "'", "[", "]", "{", "}", "\\"};
    private static final List<String> SPECIAL_CHAR_LIST = Arrays.asList("+", "-", "/", "*", "\"", "(", ")", "!=", "=", "<", ">", "<=", ">=", " ", ".", "@", "[", "]", ";", ":");

    public static boolean checkNameIsContainSpecialChar(String name) {
        if (name == null) {
            return false;
        }
        boolean flag = false;
        for (String specialChar : NUMBER_SPECIAL_CHAR_LIST) {
            if (name.indexOf(specialChar) == -1) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean checkNameIsContainSpecialChar(String str, List<String> specialCharList) {
        if (str == null) {
            return false;
        }
        if (CollectionUtils.isEmpty(specialCharList)) {
            return false;
        }
        boolean flag = false;
        for (String specialChar : specialCharList) {
            if (str.indexOf(specialChar) == -1) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean checkIsContainSpecialChar(String str) {
        if (str == null) {
            return false;
        }
        str = str.trim();
        boolean flag = false;
        for (String specialChar : SPECIAL_CHAR_LIST) {
            if (str.indexOf(specialChar) == -1) continue;
            flag = true;
            break;
        }
        if (!flag) {
            for (String specialChar : FULL_WIDTH_SPECIAL_CHAR_LIST) {
                if (str.indexOf(specialChar) == -1) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static boolean checkNumberIsContainJavaVariableForbidChar(String number) {
        if (number == null) {
            return false;
        }
        boolean flag = false;
        for (String specialChar : JAVAVARIABLEFORBIDCHAR_ARRAY) {
            if (number.indexOf(specialChar) == -1) continue;
            flag = true;
            break;
        }
        if (!flag) {
            for (String specialChar : FULL_WIDTH_SPECIAL_CHAR_LIST) {
                if (number.indexOf(specialChar) == -1) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static boolean isEnglishChar(String str) {
        if (SWCStringUtils.isEmpty(str)) {
            return false;
        }
        return str.matches("[a-zA-Z]+");
    }
}

