/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.export;

import java.text.MessageFormat;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCExportDynamicEntryPlugin
extends AbstractFormPlugin {
    protected static final String OP_EXPORT = "donothing_export";
    protected static final String CONFIRM_EXPORT = "confirm_exprot";
    protected static final String EXPORT_ENTRYKEY = "EXPORT_ENTRYKEY";
    protected static final String EXPORT_TOTAL = "EXPORT_TOTAL";
    protected static final Log LOGGER = LogFactory.getLog(SWCExportDynamicEntryPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OP_EXPORT.equals(operateKey)) {
            IFormView view = this.getView();
            String entryKey = (String)view.getFormShowParameter().getCustomParam(EXPORT_ENTRYKEY);
            entryKey = SWCStringUtils.isEmpty((String)entryKey) ? "entryentity" : entryKey;
            this.getView().getPageCache().put(EXPORT_ENTRYKEY, entryKey);
            int rowCount = this.getEntryRowCount(view, entryKey);
            this.getView().getPageCache().put(EXPORT_TOTAL, String.valueOf(rowCount));
            String noDataMsg = this.getNoDataMsg();
            if (rowCount == 0) {
                this.getView().showTipNotification(noDataMsg);
                return;
            }
            String msg = this.getExportConfirmMsg(rowCount);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_EXPORT, (IFormPlugin)this);
            view.showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    protected String getNoDataMsg() {
        return ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"SWCExportDynamicEntryPlugin_3", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
    }

    protected String getExportConfirmMsg(int rowCount) {
        return MessageFormat.format(ResManager.loadKDString((String)"\u672c\u6b21\u5c06\u5bfc\u51fa{0}\u884c\u6570\u636e\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u5f00\u59cb\u6267\u884c\u3002", (String)"SWCExportDynamicEntryPlugin_2", (String)"swc-hsbp-formplugin", (Object[])new Object[0]), rowCount);
    }

    protected int getEntryRowCount(IFormView view, String entryKey) {
        return view.getModel().getEntryRowCount(entryKey);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (CONFIRM_EXPORT.equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            Object mainPageId = this.getView().getFormShowParameter().getCustomParam("main_page");
            if (mainPageId != null) {
                SWCPermissionServiceHelper.checkCancelDataAndFunctionRightWithException((IFormView)this.getView().getView((String)mainPageId), (boolean)true);
            }
            FormShowParameter showParameter = this.createExportProgress(this.getView().getPageId());
            this.getView().showForm(showParameter);
        }
    }

    protected FormShowParameter createExportProgress(String pageId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbp_exportentryconfig");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("pageid", (Object)pageId);
        showParameter.setCustomParam(EXPORT_TOTAL, (Object)this.getView().getPageCache().get(EXPORT_TOTAL));
        showParameter.setCustomParam("entrykey", (Object)this.getView().getPageCache().get(EXPORT_ENTRYKEY));
        showParameter.setCustomParam("entryColumnWrapper", (Object)this.getView().getPageCache().get("EntryColumnWrapper"));
        return showParameter;
    }
}

