/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.export;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.IntegerProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.plugin.ExportEntryConfigPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.url.UrlService;
import kd.bos.userconfig.GridConfigDAO;
import kd.swc.hsbp.business.export.ListExporter;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.url.SWCURLHelper;
import kd.swc.hsbp.common.entity.EntryColumnContainer;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class SWCExportEntryConfigPlugin
extends ExportEntryConfigPlugin {
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private static final String PROGRESS_BAR = "progressbarap";
    private static final String PARAM_PAGEID = "pageid";
    private static final String PARAM_ENTRYKEY = "entrykey";
    private static final String LABEL_PROGRESS_TOTAL = "total";
    private static final String CACHE_TOTAL = "total";
    private static final String CACHE_EXPORTED = "exported";
    private static final String CACHE_URL = "url";
    private static final String EXPORT_TOTAL = "EXPORT_TOTAL";
    public static final String CUSTOM_PARAM_FETCH_DATA = "CUSTOM_PARAM_FETCH_DATA";
    public static final String CUSTOM_PARAM_EXPORT_CURPAGE = "CUSTOM_PARAM_EXPORT_CURPAGE";
    public static final String CUSTOM_PARAM_START_INDEX = "CUSTOM_PARAM_START_INDEX";
    public static final String CUSTOM_PARAM_END_INDEX = "CUSTOM_PARAM_END_INDEX";

    public void afterCreateNewData(EventObject eventObject) {
        IFormView currView = this.getView();
        ProgressBar progressbar = (ProgressBar)this.getControl(PROGRESS_BAR);
        progressbar.start();
        FormShowParameter showParameter = currView.getFormShowParameter();
        String entryKey = (String)showParameter.getCustomParam(PARAM_ENTRYKEY);
        String pageid = (String)showParameter.getCustomParam(PARAM_PAGEID);
        IFormView entryView = currView.getView(pageid);
        this.setTotalInfo(entryView, entryKey);
        this.startExporting(entryView);
    }

    private void setTotalInfo(IFormView view, String entryKey) {
        String total = String.valueOf(this.getTotalInfo(view, entryKey));
        Label progressTotal = (Label)this.getControl("total");
        progressTotal.setText(String.valueOf(total));
        this.getPageCache().put("total", total);
        this.getPageCache().put(CACHE_EXPORTED, "0");
        this.getPageCache().saveChanges();
    }

    private int getTotalInfo(IFormView view, String entryKey) {
        int total = Integer.parseInt((String)this.getView().getFormShowParameter().getCustomParam(EXPORT_TOTAL));
        return total;
    }

    private void startExporting(final IFormView entryView) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        final String entryKey = (String)showParameter.getCustomParam(PARAM_ENTRYKEY);
        final String isCustomFetchData = (String)showParameter.getCustomParam(CUSTOM_PARAM_FETCH_DATA);
        final String isExportCurPage = (String)showParameter.getCustomParam(CUSTOM_PARAM_EXPORT_CURPAGE);
        String startIndexStr = (String)showParameter.getCustomParam(CUSTOM_PARAM_START_INDEX);
        String endIndexStr = (String)showParameter.getCustomParam(CUSTOM_PARAM_END_INDEX);
        int startIndexOut = 0;
        int endIndexOut = 20;
        if (StringUtils.isNotEmpty((String)startIndexStr)) {
            startIndexOut = Integer.parseInt(startIndexStr);
        }
        if (StringUtils.isNotEmpty((String)endIndexStr)) {
            endIndexOut = Integer.parseInt(endIndexStr);
        }
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)entryView, (String)entryKey);
        final List containers = wrapper.getContainers();
        Set ignoreSet = SWCExportEntryHelper.getIgnoreColumnByFeatures((DataEntityPropertyCollection)entryView.getModel().getEntryEntity(entryKey).getDynamicObjectType().getProperties(), (boolean)false);
        this.addIgnoreSet(entryView, ignoreSet);
        SWCExportEntryHelper.removeIgnoreColumn((List)containers, (Set)ignoreSet);
        this.removeSomeByEntryConfig(containers, entryView, entryKey);
        try {
            final Map captions = SWCExportEntryHelper.getEntryFieldCaptions((List)containers);
            LocaleString caption = entryView.getModel().getProperty(entryKey).getDisplayName();
            final String entryName = caption != null && StringUtils.isNotBlank((String)caption.toString()) ? caption.getLocaleValue() : entryKey;
            final int total = this.getTotalInfo(entryView, entryKey);
            final int[] progress = new int[]{0, total};
            final int finalStartIndexOut = startIndexOut;
            final int finalEndIndexOut = endIndexOut;
            final RequestContext requestContext = RequestContext.get();
            threadPool.submit(new Callable(){

                public Object call() throws Exception {
                    RequestContext.copyAndSet((RequestContext)requestContext);
                    try {
                        ListExporter exporter = new ListExporter(entryName, containers);
                        int pageRows = 990;
                        int pages = total / pageRows + (total % pageRows == 0 ? 0 : 1);
                        int index = SWCExportEntryHelper.calcSheetHeadHeight((List)containers);
                        HashMap<String, Object> param = new HashMap<String, Object>(16);
                        param.put("pageRows", pageRows);
                        param.put(SWCExportEntryConfigPlugin.CUSTOM_PARAM_FETCH_DATA, isCustomFetchData);
                        for (int i = 1; i <= pages; ++i) {
                            int startIndex = (i - 1) * pageRows;
                            int endIndex = Math.min(i * pageRows, total);
                            if ("true".equals(isExportCurPage)) {
                                startIndex += finalStartIndexOut;
                                endIndex = Math.min(i * pageRows + finalStartIndexOut, finalEndIndexOut);
                            }
                            index = SWCExportEntryConfigPlugin.this.exportEntry(entryKey, startIndex, endIndex, entryView, exporter, captions, index, progress, param);
                        }
                        LocalDate now = LocalDate.now();
                        String url = exporter.flush(entryView.getModel().getDataEntityType(), ResManager.loadKDString((String)"\u5bfc\u51fa\u5206\u5f55_{0}{1}", (String)"SWCExportEntryConfigPlugin_3", (String)"swc-hsbp-formplugin", (Object[])new Object[]{entryName, String.format("_%02d%02d", now.getYear(), now.getMonthValue())}));
                        String fileUrl = SWCURLHelper.getSafeUrl((String)entryView.getServiceAppId(entryView.getPageId()), (String)entryView.getEntityId(), (String)UrlService.getAttachmentDownloadUrl((String)url));
                        SWCExportEntryConfigPlugin.this.getPageCache().put(SWCExportEntryConfigPlugin.CACHE_URL, fileUrl);
                        SWCExportEntryConfigPlugin.this.getPageCache().saveChanges();
                    }
                    catch (Exception e) {
                        SWCExportEntryConfigPlugin.this.log.error((Throwable)e);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
            throw new KDException(new ErrorCode("", ""), "Export exception, please check log analysis", (Throwable)e);
        }
    }

    protected void addIgnoreSet(IFormView entryView, Set<String> ignoreSet) {
    }

    private void removeSomeByEntryConfig(List<EntryColumnContainer> containers, IFormView entryView, String entryKey) {
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        List gridConfigByDB = gridConfigDAO.getGridConfig(entryView.getFormShowParameter().getFormId(), entryKey);
        if (CollectionUtils.isEmpty((Collection)gridConfigByDB)) {
            return;
        }
        Map<String, GridConfigurationRow> configMap = gridConfigByDB.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, Function.identity()));
        this.removeRecursionByEntryConfig(containers, configMap);
    }

    private void removeRecursionByEntryConfig(List<EntryColumnContainer> containers, Map<String, GridConfigurationRow> configMap) {
        if (CollectionUtils.isEmpty(containers)) {
            return;
        }
        Iterator<EntryColumnContainer> iterator = containers.iterator();
        while (iterator.hasNext()) {
            GridConfigurationRow configurationRow;
            EntryColumnContainer next = iterator.next();
            if (next.getType() == 2) {
                List child = next.getChild();
                this.removeRecursionByEntryConfig(child, configMap);
                if (CollectionUtils.isEmpty((Collection)child)) {
                    iterator.remove();
                }
            }
            if (next.getType() != 1 || null == (configurationRow = configMap.get(next.getKey())) || !configurationRow.isHide()) continue;
            iterator.remove();
        }
    }

    private int exportEntry(String entryKey, int startIndex, int endIndex, IFormView entryView, ListExporter exporter, Map<String, KeyValue> captions, int excelRowIndex, int[] progress, Map<String, Object> param) {
        IDataModel model = entryView.getModel();
        DynamicObject[] rows = this.getEntryEntity(entryView, entryKey, startIndex, endIndex, model, param);
        if (rows == null || rows.length == 0) {
            return excelRowIndex;
        }
        ArrayList<String> rowdata = new ArrayList<String>(captions.size());
        for (int i = 0; i < rows.length; ++i) {
            DynamicObject row = rows[i];
            for (String filedName : captions.keySet()) {
                Number tempValue;
                IDataEntityProperty property = model.getProperty(filedName);
                Object val = null;
                if (property instanceof IntegerProp) {
                    tempValue = (Integer)property.getValue((Object)row);
                    val = tempValue == null ? "" : ((Integer)tempValue).toString();
                } else if (property instanceof DecimalProp) {
                    tempValue = (BigDecimal)property.getValue((Object)row);
                    DecimalProp tempDecimalProp = (DecimalProp)property;
                    int scale = tempDecimalProp.getScale();
                    if (StringUtils.isNotEmpty((String)tempDecimalProp.getControlPropName())) {
                        IDataEntityProperty property1 = model.getProperty(tempDecimalProp.getControlPropName());
                        if (property1 != null) {
                            DynamicObject currency = (DynamicObject)property1.getValue((Object)row);
                            if (currency != null) {
                                scale = currency.getInt("amtprecision");
                            }
                        } else {
                            BigDecimal value;
                            IDataEntityProperty property2 = model.getProperty(tempDecimalProp.getName());
                            if (property2 != null && (value = (BigDecimal)property2.getValue((Object)row)) != null) {
                                scale = value.scale();
                            }
                        }
                    }
                    val = tempValue == null ? "" : ((BigDecimal)tempValue).setScale(scale, tempDecimalProp.getRoundingMode()).toPlainString();
                } else if (property instanceof DateProp) {
                    Date value = (Date)property.getValue((Object)row);
                    if (value != null) {
                        SimpleDateFormat sdf = (SimpleDateFormat)((DateProp)property).getDateFormat();
                        String mask = ((DateProp)property).getMask();
                        if (mask != null) {
                            sdf = new SimpleDateFormat(mask);
                        }
                        sdf.setTimeZone(KDDateUtils.getTimeZone());
                        val = sdf.format(value);
                    }
                } else if (property instanceof IFieldHandle) {
                    val = ((IFieldHandle)property).getBasePropDisplayValue((Object)row);
                }
                rowdata.add((String)val);
            }
            exporter.writeLine(rowdata, excelRowIndex++);
            rowdata.clear();
            progress[0] = progress[0] + 1;
            if (i % 1000 != 0) continue;
            this.getPageCache().put(CACHE_EXPORTED, String.valueOf(progress[0]));
            this.getPageCache().saveChanges();
        }
        this.getPageCache().put(CACHE_EXPORTED, String.valueOf(progress[0]));
        this.getPageCache().saveChanges();
        return excelRowIndex;
    }

    protected DynamicObject[] getEntryEntity(IFormView entryView, String entryKey, int startIndex, int endIndex, IDataModel model, Map<String, Object> param) {
        DynamicObject[] rows;
        block5: {
            rows = new DynamicObject[]{};
            if ("true".equals(param.get(CUSTOM_PARAM_FETCH_DATA))) {
                EntryGrid grid = (EntryGrid)entryView.getControl(entryKey);
                try {
                    if (model.getDataEntityType().getName().equals("hcdm_adjapprbill")) {
                        Method getEntryDataEntities = ReflectionUtils.findMethod(grid.getClass(), (String)"getEntryDataDbEntities", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
                        ReflectionUtils.makeAccessible((Method)getEntryDataEntities);
                        int pageRows = (Integer)param.get("pageRows");
                        rows = (DynamicObject[])getEntryDataEntities.invoke((Object)grid, startIndex, pageRows);
                        this.log.info("entryKey is:{0},startIndex is:{1},endIndex is:{2}", new Object[]{entryKey, startIndex, pageRows});
                        break block5;
                    }
                    this.log.info("entryKey is:{0},startIndex is:{1},endIndex is:{2}", new Object[]{entryKey, startIndex, endIndex});
                    Method getEntryDataEntities = ReflectionUtils.findMethod(grid.getClass(), (String)"getEntryDataEntities", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
                    ReflectionUtils.makeAccessible((Method)getEntryDataEntities);
                    rows = (DynamicObject[])getEntryDataEntities.invoke((Object)grid, startIndex, endIndex);
                }
                catch (Exception exc) {
                    this.log.error("SWCExportEntryConfigPlugin.getEntryEntity error:{0}", (Throwable)exc);
                }
            } else {
                rows = model.getEntryEntity(entryKey, startIndex, endIndex);
            }
        }
        return rows;
    }
}

