/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.imports;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.business.export.ListExporter;
import kd.swc.hsbp.business.export.ListTemplateExporter;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.imports.ValidateResults;
import kd.swc.hsbp.business.log.SWCOpLogServiceHelper;
import kd.swc.hsbp.common.constants.ImportConstants;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.event.BeforeWriteTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import kd.swc.hsbp.formplugin.imports.event.DownLoadTemplateEvent;
import kd.swc.hsbp.formplugin.imports.event.LoadCustomEntryMetasEvent;
import kd.swc.hsbp.formplugin.imports.event.OnGetImportConfigEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DynamicEntryImportStartEdit
extends AbstractFormPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(DynamicEntryImportStartEdit.class);
    public static final String IMPORT_START_CLOSECALLBACK = "ImportStartCloseCallBack";
    private static final String FILEPATH = "filepath";
    private static final String FILEPANEL = "filepanel";
    private static final Integer fixHeadHeight = 3;
    private List<IDataPort> dataPortService;
    private ImportConfig importConfig;
    private final String SWC_HSBP_FORMPLUGIN = "swc-hsbp-formplugin";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
        this.dataPortService = this.getDataPortService();
        this.importConfig = this.invokeGetImportConfig();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"ImportProcessCallBack")) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        String showImportType;
        this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
        Label title = (Label)this.getControl("title");
        String titleTips = ResManager.loadKDString((String)"\u5c06\u6570\u636e\u5bfc\u5165\u5230%1$s", (String)"DynamicEntryImportStartEdit_20", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
        String text = String.format(Locale.ROOT, titleTips, this.getEntryView().getModel().getDataEntityType().getDisplayName().toString());
        title.setText(text);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String hideImportType = (String)parameter.getCustomParam("hideImportType");
        if (SWCStringUtils.isNotEmpty((String)hideImportType)) {
            String[] hideImportTypeArray = hideImportType.split(",");
            this.getView().setVisible(Boolean.FALSE, hideImportTypeArray);
        }
        if (SWCStringUtils.isNotEmpty((String)(showImportType = (String)parameter.getCustomParam("showImportType")))) {
            String[] showImportTypeArray = showImportType.split(",");
            String defaultValue = showImportTypeArray[0];
            this.getModel().setValue("importtype", (Object)defaultValue);
        }
        if (SWCStringUtils.isEmpty((String)hideImportType) && SWCStringUtils.isEmpty((String)showImportType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"new", "override"});
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            final IFormView view = this.getView();
            String url = (String)urls[0];
            FileService service = FileServiceFactory.getAttachmentFileService();
            final ArrayList dataHead = Lists.newArrayListWithCapacity((int)this.importConfig.getHeadHeight());
            final ArrayList dataRow = Lists.newArrayListWithCapacity((int)this.importConfig.getHeadHeight());
            final BooleanWrapperHolder hasRowDataWhenIsPartial = new BooleanWrapperHolder(Boolean.FALSE);
            final BooleanWrapperHolder isMaxRowCount = new BooleanWrapperHolder(Boolean.FALSE);
            final int endHeight = this.getEntryHeadEndHeight();
            try (InputStream in = service.getInputStream(url);){
                new ExcelReader().read(in, new SheetHandler(){

                    public void handleRow(SheetHandler.ParsedRow row) {
                        if (row.getRowNum() < fixHeadHeight - 1) {
                            return;
                        }
                        if (row.getRowNum() <= endHeight) {
                            dataHead.add(row.getData());
                        } else if (DynamicEntryImportStartEdit.this.importConfig.getImportType() == ImportConfig.ImportType.Partial) {
                            if (!row.isEmpty()) {
                                hasRowDataWhenIsPartial.value = Boolean.TRUE;
                                this.setInterrupt(true);
                            }
                        } else {
                            dataRow.add(row.getData());
                        }
                    }

                    public void setRowCount(int rowCount) {
                        if (rowCount - DynamicEntryImportStartEdit.this.getEntryHeadEndHeight() - 1 > DynamicEntryImportStartEdit.this.importConfig.getMaxRowCount()) {
                            String formatString = MessageFormat.format("{0}{1}\uff0c{2}", ResManager.loadKDString((String)"\u6700\u5927\u884c\u9650\u5236", (String)"DynamicEntryImportStartEdit_0", (String)"swc-hsbp-formplugin", (Object[])new Object[0]), DynamicEntryImportStartEdit.this.importConfig.getMaxRowCount(), ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"DynamicEntryImportStartEdit_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
                            view.showMessage(formatString);
                            isMaxRowCount.value = Boolean.TRUE;
                        }
                    }
                });
            }
            catch (KDBizException e) {
                ErrorCode code = e.getErrorCode();
                if (code == null || !"ValidFile".equalsIgnoreCase(code.getCode())) {
                    view.showErrorNotification(e.getMessage());
                    return;
                }
            }
            catch (Throwable e) {
                log.error(e);
                String IMPORT_START_ERROR = ResManager.loadKDString((String)"\u8be6\u60c5\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"DynamicEntryImportStartEdit_2", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
                view.showMessage(ImportConstants.IMPORT_TEMPLATE_ERROR(), e instanceof KDBizException ? e.getMessage() : IMPORT_START_ERROR, MessageTypes.Default);
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4e0a\u4f20", "DynamicEntryImportStartEdit_12", "swc-hsbp-formplugin");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u683c\u5f0f\u9519\u8bef", "DynamicEntryImportStartEdit_19", "swc-hsbp-formplugin");
                SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"upload", (MultiLangEnumBridge)opNameBridge, (String)"", (MultiLangEnumBridge)opDescBridge, (String[])new String[0]);
                return;
            }
            if (isMaxRowCount.value.booleanValue()) {
                return;
            }
            ValidateResults validateResult = this.invokeOnValidateTemplate(dataHead, dataRow);
            if (validateResult.isSuccess()) {
                if (this.importConfig.getImportType() == ImportConfig.ImportType.Partial && !hasRowDataWhenIsPartial.value.booleanValue()) {
                    view.showMessage(ImportConstants.PARSED_INVALID_DATA(), ImportConstants.LOGGING_DATA(), MessageTypes.Default);
                    MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u4e0a\u4f20", "DynamicEntryImportStartEdit_12", "swc-hsbp-formplugin");
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", "DynamicEntryImportStartEdit_13", "swc-hsbp-formplugin");
                    SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"upload", (MultiLangEnumBridge)opNameBridge, (String)"", (MultiLangEnumBridge)opDescBridge, (String[])new String[0]);
                    return;
                }
                view.setVisible(Boolean.TRUE, new String[]{FILEPANEL});
                view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
                IDataModel model = this.getModel();
                model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
                model.setValue(FILEPATH, (Object)url);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                this.downloadTemplate();
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue(FILEPATH, (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
        }
    }

    private void downloadTemplate() {
        this.startExport(this.getEntryView());
        this.invokeAfterDownLoadTemplate();
    }

    private void startExport(IFormView entryView) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entryKey = (String)showParameter.getCustomParam("entrykey");
        EntryColumnWrapper wrapper = this.invokeLoadCustomDataSource();
        Set ignoreSet = SWCExportEntryHelper.getIgnoreColumnByFeatures((DataEntityPropertyCollection)entryView.getModel().getEntryEntity(entryKey).getDynamicObjectType().getProperties(), (boolean)true);
        SWCExportEntryHelper.removeIgnoreColumn((List)wrapper.getContainers(), (Set)ignoreSet);
        List containers = wrapper.getContainers();
        try {
            Map captions = SWCExportEntryHelper.getEntryFieldCaptions((List)containers);
            LocaleString caption = entryView.getModel().getProperty(entryKey).getDisplayName();
            String entryName = caption != null && StringUtils.isNotBlank((String)caption.toString()) ? caption.toString() : entryKey;
            EntityType entityType = (EntityType)this.getEntryView().getModel().getDataEntityType().getAllEntities().get(entryKey);
            ListTemplateExporter exporter = new ListTemplateExporter(containers, entityType, this.importConfig);
            int index = SWCExportEntryHelper.calcSheetHeadHeight((List)containers) + fixHeadHeight;
            DynamicObjectCollection rows = this.invokeBeforeWriteTemplate();
            if (rows == null) {
                rows = entryView.getModel().getEntryEntity(entryKey);
            }
            if (this.importConfig.getImportType() == ImportConfig.ImportType.Complete) {
                this.exportEntryTemplate(entryView.getModel(), rows, (ListExporter)exporter, captions, index, this.importConfig);
            }
            this.invokeBeforeDownLoadTemplate(exporter.getWb());
            String templateFileName = this.invokeGetTemplateFileName();
            if (templateFileName == null) {
                templateFileName = this.importConfig.getTemplateFileName();
            }
            String url = exporter.flush(entryView.getModel().getDataEntityType(), templateFileName);
            this.getView().download(UrlService.getAttachmentFullUrl((String)url));
            this.getView().sendFormAction(this.getView());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private int exportEntryTemplate(IDataModel model, DynamicObjectCollection rows, ListExporter exporter, Map<String, KeyValue> captions, int excelRowIndex, ImportConfig importConfig) {
        ArrayList<Object> rowdata = new ArrayList<Object>(captions.size());
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            for (String filedName : captions.keySet()) {
                DateFormat dateFormat;
                Object value;
                IDataEntityProperty prop = model.getProperty(filedName);
                Object val = null;
                if (prop instanceof BooleanProp) {
                    val = Boolean.TRUE.equals(prop.getValue((Object)row)) ? ResManager.loadKDString((String)"\u662f", (String)"DynamicEntryImportStartEdit_4", (String)"swc-hsbp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"DynamicEntryImportStartEdit_5", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
                } else if (prop instanceof MulBasedataProp) {
                    value = (DynamicObjectCollection)prop.getValue((Object)row);
                    BasedataProp refBaseProp = (BasedataProp)((MulBasedataProp)prop).getRefBaseProp();
                    ArrayList<String> valStrs = new ArrayList<String>(value.size());
                    for (int j = 0; j < value.size(); ++j) {
                        DynamicObject baseDataObj = ((DynamicObject)value.get(j)).getDynamicObject((IDataEntityProperty)refBaseProp);
                        String displayValue = refBaseProp.getDisplayValue((Object)baseDataObj);
                        valStrs.add(j, displayValue);
                    }
                    val = String.join((CharSequence)";", valStrs);
                } else if (prop instanceof DecimalProp) {
                    val = prop.getValue((Object)row);
                    if (null != val) {
                        NumberPrecision number = new NumberPrecision(((DecimalProp)prop).getScale(), null, false, new BigDecimal(val.toString()));
                        val = number.toString();
                    }
                } else if (prop instanceof BasedataProp) {
                    DynamicObject dy = (DynamicObject)prop.getValue((Object)row);
                    val = ((BasedataProp)prop).getDisplayValue((Object)dy);
                } else if (prop instanceof DateProp) {
                    value = (Date)prop.getValue((Object)row);
                    if (null != value) {
                        dateFormat = ((DateProp)prop).getDateFormat();
                        val = dateFormat.format((Date)value);
                    }
                } else if (prop instanceof DateTimeProp) {
                    value = (Date)prop.getValue((Object)row);
                    if (null != value) {
                        dateFormat = ((DateTimeProp)prop).getDateFormat();
                        val = dateFormat.format((Date)value);
                    }
                } else {
                    val = prop.getValue((Object)row);
                }
                rowdata.add(val);
            }
            exporter.writeLine(rowdata, excelRowIndex++);
            rowdata.clear();
        }
        return excelRowIndex;
    }

    private void importData() {
        String url = this.getModel().getDataEntity().getString(FILEPATH);
        if (StringUtils.isBlank((String)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"DynamicEntryImportStartEdit_8", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5f00\u59cb\u4e0a\u4f20", "DynamicEntryImportStartEdit_10", "swc-hsbp-formplugin");
            MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u4e0a\u4f20\u5931\u8d25\uff0c\u672a\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u3002", "DynamicEntryImportStartEdit_11", "swc-hsbp-formplugin");
            SWCOpLogServiceHelper.addOpLog((IFormView)this.getView(), (String)"importdata", (MultiLangEnumBridge)opNameBridge, (String)"", (MultiLangEnumBridge)opDescBridge, (String[])new String[0]);
            return;
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String entryKey = (String)params.get("entrykey");
        String pageId = this.getView().getPageId();
        IFormView mainView = this.getView().getMainView();
        String rootPageId = mainView == null ? pageId : mainView.getPageId();
        String entryName = this.getEntryView().getModel().getDataEntityType().getProperty(entryKey).getDisplayName().toString();
        String nameSuffix = ResManager.loadKDString((String)"\u5bfc\u5165", (String)"DynamicEntryImportStartEdit_16", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
        String time = SWCDateTimeUtils.format((Date)TimeServiceHelper.now(), (String)"MM-dd HH:mm", null);
        String name = entryName + nameSuffix + " " + time;
        params.put("requestContext", RequestContext.get());
        params.put("entityname", entryName);
        params.put("importfile_url", url);
        params.put("importtype", this.getModel().getValue("importtype"));
        String taskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_hsbp_dynamicentry_import", name, false, rootPageId, pageId, params);
        params.put("taskId", taskId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hsbp_importingnew");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ImportProcessCallBack"));
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
        if (mainView != null) {
            HRBackgroundTaskHelper.getInstance().setProgressPageId(mainView, taskId, showParameter.getPageId());
        }
        IFormView bizPage = this.getView().getParentView();
        this.getView().sendFormAction(bizPage);
    }

    private int getEntryHeadEndHeight() {
        return this.importConfig.getHeadHeight() + fixHeadHeight - 1;
    }

    private List<IDataPort> getDataPortService() {
        FormViewPluginProxy service = (FormViewPluginProxy)this.getEntryView().getService(FormViewPluginProxy.class);
        ArrayList dataPortPlugins = Lists.newArrayListWithExpectedSize((int)service.getPlugIns().size());
        for (IFormPlugin plugIn : service.getPlugIns()) {
            if (!(plugIn instanceof IDataPort)) continue;
            dataPortPlugins.add((IDataPort)plugIn);
        }
        if (dataPortPlugins.size() <= 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u7ed1\u5b9a\u81f3\u5c11\u4e00\u4e2a\u5bfc\u5165\u670d\u52a1\u63d2\u4ef6", (String)"DynamicEntryImportStartEdit_17", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
        }
        return dataPortPlugins;
    }

    private IFormView getEntryView() {
        String entryViewPageId = (String)this.getView().getFormShowParameter().getCustomParam("entryview");
        return this.getView().getView(entryViewPageId);
    }

    private void invokeBeforeDownLoadTemplate(SXSSFWorkbook wb) {
        DownLoadTemplateEvent event = new DownLoadTemplateEvent((Object)this, wb);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.beforeDownLoadTemplate(event);
        }
    }

    private void invokeAfterDownLoadTemplate() {
        DownLoadTemplateEvent event = new DownLoadTemplateEvent((Object)this);
        for (IDataPort plugin : this.dataPortService) {
            plugin.afterDownLoadTemplate(event);
        }
    }

    private ImportConfig invokeGetImportConfig() {
        OnGetImportConfigEvent event = new OnGetImportConfigEvent((Object)this);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.onGetImportConfig(event);
        }
        ImportConfig importConfig = event.getImportConfig();
        this.setEntryHeadHeight(importConfig);
        return importConfig;
    }

    private void setEntryHeadHeight(ImportConfig importConfig) {
        if (importConfig.getHeadHeight() > 0) {
            return;
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entryKey = (String)showParameter.getCustomParam("entrykey");
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)this.getEntryView(), (String)entryKey);
        int height = SWCExportEntryHelper.calcSheetHeadHeight((List)wrapper.getContainers());
        importConfig.setHeadHeight(height);
    }

    private ValidateResults invokeOnValidateTemplate(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow) {
        if (!dataHead.isEmpty()) {
            Map<Integer, String> map = dataHead.get(dataHead.size() - 1);
            for (Map.Entry entry : map.entrySet()) {
                String value = (String)entry.getValue();
                if (!value.contains("*")) continue;
                String trim = value.replaceFirst("\\*", "").trim();
                entry.setValue(trim);
            }
        }
        DataImportEvent event = new DataImportEvent((Object)this, dataHead, dataRow);
        for (IDataPort iDataPort : this.dataPortService) {
            iDataPort.onValidateTemplate(event);
        }
        return event.getValidateResults();
    }

    private int invokeGetEffectiveDataRow(List<Map<Integer, String>> dataHead, List<Map<Integer, String>> dataRow) {
        DataImportEvent event = new DataImportEvent((Object)this, dataHead, dataRow);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.beforeImport(event);
        }
        if (event.getEffectiveDataRow() > 0) {
            return event.getEffectiveDataRow();
        }
        return dataRow.size();
    }

    private EntryColumnWrapper invokeLoadCustomDataSource() {
        LoadCustomEntryMetasEvent event = new LoadCustomEntryMetasEvent((Object)this);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.loadCustomEntryMetas(event);
        }
        return event.getEntryColumnWrapper();
    }

    private DynamicObjectCollection invokeBeforeWriteTemplate() {
        BeforeWriteTemplateEvent event = new BeforeWriteTemplateEvent((Object)this);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.beforeWriteTemplate(event);
        }
        return event.getDynamicObjectCollection();
    }

    private String invokeGetTemplateFileName() {
        OnGetImportConfigEvent event = new OnGetImportConfigEvent((Object)this);
        for (IDataPort dataPort : this.dataPortService) {
            dataPort.getTemplateFileName(event);
        }
        String templateFileName = null;
        if (event.getImportConfig() != null) {
            templateFileName = event.getImportConfig().getTemplateFileName();
        }
        return templateFileName;
    }
}

