/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.imports;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.EntryImportStarter;
import kd.swc.hsbp.formplugin.imports.EntryProgressHandler;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;

public class EntryDataProcesser
implements Callable {
    private static final Log log = LogFactory.getLog(EntryDataProcesser.class);
    private EntryImportStarter entryImportStarter;

    public EntryDataProcesser(EntryImportStarter entryImportStarter) {
        this.entryImportStarter = entryImportStarter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        block18: {
            EntryImportContext importContext = this.entryImportStarter.getImportContext();
            ImportConfig importConfig = importContext.getImportConfig();
            LinkedBlockingQueue<Map<Integer, String>> dataQueue = this.entryImportStarter.getDataQueues();
            boolean needSplitBatchImport = importConfig.isNeedSplitBatchImport();
            try {
                if (needSplitBatchImport) {
                    int idleRunsNumber = 0;
                    while (!this.entryImportStarter.isDataProcessStop()) {
                        ArrayList<Map<Integer, String>> billDataList = new ArrayList<Map<Integer, String>>(1000);
                        int currBatchSize = dataQueue.drainTo(billDataList, 1000);
                        if (currBatchSize == 0) {
                            if (++idleRunsNumber == 120) {
                                log.error("EntryDataProcesser has been interrupted,because idleRunsNumber ={}", (Object)120);
                                break block18;
                            }
                            try {
                                TimeUnit.MILLISECONDS.sleep(500L);
                            }
                            catch (InterruptedException exp) {
                                log.error("EntryDataProcesser has been interrupted.", (Throwable)exp);
                                throw exp;
                            }
                        }
                        idleRunsNumber = 0;
                        this.handleAndStore(billDataList);
                        if (!this.entryImportStarter.isExcelReaderEnd()) continue;
                        while (true) {
                            if ((currBatchSize = dataQueue.drainTo(billDataList = new ArrayList(1000), 1000)) == 0) {
                                break block18;
                            }
                            this.handleAndStore(billDataList);
                        }
                    }
                    break block18;
                }
                while (true) {
                    if (this.entryImportStarter.isExcelReaderEnd()) {
                        ArrayList<Map<Integer, String>> billDataList = new ArrayList<Map<Integer, String>>(1000);
                        dataQueue.drainTo(billDataList);
                        if (!billDataList.isEmpty()) {
                            this.handleAndStore(billDataList);
                        }
                        break;
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException exp) {
                        log.error("EntryDataProcesser has been interrupted.", (Throwable)exp);
                        throw exp;
                    }
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.entryImportStarter.writeErrorLog(e);
            }
            finally {
                this.entryImportStarter.setDataProcessStop(true);
                this.entryImportStarter.notifyWhenEnd();
            }
        }
        return null;
    }

    private void handleAndStore(List<Map<Integer, String>> dataRow) {
        List<Map<Integer, String>> dataHead = this.entryImportStarter.getDataHead();
        EntryProgressHandler processHandler = this.entryImportStarter.getImportContext().getProcessHandler();
        List<IDataPort> importServices = this.entryImportStarter.getImportContext().getImportServices();
        DataImportEvent event = new DataImportEvent(this, dataHead, dataRow);
        event.setProcessHandler(processHandler);
        event.setImportContext(this.entryImportStarter.getImportContext());
        for (IDataPort plugin : importServices) {
            plugin.dataImport(event);
        }
    }

    public EntryImportStarter getEntryImportStarter() {
        return this.entryImportStarter;
    }

    public void setEntryImportStarter(EntryImportStarter entryImportStarter) {
        this.entryImportStarter = entryImportStarter;
    }
}

