/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.imports;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.cache.IAppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.ProgressHandler;
import org.apache.commons.lang3.StringUtils;

public class EntryProgressHandler
extends ProgressHandler
implements Serializable {
    private static final long serialVersionUID = 5700387454613322118L;
    @JsonIgnore
    private EntryImportContext importContext;
    private int emptyRow;
    private int lastSavedProgress = -1;
    private String taskId;
    @JsonIgnore
    private IAppCache appCache;
    private static Log log = LogFactory.getLog(EntryProgressHandler.class);
    @JsonIgnore
    private List<String> errorLogCache = Lists.newArrayListWithCapacity((int)10);

    public EntryProgressHandler() {
    }

    public EntryProgressHandler(EntryImportContext importContext) {
        this.importContext = importContext;
        this.taskId = importContext.getTaskid();
        this.appCache = SWCAppCache.get((String)"hsbp");
    }

    public int getEmptyRow() {
        return this.emptyRow;
    }

    public void setEmptyRow(int emptyRow) {
        this.emptyRow = emptyRow;
    }

    @Override
    public void incrByProgress(int success, int failed) {
        this.successRow += success;
        this.failedRow += failed;
        this.handled += success + failed;
        if (this.lastSavedProgress == -1) {
            this.cacheData();
            this.lastSavedProgress = this.handled;
        } else {
            int step = this.handled - this.lastSavedProgress;
            if (step >= 100 || this.handled == this.total) {
                this.cacheData();
                this.lastSavedProgress = this.handled;
            }
        }
    }

    @Override
    public void cacheData() {
        String processContent = null;
        try {
            processContent = SWCJSONUtils.toString((Object)this);
        }
        catch (IOException e) {
            log.error("json\u89e3\u6790\u62a5\u9519", (Throwable)e);
        }
        String key = EntryProgressHandler.getCacheKey(this.taskId);
        this.appCache.put(key, (Object)processContent);
        HRBackgroundTaskHelper.getInstance().feedbackProgress(this.taskId, this.getProgress(), "", null);
    }

    private static String getCacheKey(String taskid) {
        return String.format("%s_entryimp_progressDataCache_%s", RequestContext.get().getAccountId(), taskid);
    }

    public List<String> getErrorLogCache() {
        return this.errorLogCache;
    }

    public static EntryProgressHandler fromTask(String taskId) {
        String key;
        EntryProgressHandler hand = null;
        ISWCAppCache appCache = SWCAppCache.get((String)"hsbp");
        String cache = (String)appCache.get(key = EntryProgressHandler.getCacheKey(taskId), String.class);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            try {
                hand = (EntryProgressHandler)SWCJSONUtils.cast((String)cache, EntryProgressHandler.class);
            }
            catch (IOException e) {
                log.error("json\u89e3\u6790\u62a5\u9519", (Throwable)e);
            }
        }
        return hand;
    }

    public void endProgress(boolean withError) {
        this.handled = this.total;
        this.failedRow = withError ? this.total : this.total - this.successRow;
        this.cacheData();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }
}

